rotator = {};
rotator.modDir = g_currentModDirectory;

function rotator.prerequisitesPresent(specializations)
    return true;
end;

function rotator:load(xmlFile)
	self.new_image = Overlay:new("new_image", (rotator.modDir.."scripts/bg.dds"), 0.826, 0.13, 0.2, 0.03);
	self.table_rotator_index = {};
	self.table_rotator_axis = {};
	self.table_rotator_spin = {};
	self.table_rotator_speed = {};
	self.table_rotator_rpm_depend = {};
	
	self.rotator_count = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotators#rotatorCount"));
	self.rotator_rpm_hud = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotators#rpmHud"));
	
	local string_rot_parts;
	local rotator_index;
	local rotator_axis;
	local rotator_spin;
	local rotator_rpm_depend;
	
	for i = 1, self.rotator_count do
		string_rot_parts = string.format("vehicle.rotators.rotatorPart%d", i);
		rotator_index = Utils.indexToObject(self.components, getXMLString(xmlFile, string_rot_parts .. "#index"));
		rotator_axis = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorAxis"));
		rotator_spin = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorSpin"));
		rotator_speed = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorSpeed"));
		rotator_rpm_depend = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorRpmDepend"));
		
		table.insert(self.table_rotator_index, rotator_index);
		table.insert(self.table_rotator_axis, rotator_axis);
		table.insert(self.table_rotator_spin, rotator_spin);
		table.insert(self.table_rotator_speed, rotator_speed);
		table.insert(self.table_rotator_rpm_depend, rotator_rpm_depend);
		i = i + 1;
	end;
end;

function rotator:delete()
end;

function rotator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotator:keyEvent(unicode, sym, modifier, isDown)
end;

function rotator:update(dt)
	if self.isMotorStarted then
		if self.rotator_rpm_hud == 1 then
			if g_currentMission.controlledVehicle == self then
				text_1 = string.format("RPM: %d об/мин", self.motor.lastMotorRpm);
				setTextBold(false);
				setTextAlignment(text_1.ALIGN_LEFT);
				renderText(0.84 ,0.14, 0.015, text_1);
			end;
		end;
		local rot_speed;
		local rot_axis;
		local rot_rpm_depend;
		for i = 1, self.rotator_count do
			rot_axis = self.table_rotator_axis[i];
			rot_rpm_depend = self.table_rotator_rpm_depend[i];
			if rot_rpm_depend == 1 then
				rot_speed = self.motor.lastMotorRpm*0.0003*self.table_rotator_spin[i]*self.table_rotator_speed[i];
			elseif rot_rpm_depend == 0 then
				rot_speed = dt*0.01*self.table_rotator_spin[i]*self.table_rotator_speed[i];
			end;
			if rot_axis == 1 then
				rotate(self.table_rotator_index[i], rot_speed, 0, 0);
			elseif rot_axis == 2 then
				rotate(self.table_rotator_index[i], 0, rot_speed, 0);
			elseif rot_axis == 3 then
				rotate(self.table_rotator_index[i], 0, 0, rot_speed);
			end;
			i = i + 1;
		end;
	end;
end;

function rotator:draw()
	if self.isMotorStarted then
		if self.rotator_rpm_hud == 1 then
			self.new_image:render();
		end;
	end;
end;
