-- foldableHydraulic
--
-- @author		madabub
--
-- @date:		08/04/14
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for noncommercial-usage

foldableHydraulic = {}; 

function foldableHydraulic.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations); 
end;

function foldableHydraulic:load(xmlFile)
	self.foldableHydraulic = {};
	self.foldableHydraulic.animationName = getXMLString(xmlFile, "vehicle.foldableHydraulic#animationName");
	self.foldableHydraulic.hydraulicIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.foldableHydraulic#hydraulicIndex"), 2);
	self.updateJoint = false;
end;

function foldableHydraulic:delete()
end;

function foldableHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function foldableHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function foldableHydraulic:update(dt)
end;

function foldableHydraulic:draw()
end;

function foldableHydraulic:attachImplement(implement)
	if implement.jointDescIndex == self.foldableHydraulic.hydraulicIndex then
		if self.foldableHydraulic.animationName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.foldableHydraulic.animationName, 1, nil, true);
		end;
	end;
	self.updateJoint = true;
end;

function foldableHydraulic:detachImplement(implementIndex)
	if self.attachedImplements[implementIndex].jointDescIndex == self.foldableHydraulic.hydraulicIndex then
		if self.foldableHydraulic.animationName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.foldableHydraulic.animationName, -1, nil, true);
		end;
	end;
end;

function foldableHydraulic:validateAttacherJoint(implement, jointDesc, dt)
	if self.updateJoint then
		self.updateJoint = false;
		return true;
	end;
	return false;
end;