﻿-- author  Mythos
-- date  23/01/2012
-- www.ARM-Team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

Ford8340 = {};

function Ford8340.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:load(xmlFile)
	-- Functions
	self.OPER= SpecializationUtil.callSpecializationsFunction("OPER");	
	-- Animations
	self.rdAnim = getXMLString(xmlFile, "vehicle.rdAnim#animationName");
	self.ldAnim = getXMLString(xmlFile, "vehicle.ldAnim#animationName");
	self.bwAnim = getXMLString(xmlFile, "vehicle.bwAnim#animationName");
end;

function Ford8340:delete()
end;
function Ford8340:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Ford8340:keyEvent(unicode, sym, modifier, isDown)
end;

function Ford8340:update(dt)
	if self:getIsActiveForInput() and self:getIsActive() then		
		if InputBinding.hasEvent(InputBinding.F8340_RD) then
			self:OPER(1, not self.rd);
		end;
		
		if InputBinding.hasEvent(InputBinding.F8340_LD) then
			self:OPER(2, not self.ld);
		end;
		
		if InputBinding.hasEvent(InputBinding.F8340_BW) then
			self:OPER(3, not self.bw);
		end;
	end;	
end;

function Ford8340:updateTick(dt)
end;
function Ford8340:draw()
end;

function Ford8340:OPER(mode, state, noEventSend)
	Ford8340Event.sendEvent(self, mode, state, noEventSend);	
	if mode==1 then
		if state then
			self:playAnimation(self.rdAnim, 1, nil, true);
			self.rd = true;
		else
			self:playAnimation(self.rdAnim, -1, nil, true);
			self.rd = false;
		end;
	elseif mode==2 then
		if state then
			self:playAnimation(self.ldAnim, 1, nil, true);
			self.ld = true;
		else
			self:playAnimation(self.ldAnim, -1, nil, true);
			self.ld = false;
		end;
	elseif mode==3 then
		if state then
			self:playAnimation(self.bwAnim, 1, nil, true);
			self.bw = true;
		else
			self:playAnimation(self.bwAnim, -1, nil, true);
			self.bw = false;
		end;
	end;

end;

function Ford8340:readStream(streamId, connection)
	self.rd = streamReadBool(streamId);
	self.ld = streamReadBool(streamId);
	self.bw = streamReadBool(streamId);
end;

function Ford8340:writeStream(streamId, connection)
    streamWriteBool(streamId, self.rd);
    streamWriteBool(streamId, self.ld);
	streamWriteBool(streamId, self.bw);
end;

function Ford8340:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.rd = Utils.getNoNil(getXMLBool(xmlFile, key.."#rd"),false);
		self.ld = Utils.getNoNil(getXMLBool(xmlFile, key.."#ld"),false);
		self.bw = Utils.getNoNil(getXMLBool(xmlFile, key.."#bw"),false);
		
		if self.rd then
			self:playAnimation(self.rdAnim, 100, nil, true);
		end;
		if self.ld then
			self:playAnimation(self.ldAnim, 100, nil, true);
		end;
		if self.bw then
			self:playAnimation(self.bwAnim, 100, nil, true);
		end;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Ford8340:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'rd="'..tostring(self.rd)..
	'" ld="'..tostring(self.ld)..
	'" bw="'..tostring(self.bw).. '"';
	return attributes;
end;
