 
T150 = {};

function T150.prerequisitesPresent(specializations)
    Vehicle.registerJointType("tractor");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function T150:load(xmlFile)
    self.ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ventelator1#index"));

self.help = false;

 local rotationPartNodekozyrek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kozyrek#index"));
    if rotationPartNodekozyrek ~= nil then
        self.rotationPartkozyrek = {};
        self.rotationPartkozyrek.node = rotationPartNodekozyrek;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#minRot"));
        self.rotationPartkozyrek.minRot = {};
        self.rotationPartkozyrek.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#maxRot"));
        self.rotationPartkozyrek.maxRot = {};
        self.rotationPartkozyrek.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkozyrek.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#rotTime"), 2)*1000;
        self.rotationPartkozyrek.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#touchRotLimit"), 10));
    end;
	local rotationPartNodeTahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTahometr#index"));
    if rotationPartNodeTahometr ~= nil then
        self.rotationPartTahometr = {};
        self.rotationPartTahometr.node = rotationPartNodeTahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#minRot"));
        self.rotationPartTahometr.minRot = {};
        self.rotationPartTahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#maxRot"));
        self.rotationPartTahometr.maxRot = {};
        self.rotationPartTahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#rotTime"), 2)*1000;
        self.rotationPartTahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#touchRotLimit"), 10));
    end;
	local rotationPartNodeklapan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartklapan#index"));
    if rotationPartNodeklapan ~= nil then
        self.rotationPartklapan = {};
        self.rotationPartklapan.node = rotationPartNodeklapan;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapan#minRot"));
        self.rotationPartklapan.minRot = {};
        self.rotationPartklapan.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapan.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapan.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapan#maxRot"));
        self.rotationPartklapan.maxRot = {};
        self.rotationPartklapan.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapan.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapan.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapan.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartklapan#rotTime"), 2)*1000;
        self.rotationPartklapan.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartklapan#touchRotLimit"), 10));
    end;
	local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
end;

function T150:delete()
   
end;

function T150:mouseEvent(posX, posY, isDown, isUp, button)

end;

function T150:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;
    if isDown and sym == Input.KEY_KP_4 then 
	self.rotationMaxkozyrek = not self.rotationMaxkozyrek;
    end;
end;

function T150:update(dt)

		if self.rotationPartkozyrek ~= nil then
		   local x, y, z = getRotation(self.rotationPartkozyrek.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkozyrek.maxRot, self.rotationPartkozyrek.minRot, 3, self.rotationPartkozyrek.rotTime, dt, not self.rotationMaxkozyrek);
		   setRotation(self.rotationPartkozyrek.node, unpack(newRot));
        end;
		local maxDrehzahl = 1300;
	if self.rotationPartTahometr ~= nil then
		local x, y, z = getRotation(self.rotationPartTahometr.node);
		y = ((self.rotationPartTahometr.maxRot[2] - self.rotationPartTahometr.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartTahometr.minRot[2];
		setRotation(self.rotationPartTahometr.node, x, y ,z);
	end;
	local maxDrehzahl = 1000;
	if self.rotationPartklapan ~= nil then
		local x, y, z = getRotation(self.rotationPartklapan.node);
		y = ((self.rotationPartklapan.maxRot[2] - self.rotationPartklapan.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartklapan.minRot[2];
		setRotation(self.rotationPartklapan.node, x, y ,z);
	end;
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	if self.isMotorStarted then
         		rotate(self.ventelator1,0,0,dt*0.01 );		
	end;
	  
end;

function T150:draw()

	if not self.help then
	setTextBold(true);
	setTextColor(1,1,1,1);
            renderText(0.76, 0.167, 0.0193, "Numpad 0: Info");
        else
		  renderText();
        end;
        
        if self.help then
	renderText(0.76, 0.50, 0.02, "0: signal");
        renderText(0.76, 0.48, 0.02, "F: svet");
	renderText(0.76, 0.46, 0.02, "Num 4: kozirek");
	renderText(0.76, 0.44, 0.02, "Num 6: zadniy/dop svet");
	renderText(0.76, 0.42, 0.02, "Num 5: bokovini");
		end;

end;

function T150:onEnter()

end;

function T150:onLeave()

end;

function T150:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;