-- 
-- by PeterJ (18/02/2011)
-- 

ForkLift = {};

function ForkLift.prerequisitesPresent(specializations)
    return true;
end;

function ForkLift:load(xmlFile)
	_=[[
    local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;	

		local jointTypeStr = getXMLString(xmlFile, baseName .. "#jointType");
		if jointTypeStr ~= nil then
			local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
			
			if jointType == nil then
				Vehicle.registerJointType(jointTypeStr);
				print("register Jointtype: " .. jointTypeStr);
				jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
			end;
			
			if jointType ~= nil then
				self.attacherJoints[i+1].jointType = jointType;				
			end;
		end;
		i = i + 1;
	end;	]]	
	

	local jointTypeStr = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#jointType");
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		
		if jointType == nil then
			Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;
		
		if jointType ~= nil then
			self.attacherJoints[1].jointType = jointType;				
		end;
	end;

	self.attacherVehicleCopy = nil;
	
end;

function ForkLift:delete()
end;

function ForkLift:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ForkLift:keyEvent(unicode, sym, modifier, isDown)
end;

function ForkLift:update(dt)	
end;

function ForkLift:draw()
end;

function ForkLift:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
    for k,v in pairs(self.attachedImplements) do	
		if v.object.onForkLiftAttach ~= nil then
            v.object:onForkLiftAttach(attacherVehicle);
		end;
    end;
end;

function ForkLift:onDetach()
	self.attacherVehicleCopy = nil;
    for k,v in pairs(self.attachedImplements) do
		if v.object.onForkLiftDetach ~= nil then
            v.object:onForkLiftDetach(attacherVehicle);
		end;
    end;
end;

function ForkLift:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;