--
-- ControlPanel
-- Specialization for ControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS2011
--

ControlPanel = {};

function ControlPanel.prerequisitesPresent(specializations)
    return true;
end;

function ControlPanel:load(xmlFile)
	
	source(Utils.getFilename("specs/InteractiveComponentInterface.lua", self.baseDirectory));
	
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#index"));

end;

function ControlPanel:delete()
end;

function ControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function ControlPanel:update(dt)	
end;

function ControlPanel:draw()
end;

function ControlPanel:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	end;	
end;

function ControlPanel:onDetach()
	if self.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = self.attacherVehicleCopy:removeControlPanel(self);
	end;

	self.attacherVehicleCopy = nil;
end;
