--
-- WheelChocks
-- Specialization for WheelChocks
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		31/07/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

WheelChocks = {};

function WheelChocks.prerequisitesPresent(specializations)
    return true;
end;

function WheelChocks:load(xmlFile)
	
	local chocksCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelChocks#count"), 0);	
	self.wheelChocks = {};	
	for i=1, chocksCount do
		local chockName = string.format("vehicle.wheelChocks.chock%d", i);		
		self.wheelChocks[i] = {};		
		self.wheelChocks[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, chockName .. "#node"));
		self.wheelChocks[i].attachPosition = getParent(self.wheelChocks[i].node);
		self.wheelChocks[i].detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, chockName .. "#detachPosition"));
	end;
	
	-- enable wheelchocks on load
	for _,wheelChock in pairs(self.wheelChocks) do
		unlink(wheelChock.node);
		link(wheelChock.detachPosition, wheelChock.node);
	end;
end;

function WheelChocks:delete()
end;

function WheelChocks:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WheelChocks:keyEvent(unicode, sym, modifier, isDown)
end;

function WheelChocks:update(dt)
end;

function WheelChocks:draw()	
end;

function WheelChocks:onAttach(attacherVehicle)
	for _,wheelChock in pairs(self.wheelChocks) do
		unlink(wheelChock.node);
		link(wheelChock.attachPosition, wheelChock.node);
	end;
end;

function WheelChocks:onDetach()
	for _,wheelChock in pairs(self.wheelChocks) do
		unlink(wheelChock.node);
		link(wheelChock.detachPosition, wheelChock.node);
	end;
end;
