-- LUA fr realistisches Partikelsystem am Auspuff
-- basiert im Grundsatz dynamicExhaustSystem.lua von Face bzw. dessen Shader ausm dem Kirovets K 700A
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net


realExhaustParticleSystem = {};

function realExhaustParticleSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realExhaustParticleSystem:load(xmlFile)
	self.reps = {};
	
	self.reps.minAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#minAlpha"), 0.1);
	self.reps.maxAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxAlpha"), 1);
	self.reps.parameter = getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#parameter");

	self.reps.realAlpha = self.reps.minAlpha;
	self.reps.isAcc = false;
	self.reps.accBackup = 0;
	self.reps.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxRot"),0));
	self.reps.maxRpm = self.motor:getMaxRpm();
	
	self.klappe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#klappe"));
end;

function realExhaustParticleSystem:delete()
end;
function realExhaustParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;
function realExhaustParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;
function realExhaustParticleSystem:update(dt)
	if self:getIsActiveForInput() or self.isServer and self:getIsActive() then
		if self.isMotorStarted then
			local angle = math.rad(math.random(-20,5)) + self.reps.maxRot * self.motor.lastMotorRpm / self.reps.maxRpm;	
			angle = math.max(math.min(angle, 0), self.reps.maxRot);		
			setRotation(self.klappe, angle,0,0);
		-- berprfen ob der Traktor am beschleunigen ist
		if self.reps.accBackup < self.motor.lastMotorRpm then
			self.reps.isAcc = true;
		elseif self.reps.accBackup > self.motor.lastMotorRpm then
			self.reps.isAcc = false;
		end;
		local acc = 0;
		acc = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		if InputBinding.isAxisZero(acc) then
			acc = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		end;
		
		-- acc auf diese Art bedeutet, Tastatur -> w ist gedrckt -> 1, nix ist gedrckt -0, s gedrckt -> -1
		-- bei Pedal die genaue Stellung des Pedals von 0 - 1 und -1 

		-- Tempomatstufen 
		if self.motor.speedLevel == 1 then -- Tempomatstufe 1
			if self.motor.lastMotorRpm < (self.motor.maxRpm[1] - 100) then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			else
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
			end;
		end;
		if self.motor.speedLevel == 2 then -- Tempomatstufe 2
			if self.motor.lastMotorRpm < (self.motor.maxRpm[2] - 150) then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			else
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
			end;
		end;
		if self.motor.speedLevel == 3 then -- Tempomatstufe 3
			if self.motor.lastMotorRpm < (self.motor.maxRpm[3] - 250) then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			else
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
			end;
		end;
		if self.motor.speedLevel == 4 then -- Tempomatstufe 4
			if self.motor.lastMotorRpm < (self.motor.maxRpm[4] - 150) then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			else
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
			end;
		end;
		
		-- wenn keine Tempomatstufe aktiviert ist
		if self.motor.speedLevel == 0 then -- keine Tempomatstufe aktiviert, zunchst nur Qualm bei beschleunigung
			if self.reps.isAcc == true then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			end;
			if self.reps.isAcc == false then
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.1);
			end;
			if acc == 1 then -- wenn acc -> 1 ist dann ist Taste w gedrckt --> Vollgas
				if self.motor.lastMotorRpm < (self.motor.maxRpm[3] - 250) then -- raucht also auch wenn man am Berg an Speed verliert
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				end;
			end;
		end;
		
		setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, self.reps.realAlpha, false);		
		self.reps.accBackup = self.motor.lastMotorRpm;	
		else
			if self.klappe ~= nil then
				setRotation(self.klappe, 0, 0, 0);
			end;
		end;
	end;
	if self.isMotorStarted == false then
		setRotation(self.klappe, 0, 0, 0);	
	end;
end;

function realExhaustParticleSystem:draw()
end;