-- author RivalBomb

movingBlades = {};

function movingBlades.prerequisitesPresent(specializations)
    return true;
end;

function movingBlades:load(xmlFile)	
	self.blades = {};
	local bladI = 0;
	while true do
		local blakey = string.format("vehicle.blades.blade(%d)",bladI);
		local index = Utils.indexToObject(self.components, getXMLString(xmlFile, blakey.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, blakey.."#speed"), 1);
		local maxDiff = Utils.getNoNil(getXMLFloat(xmlFile, blakey.."#maxDiff"), 0.08);
		local axis = Utils.getNoNil(getXMLInt(xmlFile, blakey.."#axis"), 1);
		if axis ~= 1 and axis ~= 2 and axis ~= 3 then
			print("axis for blade "..(bladI+1).." is wrong ("..axis..")! Default axis (1) is now active.");
			axis = 1;
		end;
		if index==nil then
			break;
		end;
		bladI = bladI+1;
		self.blades[bladI] = {};
		self.blades[bladI].index = index;
		self.blades[bladI].speed = speed;
		self.blades[bladI].maxDiff = maxDiff;
		self.blades[bladI].axis = axis;
		self.blades[bladI].curSpeed = 0;
		self.blades[bladI].dir = 1;
		self.blades[bladI].pos = 0;
	end;
end;
function movingBlades:delete()
end;
function movingBlades:mouseEvent(posX, posY, isDown, isUp, button)
end;
function movingBlades:keyEvent(unicode, sym, modifier, isDown)
end;
function movingBlades:update(dt)
	if self:getIsActive() then
		for bladI=1, #self.blades do
			if self.reelStarted then
				self.blades[bladI].curSpeed = math.min(self.blades[bladI].curSpeed+0.013, self.blades[bladI].speed);
			else
				self.blades[bladI].curSpeed = math.max(self.blades[bladI].curSpeed-0.016, 0);
			end;
			if self.blades[bladI].pos >= self.blades[bladI].maxDiff then self.blades[bladI].dir=-1 elseif self.blades[bladI].pos <= -self.blades[bladI].maxDiff then self.blades[bladI].dir=1 end;
			self.blades[bladI].pos = self.blades[bladI].pos+(0.0125*self.blades[bladI].curSpeed*self.blades[bladI].dir);
			if self.blades[bladI].axis == 1 then
				setTranslation(self.blades[bladI].index, self.blades[bladI].pos,0,0);
			elseif self.blades[bladI].axis == 2 then
				setTranslation(self.blades[bladI].index, 0,self.blades[bladI].pos,0);
			elseif self.blades[bladI].axis == 3 then
				setTranslation(self.blades[bladI].index, 0,0,self.blades[bladI].pos);
			end;
		end;
	end;
end;
function movingBlades:updateTick(dt)
end;
function movingBlades:draw()
end;