--
-- enhancedSound.lua
--
-- @author  RivalBomb
-- @date  16/05/16
--

enhancedSound = {};

function enhancedSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(gearbox, specializations);
end;

function enhancedSound:load(xmlFile)
	self.swapSounds = SpecializationUtil.callSpecializationsFunction("swapSounds");
	self.soundInside = false;
	self.volumeInt = 0.01;
	self.volumeOut = 1;
	
	local motorIdleCurve = AnimCurve:new(linearInterpolator1);
    motorIdleCurve:addKeyframe({v=1, time = 0});
    motorIdleCurve:addKeyframe({v=1, time = 1000});
    motorIdleCurve:addKeyframe({v=1.65, time = 1650});
	self.motorIdleCurve = motorIdleCurve;
	local threshingCurve = AnimCurve:new(linearInterpolator1);
    threshingCurve:addKeyframe({v=1, time = 0});
    threshingCurve:addKeyframe({v=1, time = 1000});
    threshingCurve:addKeyframe({v=1.25, time = 1650});
	self.threshingCurve = threshingCurve;
	
	local motorIdleVolCurve = AnimCurve:new(linearInterpolator1);
    motorIdleVolCurve:addKeyframe({v=0, time = 0});
    motorIdleVolCurve:addKeyframe({v=1, time = 1000});
    motorIdleVolCurve:addKeyframe({v=1, time = 1250});
    motorIdleVolCurve:addKeyframe({v=0, time = 1450});
    motorIdleVolCurve:addKeyframe({v=0, time = 1650});
	self.motorIdleVolCurve = motorIdleVolCurve;
	local motorHalbCurve = AnimCurve:new(linearInterpolator1);
    motorHalbCurve:addKeyframe({v=0, time = 0});
    motorHalbCurve:addKeyframe({v=0, time = 1000});
    motorHalbCurve:addKeyframe({v=1, time = 1300});
    motorHalbCurve:addKeyframe({v=1, time = 1500});
    motorHalbCurve:addKeyframe({v=0, time = 1650});
	self.motorHalbCurve = motorHalbCurve;
	local motorVollCurve = AnimCurve:new(linearInterpolator1);
    motorVollCurve:addKeyframe({v=0, time = 0});
    motorVollCurve:addKeyframe({v=0, time = 1450});
    motorVollCurve:addKeyframe({v=1, time = 1600});
    motorVollCurve:addKeyframe({v=1, time = 1650});
	self.motorVollCurve = motorVollCurve;
	if self.isClient then
		self.sampleErrorPiep = Utils.loadSample(xmlFile, {}, "vehicle.errorPiepSound", nil, self.baseDirectory, self.components[1].node);
		self.sampleErrorPiep2 = Utils.loadSample(xmlFile, {}, "vehicle.errorPiepSound2", nil, self.baseDirectory, self.components[1].node);
		
		self.motorStartSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorStartSound", nil, self.baseDirectory, self.components[1].node);
		self.motorIdleSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorSound", nil, self.baseDirectory, self.components[1].node);
		self.motorStopSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorStopSound", nil, self.baseDirectory, self.components[1].node);
		self.sampleMotorHalbgas = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundHalbgas", nil, self.baseDirectory, self.components[1].node);
		self.sampleMotorVollgas = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundVollgas", nil, self.baseDirectory, self.components[1].node);
		self.threshingStartSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSound", nil, self.baseDirectory, self.components[1].node);

		self.sampleMotorHalbgasInside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundHalbgasInside", nil, self.baseDirectory, self.components[1].node);
		self.sampleMotorVollgasInside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundVollgasInside", nil, self.baseDirectory, self.components[1].node);
		self.motorStartSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorStartSoundInside", nil, self.baseDirectory, self.components[1].node);
		self.motorIdleSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundInside", nil, self.baseDirectory, self.components[1].node);
		self.motorStopSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorStopSoundInside", nil, self.baseDirectory, self.components[1].node);
		self.threshingStartSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSoundInside", nil, self.baseDirectory, self.components[1].node);
	end;
end;

function enhancedSound:delete()
	if self.sampleErrorPiep ~= nil then
		Utils.deleteSample(self.sampleErrorPiep);
	end;
	if self.sampleErrorPiep2 ~= nil then
		Utils.deleteSample(self.sampleErrorPiep2);
	end;
	if self.sampleMotorHalbgas ~= nil then
		Utils.deleteSample(self.sampleMotorHalbgas);
	end;
	if self.sampleMotorVollgas ~= nil then
		Utils.deleteSample(self.sampleMotorVollgas);
	end;
	if self.sampleMotorHalbgasInside ~= nil then
		Utils.deleteSample(self.sampleMotorHalbgasInside);
	end;
	if self.sampleMotorVollgasInside ~= nil then
		Utils.deleteSample(self.sampleMotorVollgasInside);
	end;
	
	if self.motorStartSoundOutside ~= nil then
		Utils.deleteSample(self.motorStartSoundOutside);
	end;
	if self.motorIdleSoundOutside ~= nil then
		Utils.deleteSample(self.motorIdleSoundOutside);
	end;
	if self.motorStopSoundOutside ~= nil then
		Utils.deleteSample(self.motorStopSoundOutside);
	end;
	if self.motorStartSoundInside ~= nil then
		Utils.deleteSample(self.motorStartSoundInside);
	end;
	if self.motorIdleSoundInside ~= nil then
		Utils.deleteSample(self.motorIdleSoundInside);
	end;
	if self.motorStopSoundInside ~= nil then
		Utils.deleteSample(self.motorStopSoundInside);
	end;
end;

function enhancedSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function enhancedSound:keyEvent(unicode, sym, modifier, isDown)
end;

function enhancedSound:onLeave()
	self:swapSounds("outside");
	self.soundInside = false;
end;

function enhancedSound:onEnter()
end;

function enhancedSound:update(dt)
	if self.isClient then
		if self:getIsActive() and self.isEntered then
			if self.cameras[self.camIndex].isInside and not self.soundInside then
				self:swapSounds("inside");
				self.soundInside = true;
			elseif self.soundInside and not self.cameras[self.camIndex].isInside then
				self:swapSounds("outside");
				self.soundInside = false;
			end;
			if self.isMotorStarted and self.isEntered then
				if not self.sampleMotorHalbgas.isPlaying then
					Utils.playSample(self.sampleMotorHalbgas, 0, 0, nil);
				end;
				if not self.sampleMotorVollgas.isPlaying then
					Utils.playSample(self.sampleMotorVollgas, 0, 0, nil);
				end;
				if not self.sampleMotorHalbgasInside.isPlaying then
					Utils.playSample(self.sampleMotorHalbgasInside, 0, 0, nil);
				end;
				if not self.sampleMotorVollgasInside.isPlaying then
					Utils.playSample(self.sampleMotorVollgasInside, 0, 0, nil);
				end;
			else
				if self.sampleMotorHalbgas.isPlaying then
					Utils.stopSample(self.sampleMotorHalbgas, true);
				end;
				if self.sampleMotorVollgas.isPlaying then
					Utils.stopSample(self.sampleMotorVollgas, true);
				end;
				if self.sampleMotorHalbgasInside.isPlaying then
					Utils.stopSample(self.sampleMotorHalbgasInside, true);
				end;
				if self.sampleMotorVollgasInside.isPlaying then
					Utils.stopSample(self.sampleMotorVollgasInside, true);
				end;
				if self.samplePipe.isPlaying then
					Utils.stopSample(self.samplePipe, true);
				end;
			end;
			
				Utils.setSamplePitch(self.sampleMotor, self.motorIdleCurve:get(self.motor.lastMotorRpm));
				Utils.setSamplePitch(self.sampleMotorHalbgas, self.motorIdleCurve:get(self.motor.lastMotorRpm)/1.45);
				Utils.setSamplePitch(self.sampleMotorVollgas, self.motorIdleCurve:get(self.motor.lastMotorRpm)/1.65);
				Utils.setSamplePitch(self.sampleMotorHalbgasInside, self.motorIdleCurve:get(self.motor.lastMotorRpm)/1.45);
				Utils.setSamplePitch(self.sampleMotorVollgasInside, self.motorIdleCurve:get(self.motor.lastMotorRpm)/1.65);
				Utils.setSamplePitch(self.sampleThreshing, self.threshingCurve:get(self.motor.lastMotorRpm));
				
				Utils.setSampleVolume(self.sampleMotor, self.motorIdleVolCurve:get(self.motor.lastMotorRpm));
				Utils.setSampleVolume(self.sampleMotorHalbgas, self.motorHalbCurve:get(self.motor.lastMotorRpm)*self.volumeOut);
				Utils.setSampleVolume(self.sampleMotorVollgas, self.motorVollCurve:get(self.motor.lastMotorRpm)*self.volumeOut);
				Utils.setSampleVolume(self.sampleThreshingStop, self.volumeOut);
				Utils.setSampleVolume(self.sampleThreshing, self.volumeOut);
				Utils.setSampleVolume(self.sampleMotorHalbgasInside, self.motorHalbCurve:get(self.motor.lastMotorRpm)*self.volumeInt);
				Utils.setSampleVolume(self.sampleMotorVollgasInside, self.motorVollCurve:get(self.motor.lastMotorRpm)*self.volumeInt);
				
				Utils.stop3DSample(self.sampleMotor);
				Utils.stop3DSample(self.sampleMotorHalbgas);
				Utils.stop3DSample(self.sampleMotorVollgas);
			if self:getIsTurnedOn() and self.isEntered then
				if self.currentRpmRange == 1 then
					if not isSamplePlaying(self.sampleErrorPiep.sample, 1.5*dt) then
						Utils.playSample(self.sampleErrorPiep, 0, 0, nil);
					end;
					if isSamplePlaying(self.sampleErrorPiep2.sample, 1.5*dt) then
						Utils.stopSample(self.sampleErrorPiep2, true);
					end;
				elseif self.currentRpmRange == 2 then
					if isSamplePlaying(self.sampleErrorPiep.sample, 1.5*dt) then
						Utils.stopSample(self.sampleErrorPiep, true);
					end;
					if not isSamplePlaying(self.sampleErrorPiep2.sample, 1.5*dt) then
						Utils.playSample(self.sampleErrorPiep2, 0, 0, nil);
					end;
				else
					if isSamplePlaying(self.sampleErrorPiep.sample, 1.5*dt) then
						Utils.stopSample(self.sampleErrorPiep, true);
					end;
					if isSamplePlaying(self.sampleErrorPiep2.sample, 1.5*dt) then
						Utils.stopSample(self.sampleErrorPiep2, true);
					end;
				end;
			else
				if isSamplePlaying(self.sampleErrorPiep.sample, 1.5*dt) then
					Utils.stopSample(self.sampleErrorPiep, true);
				end;
				if isSamplePlaying(self.sampleErrorPiep2.sample, 1.5*dt) then
					Utils.stopSample(self.sampleErrorPiep2, true);
				end;
			end;
		else
			if isSamplePlaying(self.sampleErrorPiep.sample, 1.5*dt) then
				Utils.stopSample(self.sampleErrorPiep, true);
			end;
			if isSamplePlaying(self.sampleErrorPiep2.sample, 1.5*dt) then
				Utils.stopSample(self.sampleErrorPiep2, true);
			end;
			if isSamplePlaying(self.sampleMotorHalbgas.sample, 1.5*dt) then
				Utils.stopSample(self.sampleMotorHalbgas, true);
			end;
			if isSamplePlaying(self.sampleMotorVollgas.sample, 1.5*dt) then
				Utils.stopSample(self.sampleMotorVollgas, true);
			end;
			if self.sampleMotorHalbgasInside.isPlaying then
				Utils.stopSample(self.sampleMotorHalbgasInside, true);
			end;
			if self.sampleMotorVollgasInside.isPlaying then
				Utils.stopSample(self.sampleMotorVollgasInside, true);
			end;
			if self.isMotorStarted then
				if self.currentRpmRange == 1 then
					Utils.play3DSample(self.sampleMotor);
					Utils.stop3DSample(self.sampleMotorHalbgas);
					Utils.stop3DSample(self.sampleMotorVollgas);
				elseif self.currentRpmRange == 2 then
					Utils.stop3DSample(self.sampleMotor);
					Utils.play3DSample(self.sampleMotorHalbgas);
					Utils.stop3DSample(self.sampleMotorVollgas);
				elseif self.currentRpmRange == 3 then
					Utils.stop3DSample(self.sampleMotor);
					Utils.stop3DSample(self.sampleMotorHalbgas);
					Utils.play3DSample(self.sampleMotorVollgas);
				end;
			else
				Utils.stop3DSample(self.sampleMotor);
				Utils.stop3DSample(self.sampleMotorHalbgas);
				Utils.stop3DSample(self.sampleMotorVollgas);
			end;
		end;
	end;
end;
function enhancedSound:swapSounds(camInOut)
	if self.isClient then
		if self.sampleMotor.isPlaying then
			Utils.stopSample(self.sampleMotor, true);
		end;
		if self.sampleMotorStart.isPlaying then
			Utils.stopSample(self.sampleMotorStart, true);
		end;
		if self.sampleMotorStop.isPlaying then
			Utils.stopSample(self.sampleMotorStop, true);
		end;
		if camInOut == "outside" then
			self.sampleMotorStart = self.motorStartSoundOutside;
			self.sampleMotorStop = self.motorStopSoundOutside;
			self.sampleMotor = self.motorIdleSoundOutside;
			self.sampleThreshingStart = self.threshingStartSoundOutside;
			self.volumeInt = 0.01;
			self.volumeOut = 1;
		elseif camInOut == "inside" then
			self.sampleMotorStart = self.motorStartSoundInside;
			self.sampleMotorStop = self.motorStopSoundInside;
			self.sampleMotor = self.motorIdleSoundInside;
			self.sampleThreshingStart = self.threshingStartSoundInside;
			self.volumeInt = 1;
			self.volumeOut = 0.01;
		end;
		if self.isEntered and self.isMotorStarted then
			Utils.playSample(self.sampleMotor, 0,0,nil);
		end;
	end;
end;

function enhancedSound:updateTick(dt)
end;
function enhancedSound:draw()
end;