--
-- CutterAttacherHeight.lua
--
-- @author  RivalBomb
-- @date  16/05/16
--

CutterAttacherHeight = {};

function CutterAttacherHeight.prerequisitesPresent(specializations)
    return true;
end;
function CutterAttacherHeight:load(xmlFile)
	self.cheight = 0;
	self.minRot = -18;
end;
function CutterAttacherHeight:delete()
end;
function CutterAttacherHeight:mouseEvent(posX, posY, isDown, isUp, button)
end;
function CutterAttacherHeight:keyEvent(unicode, sym, modifier, isDown)
end;
function CutterAttacherHeight:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local cutterheight = getXMLFloat(xmlFile, key.."#cutterHeight");
	if cutterheight ~= nil then
		self.cheight = cutterheight;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
function CutterAttacherHeight:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' cutterHeight="'..tostring(self.cheight)..'"';
	local node = nil;
	return attributes, node;
end;
function CutterAttacherHeight:update(dt)
	if self:getIsActive() and self.isEntered and not self.isHired then
		if self.isClient and self:getIsActiveForInput(false) then
			if InputBinding.isPressed(InputBinding.LIFT_CUTTER) then
				self.cheight = math.min(self.cheight+0.0005*dt,1);
			end;
			if InputBinding.isPressed(InputBinding.LOWER_CUTTER) then
				self.cheight = math.max(self.cheight-0.0006*dt,-1.6);
			end;
		end;
		local jointDesc = self.attacherJoints[1];
		setRotation(jointDesc.rotationNode, math.rad(self.minRot*self.cheight),0,0);
		setRotation(jointDesc.bottomArm.rotationNode, math.rad(self.minRot*self.cheight),0,0);
		if self.isServer then
			setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
		end
		if (self.minRot*self.cheight) > 11 then
			jointDesc.moveDown = true;
		else
			jointDesc.moveDown = false;
		end;
	end;
	if self:getIsActive() and self.isHired then
		if self.turnStage == 1 then
			self.cheight = math.min(self.cheight+0.0006*dt,0.5);
		elseif self.turnStage == 3 then
			self.cheight = math.max(self.cheight-0.0006*dt,-1.25);
		end;		
		local jointDesc = self.attacherJoints[1];
		setRotation(jointDesc.rotationNode, math.rad(self.minRot*self.cheight),0,0);
		setRotation(jointDesc.bottomArm.rotationNode, math.rad(self.minRot*self.cheight),0,0);
		if self.isServer then
			setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
		end
	end;
end;
function CutterAttacherHeight:updateTick(dt)
end;
function CutterAttacherHeight:draw()
end;