SpecializationUtil.registerSpecialization("dominatorScriptBase", "dominatorScriptBase", g_currentModDirectory.."dominatorScriptBase.lua")

dominatorScriptBase_Register = {};

function dominatorScriptBase_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		print("--- loading AAA_DominatorScriptBase - specialization for Claas Dominator Combines by Rival");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = false;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.gearbox", _name)) ~= nil and rawget(SpecializationUtil.specializations, string.format("%s.enhancedSound", _name)) ~= nil and not rawget(SpecializationUtil.specializations, string.format("%s.dominatorScriptBase", _name)) ~= nil then
								allowInsertion = true;
							end;
						end;
						if allowInsertion then
							print("adding dominatorScriptBase to:"..tostring(v.name));
							table.insert(v.specializations, SpecializationUtil.getSpecialization("dominatorScriptBase"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function dominatorScriptBase_Register:deleteMap()
  
end;

function dominatorScriptBase_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function dominatorScriptBase_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function dominatorScriptBase_Register:update(dt)
	
end;

function dominatorScriptBase_Register:draw()
  
end;

addModEventListener(dominatorScriptBase_Register);