--
-- KnustonFarm
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

KnustonFarm = {}

local KnustonFarm_mt = Class(KnustonFarm, Mission00);


function KnustonFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = KnustonFarm_mt;
    end;
    local self = KnustonFarm:superClass():new(baseDirectory, mt);

    return self;
end;

function KnustonFarm:delete()
    KnustonFarm:superClass().delete(self);
end;

function KnustonFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;
	self.AnimationMapConfig = {"map/scripts/AnimationMap.xml", self.baseDirectory};

    self:loadMap(Utils.getFilename("map/mapi3d/Knuston.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
	
end;

print("--- loading chellington Farm 2015... have fun!");

function KnustonFarm:loadCareerMap01Finished(node, arguments)

    if self.cancelLoading then
        return;
    end
	
    self.terrainDetailAngleNumChannels = 8; 
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;
	
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("KnustonFarm.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    -- ATMs
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 518.326, -14.213, nil, nil, false, false, false, 0, true);

    -- shops
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), 550.517, -0.306, nil, nil, false, false, false, 0, true);

    -- egg sellpoints
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), 162.715, 331.89, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), -780, 970, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), 970, 200.213, nil, nil, false, false, false, 0, true);
    
    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -420.875, -496.386, nil, nil, false, false, false, 0, true);

    -- bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 233.329, -209.125, nil, nil, false, false, false, 0, true);
	
    -- grass heaps
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -446.974, -484.714, nil, nil, false, false, false, 0, true);
	
    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), -602.326, -380.369, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Sheep", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_sheep.png", self.baseDirectory), -356.031, -373.598, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), -470.089, -389.245, nil, nil, false, false, false, 0, true);
    
    -- spinnery 
    self.ingameMap:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_spinnery.png", self.baseDirectory), -695.297, 312.488, nil, nil, false, false, false, 0, true);

	trcScreenFlip();
    KnustonFarm:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
	if _G["AnimationMapTrigger"] == nil then print("  AnimationMapTrigger - Notice: The mod AnimationMapTrigger is missing from your mods folder, get your copy at http://vertexdezign.net/"); 
	end;
end;

function KnustonFarm:onStartMission()
    KnustonFarm:superClass().onStartMission(self);
end;

function KnustonFarm:mouseEvent(posX, posY, isDown, isUp, button)
    KnustonFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function KnustonFarm:keyEvent(unicode, sym, modifier, isDown)
    KnustonFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function KnustonFarm:update(dt)
    KnustonFarm:superClass().update(self, dt);
end;

function KnustonFarm:draw()
    KnustonFarm:superClass().draw(self);
end;

----
function ShipNewKeepQuietWhileLoading(self, superFunc, id)
    local res = superFunc(self,id)
    -- Move away from spawn (0,0,0), to "mute" sounds while loading...
    for _,ship in pairs(res.shipIds) do
        setTranslation(ship, 0,-1000,0);
    end
    --
    return res
end
Ship.new = Utils.overwrittenFunction(Ship.new, ShipNewKeepQuietWhileLoading)
