﻿--
-- kenworth
-- Specialization class for kenworth
--
-- @author  oxtar
-- @date  21/02/2013
--
-- Copyright (C) by oxtar-Modding, All Rights Reserved.

kenworth = {};

function kenworth.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function kenworth:load(xmlFile)
	self.Bob = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#index"));
	self.Mirror1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Mirror1#index"));
	self.Mirror2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Mirror2#index"));
	self.tanklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index"));
	self.tank2light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index2"));
	self.AirPress = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.AirPress#index"));
	self.tanklightActive = false;
	self.tankwarn = 100;
	self.beaconrf = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.BeaconRef#index"));
	self.runningLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.runningLight#index"));
	self.nrunningLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.nrunningLight#index"));
	self.cabrun = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cabrun#index"));
	self.ncabrun = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ncabrun#index"));
	self.tailrun = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tailrun#index"));
	self.ntailrun = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ntailrun#index"));
	

	local rotationNodeCAB = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationCAB#index"));
	if rotationNodeCAB ~= nil then
		self.rotationCAB = {};
		self.rotationCAB.node = rotationNodeCAB;

    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationCAB#minRot"));
        self.rotationCAB.minRot = {};
        self.rotationCAB.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationCAB.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationCAB.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationCAB#maxRot"));
        self.rotationCAB.maxRot = {};
        self.rotationCAB.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationCAB.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationCAB.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationCAB.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationCAB#rotTime"), 2)*1000;
        self.rotationCAB.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationCAB#touchRotLimit"), 10));
	end;

	--[[local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;--]]

	fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.ogg", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	--self.drivingShaft = {};
	--self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));
	--self.drivingShaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingShaft#speedFactor"), 2);
	
	--self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
    --self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
	
	--self.handbrake = false;
	--self.cos = 20000;
	self.druckLevel = 0;
	self.rotationMaxCAB = false;
	self.Farmer = true;
	self.Mirror = false;
	self.FTO = 0;
	setVisibility(self.tanklight,false);
	setVisibility(self.tank2light,false);
    setVisibility(self.Mirror1,false);
	setVisibility(self.Mirror2,false);
	
	handbrakeSoundFile = Utils.getFilename("sound/handbrake.ogg", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("sound/brake2.ogg", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("sound/brake.ogg", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
		
	compressorSoundFile = Utils.getFilename("sound/compressor.ogg", self.baseDirectory);
    self.compressorSoundId = createSample("compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("sound/compressorstop.ogg", self.baseDirectory);
    self.cssi = createSample("compressorstopSound");
    loadSample(self.cssi, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;
    
   --[[ local breamsDrucknadelIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bremsDruckNadel#index"));
    if breamsDrucknadelIndex ~= nil then
        self.bremsDruckNadel = {};
        self.bremsDruckNadel.node = breamsDrucknadelIndex;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bremsDruckNadel#minRot"));
        self.bremsDruckNadel.minRot = {};
        self.bremsDruckNadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bremsDruckNadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bremsDruckNadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bremsDruckNadel#maxRot"));
        self.bremsDruckNadel.maxRot = {};
        self.bremsDruckNadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bremsDruckNadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bremsDruckNadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bremsDruckNadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bremsDruckNadel#rotTime"), 2)*1000;
        self.bremsDruckNadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bremsDruckNadel#touchRotLimit"), 10));
    end;
    self.HandBrakeTurnOff = false;-]]
	
	--[[self.rotors = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotors.rotor(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
             break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
        if node ~= nil then
            table.insert(self.rotors, {node=node,speed=speed});
        end;
        i = i + 1;
    end;--]]

end;

function kenworth:delete()

end;

function kenworth:mouseEvent(posX, posY, isDown, isUp, button)

end;

function kenworth:keyEvent(unicode, sym, modifier, isDown)
if self:getIsActiveForInput() then
	if Input.isKeyPressed(Input.KEY_KP_divide) then
		self.rotationMaxCAB = not self.rotationMaxCAB;
		self.Farmer = not self.Farmer;
	end;
	
	if Input.isKeyPressed(Input.KEY_l) then
		self.Mirror = not self.Mirror;
		setVisibility(self.Mirror1, self.Mirror);
		setVisibility(self.Mirror2, self.Mirror);
	end;
end;	

end;

function kenworth:updateTick(dt)
	
	if self.beaconLightsActive then
		setVisibility(self.beaconrf, false);
	else
		setVisibility(self.beaconrf, true);
	end;
	
	--[[if self.isMotorStarted then
        for _,v in pairs(self.rotors) do
            if v.node ~= nil then
                rotate(v.node,v.speed*dt,0,0)
            end;
        end;
	end;--]]
end;

function kenworth:update(dt)
	if self.lightsTypesMask ~= 0 then
		setVisibility(self.runningLight, true);
		setVisibility(self.nrunningLight, false);
		setVisibility(self.cabrun, true);
		setVisibility(self.ncabrun, false);
		setVisibility(self.tailrun, true);
		setVisibility(self.ntailrun, false);
		
	else
		setVisibility(self.nrunningLight, true);
		setVisibility(self.runningLight, false);
		setVisibility(self.ncabrun, true);
		setVisibility(self.cabrun, false);
		setVisibility(self.ntailrun, true);
		setVisibility(self.tailrun, false);
	end;
	--setVisibility(self.handbrakelight, self.handbrake);
	setVisibility(self.AirPress, self.druckWarning);
	
	--[[if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	
	if self.rotationPartTanknadel2 ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel2.node);
		y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
		setRotation(self.rotationPartTanknadel2.node, x, y ,z);
	end;

	local maxDrehzahl = 3900;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
	end;
	
	local maxKmh = 55;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartKmh2 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh2.node);
		y = ((self.rotationPartKmh2.maxRot[2] - self.rotationPartKmh2.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh2.minRot[2];
		setRotation(self.rotationPartKmh2.node, x, y ,z);
	end;--]]
	
	if not self.Farmer and self:getIsActive() then 
		self.FTO = 5000;
		setVisibility(self.Bob, self.Farmer);				
	else
		if self.Farmer and self:getIsActive() then 
			self.FTO = self.FTO - dt;
			setVisibility(self.Bob, self.FTO < 0);
		end;
	end;
			
	if self.rotationCAB ~= nil then
		local x, y, z = getRotation(self.rotationCAB.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationCAB.maxRot, self.rotationCAB.minRot, 3, self.rotationCAB.rotTime, dt, not self.rotationMaxCAB);
		setRotation(self.rotationCAB.node, unpack(newRot));
	end;

	if self.isEntered then
		if self.fuelFillLevel < 75 then
			self.tankwarn = self.tankwarn - dt;
			if self.tankwarn <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.tankwarn = 30000;
			end;
			self.tanklightActive = true;
		else
			self.tankwarn = 30000;
			self.tanklightActive = false;
		end;
		setVisibility(self.tanklight,self.tanklightActive);
		setVisibility(self.tank2light,self.tanklightActive);
	end;
	
	--[[if self:getIsActive() then		
		local x,y,z = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaft.node, 0 ,0, x*self.drivingShaft.speedFactor);	
	end;--]]
	
	if self.isMotorStarted then        
		if Input.isKeyPressed(Input.KEY_s) then
			if self.druckLevel >= 3500 then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -500;
					else
						self.druckLevel = self.druckLevel -300;
					end;
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

		--[[if self.fuelFillLevel < 50 then
			self.cos = self.cos - dt;
			if self.cos <= 0 and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.cos = 20000;
			end;
		else
			self.cos = 20000;
		end;--]]
			
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning and self:getIsActiveForSound() then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning and self:getIsActiveForSound() then
				playSample(self.cssi, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
        --self.motor.brakeForce = (self.druckLevel/self.BreakForceVal);

      --  if self.bremsDruckNadel ~= nil then
        --    local x, y, z = getRotation(self.bremsDruckNadel.node);
       --     y = ((self.bremsDruckNadel.maxRot[2] - self.bremsDruckNadel.minRot[2]) / 10000) * self.druckLevel + self.bremsDruckNadel.minRot[2];
       --     setRotation(self.bremsDruckNadel.node, x, y ,z);
        --end;
	else
	stopSample(self.compressorSoundId, 0, 1, 0);
	end;
end;

function kenworth:draw()

	if self.isEntered and self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("tgm"), InputBinding.ToggleMirror);
		g_currentMission:addHelpButtonText(g_i18n:getText("tcb"), InputBinding.TipCab);
	end;
	

end;

function kenworth:onEnter()
	
end;

function kenworth:onLeave()
    stopSample(self.compressorSoundId, 0, 1, 0);
    self.compressorSoundRunning = false;
end;

function kenworth:setHandBrakeState(state, noEventSend)
    GearEvent.sendEvent(self, state, noEventSend)
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
    
end;


GearEvent = {};
GearEvent_mt = Class(GearEvent, Event);

InitEventClass(GearEvent, "GearEvent");

function GearEvent:emptyNew()
    local self = Event:new(GearEvent_mt);
    self.className="GearEvent";
    return self;
end;

function GearEvent:new(object, state)
    local self = GearEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function GearEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function GearEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function GearEvent:run(connection)
	self.object:setHandBrakeState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(GearEvent:new(self.object, self.state), nil, connection, self.object);
    end;	
end;

function GearEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(GearEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(GearEvent:new(vehicle, state));
		end;
	end;
end;
