Gravel = {};

  
function Gravel.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Gravel:load(xmlFile)

        self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
        self.contactReportNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.contactReportNode#index"));
       if self.contactReportNode == nil then
            self.contactReportNode = self.components[1].node;
        end;

        self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
        self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
        self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;
        self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;
        self.GravelHasGroundContact = false;
        self.GravelHasContactReport = false;
        self.gravelMax = false;
        self.GravelContactReportsActive = false;
        self.GravelLimitToField = false;
        self.GravelGroundContactFlag = self.nextDirtyFlag;
        self.nextDirtyFlag = self.GravelGroundContactFlag*2;
        
        self.fillremplissage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillremplissage"), 2000);
        
        

        
end;
  
function Gravel:delete()

       Gravel.removeContactReports(self);
   end;
 
   function Gravel:readStream(streamId, connection)
   end;
 
   function Gravel:writeStream(streamId, connection)
   end;
 

   function Gravel:readUpdateStream(streamId, timestamp, connection)
       if connection:getIsServer() then
           self.GravelHasGroundContact = streamReadBool(streamId);
       end;
   end;

   function Gravel:writeUpdateStream(streamId, connection, dirtyMask)
      if not connection:getIsServer() then
          streamWriteBool(streamId, self.GravelHasGroundContact);
       end;
   end;
   function Gravel:mouseEvent(posX, posY, isDown, isUp, button)
   end;
 
   function Gravel:keyEvent(unicode, sym, modifier, isDown)

   end;
 
   function Gravel:update(dt)
   end;
 
   function Gravel:updateTick(dt)

          if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
        self.gravelMax = not self.gravelMax;
     end;
      end;
   
              if self.isServer then



               local hasGroundContact = self.GravelHasContactReport;
               if not hasGroundContact then
                   if self.groundReferenceNode ~= nil then
                       local x,y,z = getWorldTranslation(self.groundReferenceNode);
                       local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                       if terrainHeight+self.groundReferenceThreshold >= y then
                           hasGroundContact = true;
                       end;
                   end;
               end;

               if self.GravelHasGroundContact ~= hasGroundContact then
                   self:raiseDirtyFlags(self.GravelGroundContactFlag);
               end;
               self.GravelHasGroundContact = hasGroundContact;
           end;
                      local hasGroundContact = self.GravelHasGroundContact;

           if hasGroundContact then
                if self.movingDirection == 1 then
                if self.fillLevel ~= self.capacity then
                  if self.gravelMax then
                   if self.isServer then
                          local cuttingAreasSend = {};
                          for k, cuttingArea in pairs(self.cuttingAreas) do
                               if self:getIsAreaActive(cuttingArea) then
                                   local x,y,z = getWorldTranslation(cuttingArea.start);
                                   local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                   local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                                   --Utils.updatePloughArea(x, z, x1, z1, x2, z2, not self.PloughLimitToField);
                                   table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                               end;
                           end;
                           if (table.getn(cuttingAreasSend) > 0) then
 
                               PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
                               g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
                               local usage = self.fillremplissage * dt*0.001;
                               local usedFruitType = FruitUtil.FRUITTYPE_GRAVEL;
                               local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];                                                                             
                               self:setFillLevel(self.fillLevel + usage, usedFillType);
                               


                           end;
                       end;
                       end;
                        end;
                        end;
                        end;

               
   end;
 
   function Gravel:draw()
   
    if self.gravelMax then
    g_currentMission:addExtraPrintText("Touche Z: Stop Gravelworks");
    else
    g_currentMission:addExtraPrintText("Touche Z: Start Gravelworks");
    end;
   end;
 

   function Gravel:onAttach(attacherVehicle)

       Gravel.addContactReports(self);

   end;
   function Gravel:onDetach()


       if self.deactivateOnDetach then
           Gravel.removeContactReports(self);
       end;

   end;
 
   function Gravel:onActivate()
   end;
 
   function Gravel:onDeactivate()
   end;
 
   function Gravel:onDeactivateSounds()
   end;
 
   function Gravel:aiRotateLeft()
   end;
 
   function Gravel:aiRotateRight()
   end;
 
   function Gravel:aiTurnOn()
   end;
 
   function Gravel:aiTurnOff()
   end;
 
   function Gravel:aiInvertsMarkerOnTurn(turnLeft)
   end;
 
   function Gravel:addContactReports()
       if not self.GravelContactReportsActive then
           addContactReport(self.contactReportNode, 0.0001, "groundContactReport", self);

           self.GravelContactReportsActive = true;
       end;
   end;

   function Gravel:removeContactReports()
       if self.GravelContactReportsActive then
           removeContactReport(self.contactReportNode);
           self.GravelHasContactReport = false;
           self.GravelContactReportsActive = false;
       end;
   end;
 
function Gravel:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)

       if otherObjectId == g_currentMission.terrainRootNode then

           self.GravelHasContactReport = isStart or normalForce > 0 or tangentialForce > 0;
       end;

end;
   function Gravel:setRotationMax(rotationMax, noEventSend)
   end;