-- Bulk Liquids Transport
-- Ver. 0.85
-- goelm
-- 2015.11.25


BLT = {};

function BLT.prerequisitesPresent(specializations)
    return true;
end;

function BLT:load(xmlFile)
	
	local WaterS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.WaterS#index"));
	if WaterS ~= nil then
		self.Water = WaterS;
	end;
	local BioFuelS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BioFuelS#index"));
	if BioFuelS ~= nil then
		self.BioFuel = BioFuelS;
	end;
	local SlurryS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SlurryS#index"));
	if SlurryS ~= nil then
		self.Slurry = SlurryS;
	end;
	local UnKnown = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UnKnown#index"));
	if UnKnown ~= nil then
		self.UnKnown = UnKnown;
	end;		
	local pumpSound = Utils.getFilename("Sounds/manureBarrel.wav", self.baseDirectory);
	self.pumpSound = createSample("pumpSound");
	loadSample(self.pumpSound, pumpSound, false);
	self.pumpSoundVolume = 1.5;
	setSamplePitch(self.pumpSound, 1);		
	self.pumpSoundEnabled = false;
	self.hose = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hose#index"));
	self.runningLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.runningLight#index"));
	self.nrunningLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.nrunningLight#index"));
	self.blight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blight#index"));
	self.zPipe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zPipe#index"));
	setVisibility(self.zPipe, false);-- set tip animation to 0
	setVisibility(self.hose, false);-- safety if edit has pipe visible
	htime = 0;
	self.ZB = 100000 -- ohio valley tweak for handling fill animation (capacity filter)
end;

function BLT:update(dt)
	if self.attacherVehicle ~= nil then -- do nothing if trailer is orphan
		if self.attacherVehicle.isEntered and not self.attacherVehicle.isMotorStarted then 
			self.isSprayerFilling = false;
			self:setIsWaterTrailerFilling(false);
			self.allowsSpraying = false;
			setVisibility(self.hose, false);
		end;

		if self.currentFillType ~= 0 then -- cleanup help menu text and disable dumping $$$$ hope you loaded water from river :)...
			local desc = Fillable.fillTypeIndexToDesc[self.currentFillType];
			local name = desc.name;
				if name == 'biofuel' then
					self.allowsSpraying = false;
				elseif name == 'water' and self.attacherVehicle.isMotorStarted then
					self.allowsSpraying  = true;
				elseif name == 'liquidManure' then
					self.allowsSpraying = false;
				end;
		end;
		--print(self.lightsTypesMask)
		if self.attacherVehicle.lightsTypesMask ~= 0 or self.attacherVehicle.la then
			setVisibility(self.runningLight, true);
			setVisibility(self.blight, true);
			self.la = true;
			setVisibility(self.nrunningLight, false);
		else
			setVisibility(self.nrunningLight, true);
			setVisibility(self.runningLight, false);
			setVisibility(self.blight, false);
			self.la = false;
		end;
	end;
	if self.attacherVehicle == nil then -- turn off lights
		setVisibility(self.nrunningLight, true);
		setVisibility(self.runningLight, false);
		self.la = false;
	end;	
	self.BF = self.fillLevel; -- hmmmm fillLevel toggles between capacity and actual fill... go figure
	if self.BF < 100000 then -- filter for the fillLevel capacity problem. yer killing me Giants
		if self.BF ~= self.ZB and self.ZB < 99900 then -- switch for turning on and off
			self.bioFill = true;
		else
			self.bioFill = false;
		end;
	self.ZB = self.BF;
	end;
	if self.currentFillType ~= 0 then
	local desc = Fillable.fillTypeIndexToDesc[self.currentFillType];
	local name = desc.name;
		if name == 'biofuel' then
			setVisibility(self.BioFuel, true);
			setVisibility(self.Water, false);
			setVisibility(self.Slurry, false);
			setVisibility(self.UnKnown, false);	
		elseif name == 'water' then
			setVisibility(self.BioFuel, false);
			setVisibility(self.Water, true);
			setVisibility(self.Slurry, false);
			setVisibility(self.UnKnown, false);
		elseif name == 'liquidManure' then
			setVisibility(self.BioFuel, false);
			setVisibility(self.Water, false);
			setVisibility(self.Slurry, true);
			setVisibility(self.UnKnown, false);
		end;
	end;
	if self.currentFillType == 0 then
		setVisibility(self.BioFuel, false);
		setVisibility(self.Water, false);
		setVisibility(self.Slurry, false);
		setVisibility(self.UnKnown, true);	
	end;
end;

function BLT:updateTick(dt)
	if self.attacherVehicle ~= nil then -- do nothing if trailer is orphan
	local volume = 0;
	if self:getIsActiveForInput(false) then
		volume = 1.5;
	elseif g_currentMission.controlledVehicle == nil then --player on foot
		if g_currentMission.player ~= nil then
			local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
			local x, y, z = getWorldTranslation(self.rootNode);
			local farmerDistance = Utils.vector3Length(pvx-x, pvy-y, pvz-z);
			volume = (20-farmerDistance)/20
		end;
	end;
	--setSampleVolume(self.pumpSound,volume*self.pumpSoundVolume); -- pump sound events
	if self.attacherVehicle.isMotorStarted then
		if self.isFilling or self.isWaterTrailerFilling or self.tipState == 1 or self.bioFill or self.tipState == 2 and volume > 0 and not self.isTurnedOn then
			setVisibility(self.hose, true);
			if not self.pumpSoundEnabled  then
				playSample(self.pumpSound, 0, volume*self.pumpSoundVolume, 0);
				self.pumpSoundEnabled = true;
				htime = 2500; -- delay for ps to dissipate 
			end;
		else
			if self.pumpSoundEnabled then 
				self.pumpSoundEnabled = false;
				stopSample(self.pumpSound);
			end;
		setVisibility(self.hose, true); -- wait for ps to disappear and turn off hose
		htime = htime - dt;
			if htime <= 0 then
				setVisibility(self.hose, false);
			end;

		end;
		if self.isFilling or self.isTurnedOn or self.isWaterTrailerFilling or self.bioFill then 
			setVisibility(self.hose, true);
		end;
		self.printTime = nil;
	else
		if g_currentMission.trailerInTipRange and (Input.isKeyPressed(Input.KEY_q)) then -- timer for Warning
			self.printTime = self.time + 1500;
		elseif self.isFilling and Input.isKeyPressed(Input.KEY_r) then
			self.printTime = self.time + 1500;
		end;
		self:toggleTipState(nil);  -- attempt to disable tipping
		self.pumpSoundEnabled = false;
		stopSample(self.pumpSound);
		self.isFilling = false;
		htime = 0;
		if self.printTime ~= nil then
		self.printTime = self.printTime - dt;
		end;
	end;
	end;
end;

function BLT:delete() -- ensure sound doesn't stick when exiting...
	delete(self.pumpSound);
	self.pumpSound = nil;
end;

function BLT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BLT:keyEvent(unicode, sym, modifier, isDown)
end;

function BLT:draw()	
	if self.printTime ~= nil then
		if self.time < self.printTime then
			g_currentMission:addWarning(g_i18n:getText("StartTheMotor"), 0.018, 0.033);
		end;
	end;
end;

function BLT:onAttach()
end;

function BLT:onDetach()
end;