﻿--
-- Specialization for caseIH_mower LS 2015
-- by usxi7sd 07/2015

-- free for all

caseIH_mower = {};

function caseIH_mower.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function caseIH_mower:load(xmlFile)
	
	self.grasthreshingParticleSystem = {};
	local psName = "vehicle.grasthreshingParticleSystems";
	Utils.loadParticleSystem(xmlFile, self.grasthreshingParticleSystem, psName, self.components, false, nil, self.baseDirectory)
	self.particleyes = false;
	self.fillLevelmom = self.fillLevel;
	Utils.setEmittingState(self.grasthreshingParticleSystem, false);
	
	self.exhaustStartParticleSystem = {};
	local psName = "vehicle.exhaustStartParticleSystems";
	Utils.loadParticleSystem(xmlFile, self.exhaustStartParticleSystem, psName, self.components, false, nil, self.baseDirectory)
	Utils.setEmittingState(self.exhaustStartParticleSystem, false);
	
	local fillLevelAlarm = getXMLString(xmlFile, "vehicle.fillLevelAlarm#file");
    if fillLevelAlarm ~= nil and fillLevelAlarm ~= "" then
		fillLevelAlarm = Utils.getFilename(fillLevelAlarm, self.baseDirectory);
		self.fillLevelAlarm = createSample("fillLevelAlarm");
		self.fillLevelAlarmEnabled = false;
		loadSample(self.fillLevelAlarm, fillLevelAlarm, false);
		self.fillLevelAlarmPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLevelAlarm#pitchOffset"), 1);
		self.fillLevelAlarmVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLevelAlarm#volume"), 1);
		setSamplePitch(self.fillLevelAlarm, self.fillLevelAlarmPitchOffset);
    end;
	
	self.fillLevelpercent = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLevelAlarm#warnpercent"), 3);
	self.warnLevel = self.capacity / 100 * self.fillLevelpercent;	
	self.warn = 0;
end;

function caseIH_mower:delete()
	if self.isClient then
		Utils.deleteParticleSystem(self.grasthreshingParticleSystem);
		Utils.deleteParticleSystem(self.exhaustStartParticleSystem);
		if self.fillLevelAlarm ~= nil then
			delete(self.fillLevelAlarm);
			self.fillLevelAlarmEnabled = false;
		end;
    end;
end;

function caseIH_mower:readStream(streamId, connection)
end;
function caseIH_mower:writeStream(streamId, connection)
end;
function caseIH_mower:mouseEvent(posX, posY, isDown, isUp, button)
end;
function caseIH_mower:keyEvent(unicode, sym, modifier, isDown)
end;

function caseIH_mower:update(dt)
	if self:getIsActive() then	
		if self.isClient then
			if Utils.isSamplePlaying(self.sampleMotorStart) then                            -- variable from motor.lua
				Utils.setEmittingState(self.exhaustStartParticleSystem, true);   			-- PS on   
			else
				Utils.setEmittingState(self.exhaustStartParticleSystem, false);  			-- PS off
			end;			
		end; 
	end;
end;
	

function caseIH_mower:updateTick(dt)
	if self:getIsActive() then	
		if self.isClient then
			if self.fillLevelmom < self.fillLevel then
				self.particleyes = true;
				self.fillLevelmom = self.fillLevel;
			else
				self.fillLevelmom = self.fillLevel;
				self.particleyes = false;
			end;
			
			if self.isTurnedOn and self.fillLevel > (self.capacity - self.warnLevel) and not self.useMowerWindrowDropAreas then
				if not self.fillLevelAlarmEnabled and self:getIsActiveForSound() then     	-- alarm sound on
					setSamplePitch(self.fillLevelAlarm, self.fillLevelAlarmPitchOffset);
					playSample(self.fillLevelAlarm, 0, self.fillLevelAlarmVolume, 0);
					self.fillLevelAlarmEnabled = true;
				end;
            else
				if self.fillLevelAlarmEnabled then                                        	-- alarm sound off
					stopSample(self.fillLevelAlarm);
					self.fillLevelAlarmEnabled = false;
				end;
			end;
		
			if self.isTurnedOn and not self.useMowerWindrowDropAreas and self.fillLevel < self.capacity and self.fillLevel > 0 and self.particleyes then
				Utils.setEmittingState(self.grasthreshingParticleSystem, true);   			-- PS on   
			else
				Utils.setEmittingState(self.grasthreshingParticleSystem, false);  			-- PS off
			end;			
		
			if self.fillLevel == self.capacity then  										-- when tank is fully then no mowing possible
				self:setIsTurnedOn(false);
			end;	
		end;
	end;
end;

function caseIH_mower:draw()	
end;

function caseIH_mower:onDeactivateSounds()
	if self.isClient then
		if self.fillLevelAlarmEnabled then
			stopSample(self.fillLevelAlarm);
			self.fillLevelAlarmEnabled = false;
		end;
		Utils.stopSample(self.sampleMower, true);
		Utils.stopSample(self.sampleMowerStart, true);
	end;
end;