-- interiorTurnLights
--
-- Author RivalBomb

interiorTurnLights = {};
function interiorTurnLights.prerequisitesPresent(specializations)
    return true;
end;

function interiorTurnLights:load(xmlFile)
	self.interiorTS = {};

	self.interiorTS.blinkSpeed = Utils.getNoNil(getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#blinkSpeed"),0.44)*1000;
	self.interiorTS.t=self.interiorTS.blinkSpeed/2;
	self.interiorTS.leftIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#left"));
	self.interiorTS.rightIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#right"));
	self.interiorTS.active = false;
end;

function interiorTurnLights:delete()
end;

function interiorTurnLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function interiorTurnLights:keyEvent(unicode, sym, modifier, isDown)
end;

function interiorTurnLights:update(dt)
	self.interiorTS.t=self.interiorTS.t+dt;
	if self.interiorTS.t > self.interiorTS.blinkSpeed then
		self.interiorTS.active = not self.interiorTS.active;
		self.interiorTS.t=0;
	end;
	if self:getIsActive() then
		if self.turnSignalState == 1 or self.turnSignalState == 3 then 		-- Blinker links / Warnblinker
			setVisibility(self.interiorTS.leftIndex, self.interiorTS.active);
		end;
		if self.turnSignalState == 2 or self.turnSignalState == 3 then	-- Blinker rechts / Warnblinker
			setVisibility(self.interiorTS.rightIndex, self.interiorTS.active);
		end;
	end;	
end;

function interiorTurnLights:updateTick(dt)
end;

function interiorTurnLights:draw()
end;