--
-- DynamicCamera
-- Specialization for DynamicCamera mod
--
-- @author  	JoXXer
-- @date  		03/03/13
--

DynamicCamera = {};

function DynamicCamera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function DynamicCamera:load(xmlFile)
	
	self.cameraTransNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cameraTransNode#index"));
	self.rearWindow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearWindow#index"));

	self.insideCamera = self.cameras[1];
	
	self.origX, self.origY, self.origZ = getTranslation(self.cameraTransNode);
	
	self.xTrans = self.origX;
	
	self.rearTransLimitMod = 0.0025;
end;

function DynamicCamera:delete()
end;

function DynamicCamera:readStream(streamId, connection)
end;

function DynamicCamera:writeStream(streamId, connection)
end;

function DynamicCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DynamicCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function DynamicCamera:update(dt)
	if self:getIsActive() then
		if self.camIndex  == 1 then
			
			local rearX, rearY, rearZ = getRotation(self.rearWindow);
			if math.deg(rearX) > 50 then
				self.rearTransLimitMod = 0.0035;
			else
				self.rearTransLimitMod = 0.0025;
			end;
		
			local x, y, z = getRotation(self.insideCamera.cameraNode);
			
			local yFix = y;
			if yFix < 0 then
				yFix = -yFix;
			end;
				
			local timesTurned = yFix / math.rad(280);
			
			timesTurned = math.floor(timesTurned);
			
			if timesTurned >= 1 then
				if y < 0 then
					y = y + (math.rad(360) * timesTurned);
				else
					y = y - (math.rad(360) * timesTurned);
				end;
			end;
				
			if y < math.rad(80) and y > math.rad(-80) then
				local diff = math.rad(80);
				
				local origY = y;
				
				if y < 0 then
					y = -y;
				end;
				y = diff - y;
				
				if origY < 0 and self.xTrans >= self.origX then
					self.xTrans = self.origX + (math.deg(y) * 0.0025);
				elseif self.xTrans <= self.origX then
					self.xTrans = self.origX - (math.deg(y) * 0.0025);
				end;
				setTranslation(self.cameraTransNode, self.xTrans, (self.origY + (math.deg(y) * 0.002)), (self.origZ - (math.deg(y) * self.rearTransLimitMod))); 
			else
				setTranslation(self.cameraTransNode, self.origX, self.origY, self.origZ); 
				self.xTrans = self.origX;
			end;
		end;
	end;
end;

function DynamicCamera:updateTick(dt)

end;

function DynamicCamera:draw()

end;

function DynamicCamera:onLeave()

end;

function DynamicCamera:onEnter()

end;