-- author: rafftnix
-- date: 04.01.2015

AttachAnimation = {};

function AttachAnimation.prerequisitesPresent(specializations)
    return true;
end;

function AttachAnimation:load(xmlFile)
	self.attachAnimations = {}
	
	local num = 0;
	while true do
		local key = "vehicle.attachAnimations.animation("..tostring(num)..")";
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local attAnim = {}
		attAnim.jointDesc = self.attacherJoints[getXMLInt(xmlFile, key.."#jointIndex")];
		attAnim.animName = getXMLString(xmlFile, key.."#animName");
		attAnim.attached = false;
		
		table.insert(self.attachAnimations, attAnim);
		num = num + 1;
	end;
end;

function AttachAnimation:delete()
  
end;

function AttachAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttachAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function AttachAnimation:update(dt)
	
end;

function AttachAnimation:updateTick(dt)
	for a=1, table.getn(self.attachAnimations) do
		local attAnim = self.attachAnimations[a];
		if attAnim.jointDesc.jointIndex ~= 0 then -- attached
			if not attAnim.attached then
				self:playAnimation(attAnim.animName, 1, 0, true);
				attAnim.attached = true;
			end;
		else -- not attached
			if attAnim.attached then
				self:playAnimation(attAnim.animName, -1, 1, true);
				attAnim.attached = false;
			end;
		end;
	end;
end;

function AttachAnimation:draw()
  
end;