--[[
	All synch attributes in animations should be set to TRUE.
	All synch attributes in monitors should be set to TRUE.
	All synch attributes in visControl should be set to TRUE.
	All synch attributes in multi buttons should be set to FALSE.
	
	                        Available events for buttons
	# ---------- Event Name --------- # --- tested --- # - synch should be - #
	|  toggleBeaconLights             |  Yes: SP & MP  |        TRUE         |
	|  toggleHandBreak                |  No            |        ?????        |
	|  togglePipe                     |  No            |        ?????        |
	|  toggleFrontLights              |  Yes: SP & MP  |        FALSE        |
	|  toggleFrontWorkLights          |  Yes: SP & MP  |        FALSE        |
	|  toggleBackWorkLights           |  Yes: SP & MP  |        FALSE        |
	|  toggleBeamLights               |  Yes: SP       |        FALSE        |
	|  toggleTurnsignalLeft           |  Yes: SP       |        FALSE        |
	|  toggleTurnsignalRight          |  Yes: SP       |        FALSE        |
	|  toggleTurnsignalHazard         |  Yes: SP       |        FALSE        |
	|  toggleFoldFrontImplement       |  Yes: SP & MP  |        FALSE        |
	|  toggleFoldBackImplement        |  Yes: SP & MP  |        FALSE        |
	|  toggleFoldImplement            |  Yes: SP & MP  |        FALSE        |
	|  toggleFrontImplementUpDown     |  Yes: SP & MP  |        TRUE         |
	|  toggleBackImplementUpDown      |  Yes: SP & MP  |        TRUE         |
	|  toggleImplementUpDown          |  Yes: SP & MP  |        TRUE         |  
	|  toggleFrontImplementTurnState  |  Yes: SP & MP  |        FALSE        |
	|  toggleBackImplementTurnState   |  Yes: SP & MP  |        FALSE        |
	|  toggleImplementTurnState       |  Yes: SP & MP  |        FALSE        |
	|  dumpEquipment                  |  Yes: SP       |        FALSE        |
	|  dumpBackEquipment              |  Yes: SP       |        FALSE        |
	|  dumpFrontEquipment             |  Yes: SP       |        FALSE        |
	|  fillImplement                  |  Yes: SP & MP  |        FALSE        |
	|  fillFrontImplement	          |  Yes: SP & MP  |        FALSE        |
	|  fillBackImplement              |  Yes: SP & MP  |        FALSE        |
	|  tempomatUp                     |  Yes: SP       |        FALSE        |
	|  tempomatDown                   |  Yes: SP       |        FALSE        |
	|  toggleChopper                  |  Yes: SP       |        FALSE        |
	#---------------------------------#----------------#---------------------#
	
	Note: If some button don't work in MP, try change synch from false to
	true or from true to false

]]--

function InteractiveControl:actionOnObject(id, isObjectOpen, noEventSend)
	self:updateOpenStatus(id);
	
	if isObjectOpen ~= nil then
		self.LIC.interactiveObjects[id].isOpen = isObjectOpen;
	else
		self.LIC.interactiveObjects[id].isOpen = ( not self.LIC.interactiveObjects[id].isOpen );
	end;
	
	if self.LIC.interactiveObjects[id].objectType == 0 then
		if self.LIC.interactiveObjects[id].animClip ~= nil then 
			if self.LIC.interactiveObjects[id].animClip.animCharSet ~= nil then
				if self.LIC.interactiveObjects[id].looping then
					if not self.LIC.interactiveObjects[id].isOpen then
						disableAnimTrack(self.LIC.interactiveObjects[id].animClip.animCharSet, 0);
					else
						enableAnimTrack(self.LIC.interactiveObjects[id].animClip.animCharSet, 0);
					end;
				else
					if self.LIC.interactiveObjects[id].isOpen then
						if self.LIC.interactiveObjects[id].animClip.animCharSet ~= 0 then
							if getAnimTrackTime(self.LIC.interactiveObjects[id].animClip.animCharSet, 0) < 0.0 then
								setAnimTrackTime(self.LIC.interactiveObjects[id].animClip.animCharSet, 0, 0.0);
							end;
							setAnimTrackSpeedScale(self.LIC.interactiveObjects[id].animClip.animCharSet, 0, -self.LIC.interactiveObjects[id].speedScale);
							enableAnimTrack(self.LIC.interactiveObjects[id].animClip.animCharSet, 0);
						end;
					else
						if self.LIC.interactiveObjects[id].animClip.animCharSet ~= 0 then
							if getAnimTrackTime(self.LIC.interactiveObjects[id].animClip.animCharSet, 0) > self.LIC.interactiveObjects[id].animClip.animDuration then
								setAnimTrackTime(self.LIC.interactiveObjects[id].animClip.animCharSet, 0, self.LIC.interactiveObjects[id].animClip.animDuration);
							end;
							setAnimTrackSpeedScale(self.LIC.interactiveObjects[id].animClip.animCharSet, 0, self.LIC.interactiveObjects[id].speedScale);
							enableAnimTrack(self.LIC.interactiveObjects[id].animClip.animCharSet, 0);
						end;
					end;
				end;
			end;
		else
			if self.LIC.interactiveObjects[id].looping then
				if not self:getIsAnimationPlaying(self.LIC.interactiveObjects[id].animation) or isObjectOpen then
					self:playAnimation(self.LIC.interactiveObjects[id].animation, self.LIC.interactiveObjects[id].speedScale, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].animation), 0, 1), true);
					-- korekce dat
					self.LIC.interactiveObjects[id].isOpen = true;
				else
					self:stopAnimation(self.LIC.interactiveObjects[id].animation, true);
					-- korekce dat
					self.LIC.interactiveObjects[id].isOpen = false;
				end;
			else
				if self.LIC.interactiveObjects[id].isOpen then
					self:playAnimation(self.LIC.interactiveObjects[id].animation, -self.LIC.interactiveObjects[id].speedScale, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].animation), 0, 1), true);
				else
					self:playAnimation(self.LIC.interactiveObjects[id].animation, self.LIC.interactiveObjects[id].speedScale, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].animation), 0, 1), true);
				end;
			end;
		end;
	end;
	-- ANIM OK
	
	if self.LIC.interactiveObjects[id].objectType == 1 then
		if self.LIC.interactiveObjects[id].event == "toggleBeaconLights" then
			self:setBeaconLightsVisibility(self.LIC.interactiveObjects[id].isOpen, true);
		elseif self.LIC.interactiveObjects[id].event == "toggleHandBreak" then
			self.handbrake = self.LIC.interactiveObjects[id].isOpen;
		elseif self.LIC.interactiveObjects[id].event == "toggleChopper" then
			self:setIsStrawEnabled(self.LIC.interactiveObjects[id].isOpen);
		elseif self.LIC.interactiveObjects[id].event == "togglePipe" then
			local nextState = self.targetPipeState+1;
			if nextState > self.numPipeStates then
				nextState = 1;
			end;
			self:setPipeState(nextState);
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontLights" then
			if self.numLightTypes >= 1 then
				if self.LIC.interactiveObjects[id].isOpen ~= ( bitAND(self.lightsTypesMask, 2^0) == 1 ) then
					self:setLightsTypesMask(bitXOR(self.lightsTypesMask, 2^0));
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontWorkLights" then
			if self.numLightTypes >= 3 then
				if self.LIC.interactiveObjects[id].isOpen ~= ( bitAND(self.lightsTypesMask, 2^2) == 4 ) then
					self:setLightsTypesMask(bitXOR(self.lightsTypesMask, 2^2));
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackWorkLights" then
			if self.numLightTypes >= 2 then
				if self.LIC.interactiveObjects[id].isOpen ~= ( bitAND(self.lightsTypesMask, 2^1) == 2 ) then
					self:setLightsTypesMask(bitXOR(self.lightsTypesMask, 2^1));
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBeamLights" then
			if self.numLightTypes >= 4 then
				if self.LIC.interactiveObjects[id].isOpen ~= ( bitAND(self.lightsTypesMask, 2^3) == 8 ) then
					self:setLightsTypesMask(bitXOR(self.lightsTypesMask, 2^3));
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalLeft" then
			if self.turnSignalState ~= nil then
				if self.LIC.interactiveObjects[id].isOpen then
					self:setTurnSignalState(Vehicle.TURNSIGNAL_LEFT);
				else
					self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalRight" then
			if self.turnSignalState ~= nil then
				if self.LIC.interactiveObjects[id].isOpen then
					self:setTurnSignalState(Vehicle.TURNSIGNAL_RIGHT);
				else
					self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalHazard" then
			if self.turnSignalState ~= nil then
				if self.LIC.interactiveObjects[id].isOpen then
					self:setTurnSignalState(Vehicle.TURNSIGNAL_HAZARD);
				else
					self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldFrontImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								if self.LIC.interactiveObjects[id].isOpen then
									local dir = -1;
									if object.moveToMiddle then
										dir = object.foldMiddleDirection;
									else
										dir = -object.turnOnFoldDirection;
									end;
									if object:getToggledFoldDirection() == object.turnOnFoldDirection then
										object:setFoldState(dir, true);
									else
										object:setFoldState(dir, false);
									end;
								else
									local dir = 1;
									if object.moveToMiddle then
										dir = object.foldMiddleDirection;
									else
										dir = object.turnOnFoldDirection;
									end;
									if object:getToggledFoldDirection() == object.turnOnFoldDirection then
										object:setFoldState(dir, true);
									else
										object:setFoldState(dir, false);
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldBackImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								if self.LIC.interactiveObjects[id].isOpen then
									local dir = -1;
									if object.moveToMiddle then
										dir = object.foldMiddleDirection;
									else
										dir = -object.turnOnFoldDirection;
									end;
									if object:getToggledFoldDirection() == object.turnOnFoldDirection then
										object:setFoldState(dir, true);
									else
										object:setFoldState(dir, false);
									end;
								else
									local dir = 1;
									if object.moveToMiddle then
										dir = object.foldMiddleDirection;
									else
										dir = object.turnOnFoldDirection;
									end;
									if object:getToggledFoldDirection() == object.turnOnFoldDirection then
										object:setFoldState(dir, true);
									else
										object:setFoldState(dir, false);
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldImplement" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil and implement.object.getIsFoldAllowed ~= nil then
						if implement.object:getIsFoldAllowed() then
							if self.LIC.interactiveObjects[id].isOpen then
								local dir = -1;
								if implement.object.moveToMiddle then
									dir = implement.object.foldMiddleDirection;
								else
									dir = -implement.object.turnOnFoldDirection;
								end;
								if implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection then
									implement.object:setFoldState(dir, true);
								else
									implement.object:setFoldState(dir, false);
								end;
							else
								local dir = 1;
								if implement.object.moveToMiddle then
									dir = implement.object.foldMiddleDirection;
								else
									dir = implement.object.turnOnFoldDirection;
								end;
								if implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection then
									implement.object:setFoldState(dir, true);
								else
									implement.object:setFoldState(dir, false);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								object.setPickupState(object, self.LIC.interactiveObjects[id].isOpen);
							else
								self.lowerImplementByJointIndex(self, index, self.LIC.interactiveObjects[id].isOpen);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								object.setPickupState(object, self.LIC.interactiveObjects[id].isOpen);
							else
								self.lowerImplementByJointIndex(self, index, self.LIC.interactiveObjects[id].isOpen);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								object.setPickupState(object, self.LIC.interactiveObjects[id].isOpen);
							else
								self.lowerImplementByJointIndex(self, index, self.LIC.interactiveObjects[id].isOpen);
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								object.setPickupState(object, self.LIC.interactiveObjects[id].isOpen);
							else
								self.lowerImplementByJointIndex(self, index, self.LIC.interactiveObjects[id].isOpen);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen)
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen)
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen)
								end;
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self:setIsTurnedOn(self.LIC.interactiveObjects[id].isOpen)
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpEquipment" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
							if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
									if self.LIC.interactiveObjects[id].isOpen then
										implement.object:onStartTip(g_currentMission.trailerTipTriggers[implement.object][1], 1, false, true);
									else
										implement.object:onEndTip();
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpBackEquipment" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										if self.LIC.interactiveObjects[id].isOpen then
											implement.object:onStartTip(g_currentMission.trailerTipTriggers[implement.object][1], 1, false, true);
										else
											implement.object:onEndTip();
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpFrontEquipment" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										if self.LIC.interactiveObjects[id].isOpen then
											implement.object:onStartTip(g_currentMission.trailerTipTriggers[implement.object][1], 1, false, true);
										else
											implement.object:onEndTip();
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillImplement" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
							implement.object:setIsFilling(self.LIC.interactiveObjects[id].isOpen);
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillFrontImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								implement.object:setIsFilling(not implement.object.isFilling);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillBackImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								implement.object:setIsFilling(not implement.object.isFilling);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "tempomatUp" then
			self:setCruiseControlMaxSpeed(self.cruiseControl.speed + 1);
			if self.cruiseControl.speed ~= self.cruiseControl.speedSent then
				if g_server ~= nil then
					g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed));
				end;
				self.cruiseControl.speedSent = self.cruiseControl.speed;
			end;
		elseif self.LIC.interactiveObjects[id].event == "tempomatDown" then
			self:setCruiseControlMaxSpeed(self.cruiseControl.speed - 1);
			if self.cruiseControl.speed ~= self.cruiseControl.speedSent then
				if g_server ~= nil then
					g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed));
				end;
				self.cruiseControl.speedSent = self.cruiseControl.speed;
			end;
		elseif self.LIC.interactiveObjects[id].event == "openDisplayLayer" then
			-- something magical happens here
			for _,v1 in pairs(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes) do
				setVisibility(v1, false);
				setTranslation(v1, unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerBackupPos));
			end;
			if not self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].moveDef then
				setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], true);
				setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
			end;
			setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[id].index)], true);
			setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[id].index)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
		elseif self.LIC.interactiveObjects[id].event == "closeDisplayLayer" then
			-- and here
			for _,v1 in pairs(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes) do
				setVisibility(v1, false);
				setTranslation(v1, unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerBackupPos));
			end;
			setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], true);
			setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
		elseif string.sub( self.LIC.interactiveObjects[id].event, 1, 10 ) == "l2gsToggle" and type( self[self.LIC.interactiveObjects[id].event] ) == "function" then
			local fct = self[self.LIC.interactiveObjects[id].event];
			fct( self );
		end;
	end;
	-- BTN OK
	
	if self.LIC.interactiveObjects[id].objectType == 2 then
		if self:getIsActive() or isObjectOpen ~= nil then
			local dir = 1;
			if not self.LIC.interactiveObjects[id].isOpen then
				dir = -1;
			end;
			if self.LIC.interactiveObjects[id].startAnimation ~= nil then
				self:playAnimation(self.LIC.interactiveObjects[id].startAnimation, dir, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].startAnimation), 0, 1), true);
			end;
			if self.LIC.interactiveObjects[id].isOpen then
				for _,v in pairs(self.LIC.interactiveObjects[id].layerIndexes) do
					setTranslation(v, unpack(self.LIC.interactiveObjects[id].layerBackupPos));
					setVisibility(v, false);
				end;
				setTranslation(self.LIC.interactiveObjects[id].layerIndexes[(self.LIC.interactiveObjects[id].defaultLayer)], unpack(self.LIC.interactiveObjects[id].layerVisPos));
				setVisibility(self.LIC.interactiveObjects[id].layerIndexes[(self.LIC.interactiveObjects[id].defaultLayer)], true);
			else
				for _,v in pairs(self.LIC.interactiveObjects[id].layerIndexes) do
					setTranslation(v, unpack(self.LIC.interactiveObjects[id].layerBackupPos));
					setVisibility(v, false);
				end;
			end;
		end;
	end;
	-- MONITORS OK
	
	if self.LIC.interactiveObjects[id].objectType == 3 then
		if self.LIC.interactiveObjects[id].typeChange == "set" then
			if self.LIC.interactiveObjects[id].controlObject ~= nil then
				for _,v2 in ipairs(self.LIC.interactiveObjects[id].objects) do
					setVisibility(v2, self.LIC.interactiveObjects[id].isOpen);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].typeChange == "toggle" then
			for _,v2 in ipairs(self.LIC.interactiveObjects[id].objects) do
				setVisibility(v2, not getVisibility(v2));
			end;
		else
			print("Invalid change type in Interactive Visibility obejct!")
		end;
	end;
	-- vis control OK
	
	if self.LIC.interactiveObjects[id].objectType == 4 then
		local open = nil;
		if self.LIC.interactiveObjects[id].controlElement ~= nil then
			open = self.LIC.interactiveObjects[id].isOpen;
		end;
		for k,v in pairs(self.LIC.interactiveObjects[id].actionElements) do
			if v then
				self:actionOnObject(k,not open);
			else
				self:actionOnObject(k,open);
			end;
		end;
	end;
	
	if self.LIC.getElementListeners[id] ~= nil then
		for _,v in pairs(self.LIC.getElementListeners[id]) do
			for _,v2 in pairs(self.LIC.objectsListeners[v]) do
				if v2 ~= id then
					self.LIC.interactiveObjects[v2].isOpen = self.LIC.interactiveObjects[id].isOpen;
				end;
			end;
		end;
	end;
	
	-- odeslat vysledek snazeni
	if (noEventSend == nil or noEventSend == false) and self.LIC.interactiveObjects[id].synch then
		if g_server ~= nil then
			g_server:broadcastEvent(InteractiveControlEvent:new(self, id, self.LIC.interactiveObjects[id].isOpen), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(InteractiveControlEvent:new(self, id, self.LIC.interactiveObjects[id].isOpen));
		end;
	end;
end;


-- get actul open status
function InteractiveControl:updateOpenStatus(id)
	if self.LIC.interactiveObjects[id].objectType == 0 then
	end;
	
	if self.LIC.interactiveObjects[id].objectType == 1 then
		if self.LIC.interactiveObjects[id].event == "toggleBeaconLights" then
			self.LIC.interactiveObjects[id].isOpen = self.beaconLightsActive;
		elseif self.LIC.interactiveObjects[id].event == "toggleHandBreak" then
			self.LIC.interactiveObjects[id].isOpen = self.handbrake;
		elseif self.LIC.interactiveObjects[id].event == "toggleChopper" then
			self.LIC.interactiveObjects[id].isOpen = self.isStrawEnabled;
		elseif self.LIC.interactiveObjects[id].event == "togglePipe" then
			self.LIC.interactiveObjects[id].isOpen = self.targetPipeState ~= 1;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontLights" then
			if self.numLightTypes >= 1 then
				self.LIC.interactiveObjects[id].isOpen = ( bitAND(self.lightsTypesMask, 2^0) == 1 );
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackWorkLights" then
			if self.numLightTypes >= 2 then
				self.LIC.interactiveObjects[id].isOpen = ( bitAND(self.lightsTypesMask, 2^1) == 2 );
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontWorkLights" then
			if self.numLightTypes >= 3 then
				self.LIC.interactiveObjects[id].isOpen = ( bitAND(self.lightsTypesMask, 2^2) == 4 );
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBeamLights" then
			if self.numLightTypes >= 4 then
				self.LIC.interactiveObjects[id].isOpen = ( bitAND(self.lightsTypesMask, 2^3) == 8 );
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalLeft" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_LEFT then
					self.LIC.interactiveObjects[id].isOpen = true;
				else
					self.LIC.interactiveObjects[id].isOpen = false;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalRight" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_RIGHT then
					self.LIC.interactiveObjects[id].isOpen = true;
				else
					self.LIC.interactiveObjects[id].isOpen = false;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalHazard" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_HAZARD then
					self.LIC.interactiveObjects[id].isOpen = true;
				else
					self.LIC.interactiveObjects[id].isOpen = false;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldFrontImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								self.LIC.interactiveObjects[id].isOpen = (object:getToggledFoldDirection() == object.turnOnFoldDirection) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldBackImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								self.LIC.interactiveObjects[id].isOpen = (object:getToggledFoldDirection() == object.turnOnFoldDirection) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil and implement.object.getIsFoldAllowed ~= nil then
						if implement.object:getIsFoldAllowed() then
							self.LIC.interactiveObjects[id].isOpen = (implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection) or self.LIC.interactiveObjects[id].isOpen;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementUpDown" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isPickupLowered) or self.LIC.interactiveObjects[id].isOpen;
							else
								self.LIC.interactiveObjects[id].isOpen = (object:isLowered()) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementUpDown" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isPickupLowered) or self.LIC.interactiveObjects[id].isOpen;
							else
								self.LIC.interactiveObjects[id].isOpen = (object:isLowered()) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementUpDown" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isPickupLowered) or self.LIC.interactiveObjects[id].isOpen;
							else
								self.LIC.interactiveObjects[id].isOpen = (object:isLowered()) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered ~= nil and object.setPickupState ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isPickupLowered) or self.LIC.interactiveObjects[id].isOpen;
							else
								self.LIC.interactiveObjects[id].isOpen = (object:isLowered()) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementTurnState" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self.LIC.interactiveObjects[id].isOpen = (self.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementTurnState" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self.LIC.interactiveObjects[id].isOpen = (self.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementTurnState" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self.LIC.interactiveObjects[id].isOpen = (self.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
								end;
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (object.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
									self.LIC.interactiveObjects[id].isOpen = (self.isTurnedOn) or self.LIC.interactiveObjects[id].isOpen;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpEquipment" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
							if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
									self.LIC.interactiveObjects[id].isOpen = ((implement.object.tipState == Trailer.TIPSTATE_OPENING or implement.object.tipState == Trailer.TIPSTATE_OPEN)) or self.LIC.interactiveObjects[id].isOpen;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpBackEquipment" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										self.LIC.interactiveObjects[id].isOpen = ((implement.object.tipState == Trailer.TIPSTATE_OPENING or implement.object.tipState == Trailer.TIPSTATE_OPEN)) or self.LIC.interactiveObjects[id].isOpen;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpFrontEquipment" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										self.LIC.interactiveObjects[id].isOpen = ((implement.object.tipState == Trailer.TIPSTATE_OPENING or implement.object.tipState == Trailer.TIPSTATE_OPEN)) or self.LIC.interactiveObjects[id].isOpen;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
							self.LIC.interactiveObjects[id].isOpen = (implement.object.isFilling) or self.LIC.interactiveObjects[id].isOpen;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillFrontImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (implement.object.isFilling) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillBackImplement" then
			self.LIC.interactiveObjects[id].isOpen = false;
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								self.LIC.interactiveObjects[id].isOpen = (implement.object.isFilling) or self.LIC.interactiveObjects[id].isOpen;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if self.LIC.interactiveObjects[id].objectType == 2 then
	end;
	
	if self.LIC.interactiveObjects[id].objectType == 3 then
		if self.LIC.interactiveObjects[id].controlObject ~= nil then
			self.LIC.interactiveObjects[id].isOpen = getVisibility(self.LIC.interactiveObjects[id].controlObject);
		end;
	end;
	
	if self.LIC.interactiveObjects[id].objectType == 4 then
		if self.LIC.interactiveObjects[id].controlElement ~= nil then
			self:updateOpenStatus(self.LIC.interactiveObjects[id].controlElement);
			self.LIC.interactiveObjects[id].isOpen = self.LIC.interactiveObjects[self.LIC.interactiveObjects[id].controlElement].isOpen;
		else
			
		end;
	end;
end;