bennaScaricoCentrale = {}
source("dataS/scripts/vehicles/specializations/SetTurnedOnEvent.lua")
function bennaScaricoCentrale.prerequisitesPresent(specializations) return true; end;
function bennaScaricoCentrale:load(xmlFile) self.isReset = false; self.isResetHelp = false; self.isTurnedOn = false; self.lastEmptyTime = -10000;
	self.findTrailerRaycastCallback = bennaScaricoCentrale.findTrailerRaycastCallback; self.getEmptyingSpeed = bennaScaricoCentrale.getEmptyingSpeed;
	self.setIsTurnedOn = bennaScaricoCentrale.setIsTurnedOn; self.emptySpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.overloadingCapacity"), self.capacity / 2) * 0.001; end;
function bennaScaricoCentrale:delete() end;
function bennaScaricoCentrale:mouseEvent(posX, posY, isDown, isUp, button) end;
function bennaScaricoCentrale:keyEvent(unicode, sym, modifier, isDown) end;
function bennaScaricoCentrale:update(dt) local xr, yr, zr = getRotation(self.components[1].node); if xr < 0 then if xr > -0.50 or xr < -1.05 and (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then self:onEndTip(true); end; elseif xr < 2.00 or xr > 2.65 and (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then self:onEndTip(true); end; if self.isClient and self:getIsActiveForInput() and self.isResetHelp == false and self.fillLevel > 0 and InputBinding.hasEvent(InputBinding.OpenClose) then self:setIsTurnedOn(not self.isTurnedOn); end; if self.isResetHelp == true then if self.isTurnedOn and (self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_CLOSED) then self:setIsTurnedOn(not self.isTurnedOn); elseif not self.isTurnedOn and (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then self:setIsTurnedOn(not self.isTurnedOn); end; end; end;
function bennaScaricoCentrale:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) return BaseMission.VEHICLE_LOAD_OK; end;
function bennaScaricoCentrale:getSaveAttributesAndNodes(nodeIdent) end;
function bennaScaricoCentrale:updateTick(dt) if self.currentAttacco == 4 and self.isReset == false then self:playAnimation("tubiIdraulici", -1); self.isReset = true; end;
	if self:getIsActive() and self.isServer and self.isTurnedOn then local emptySpeed = self:getEmptyingSpeed(); if emptySpeed > 0 then
		if 0 < self.fillLevel and self.shovelTipReferenceNode ~= nil then self.trailerFoundBSC = nil; self.objectFoundBSC = nil; local x, y, z = getWorldTranslation(self.shovelTipReferenceNode); raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", self.shovelTipRaycastDistance, self); local fillDelta = math.min(self.fillLevel, emptySpeed * dt); local fillType = self.currentFillType; local fillTypeRatio = 1.0;
		if self.trailerFoundBSC ~= nil or self.objectFoundBSC ~= nil then if self.trailerFoundBSC ~= nil and self.trailerFoundBSCSupported 
			then self.trailerFoundBSC:resetFillLevelIfNeeded(fillType) do local oldFillLevel = self.trailerFoundBSC:getFillLevel(fillType) self.trailerFoundBSC:setFillLevel(oldFillLevel + fillDelta, fillType) fillDelta = self.trailerFoundBSC:getFillLevel(fillType) - oldFillLevel; end;
			elseif self.objectFoundBSC ~= nil and self.objectFoundBSCSupported then local fillDelta1 = self.objectFoundBSC:addShovelFillLevel(self, fillDelta, fillType) if fillDelta1 ~= nil then fillDelta = fillDelta1; end;	else fillDelta = 0; end; end;
			if fillDelta ~= 0 then local fillType = self.currentFillType; local oldFillLevel = self.fillLevel; self:setFillLevel(oldFillLevel - fillDelta * fillTypeRatio, fillType); self.lastEmptyTime = g_currentMission.time; if self.isTurnedOn and (self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_CLOSED) then self:setIsTurnedOn(not self.isTurnedOn); elseif not self.isTurnedOn and (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then self:setIsTurnedOn(not self.isTurnedOn); end; self.isResetHelp = true; end; end; end; end; end;
function bennaScaricoCentrale:draw() if self.currentSpondine == 1 or self.fillLevel <= 0 then if self.isTurnedOn then self:setIsTurnedOn(not self.isTurnedOn); end; self.isResetHelp = false; g_currentMission:addExtraPrintText(g_i18n:getText("scaricoOff")); else local xr, yr, zr = getRotation(self.components[1].node); if xr < 0 then if xr > -0.50 or xr < -1.05 then g_currentMission:addExtraPrintText(g_i18n:getText("scaricoOff")); end; elseif xr < 2.00 or xr > 2.65 then g_currentMission:addExtraPrintText(g_i18n:getText("scaricoOff")); end; end; if self.isClient and self.isResetHelp == false and self.fillLevel > 0 then if self.isTurnedOn then g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Stop_overloading")), InputBinding.OpenClose); else g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Start_overloading")), InputBinding.OpenClose); end; end; end;
function bennaScaricoCentrale:onAttach(attacherVehicle, jointDescIndex) self.isReset = false; self:playAnimation("tubiIdraulici", 1); end;
function bennaScaricoCentrale:onDetach() self:playAnimation("tubiIdraulici", -1); end;
function bennaScaricoCentrale:onDeactivate() self:setIsTurnedOn(false, true); end;
function bennaScaricoCentrale:getEmptyingSpeed() if self.shovelTipReferenceNode ~= nil then local dx, dy, dz = localDirectionToWorld(self.shovelTipReferenceNode, 0, 0, 1) if self.isTurnedOn then local scale = 1; return self.emptySpeed * scale; end; end; return 0; end;
function bennaScaricoCentrale:findTrailerRaycastCallback(transformId, x, y, z, distance)
	local trailer = g_currentMission.objectToTrailer[transformId]; if trailer ~= nil and trailer ~= self then
	if trailer:allowFillType(self.currentFillType) and trailer.getAllowFillFromAir ~= nil and trailer:getAllowFillFromAir() then self.trailerFoundBSC = trailer; self.trailerFoundBSCSupported = true;
    elseif self.trailerFoundBSC == nil then self.trailerFoundBSC = trailer; self.trailerFoundBSCSupported = false; end; return false; end;
	local object = g_currentMission:getNodeObject(transformId) if object ~= nil and object ~= self and object.addShovelFillLevel ~= nil and object.getAllowShovelFillType ~= nil then
	if object:getAllowShovelFillType(self.currentFillType) then self.objectFoundBSC = object; self.objectFoundBSCSupported = true; return false;
    elseif self.objectFoundBSC == nil then self.objectFoundBSC = object; self.objectFoundBSCSupported = false; end; end; return true; end;
function bennaScaricoCentrale:readStream(streamId, connection) local turnedOn = streamReadBool(streamId); self:setIsTurnedOn(turnedOn, true); end;
function bennaScaricoCentrale:writeStream(streamId, connection) streamWriteBool(streamId, self.isTurnedOn); end;
function bennaScaricoCentrale:setIsTurnedOn(isTurnedOn, noEventSend)
	if isTurnedOn ~= self.isTurnedOn then SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend); self.isTurnedOn = isTurnedOn; end; end;