adattatore = {};
Vehicle.registerJointType("adattatoreCSZ");
function adattatore.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(Cylindered, specializations); end;
function adattatore:load(xmlFile) self.setAlphas = SpecializationUtil.callSpecializationsFunction("setAlphas");
	self.indexHydraulics = {}; self.indexHydraulics.min = 0; self.indexHydraulics.max = 2.2; self.indexHydraulics.uAA = false; self.currentLowerAlpha = 0; self.currentUpperAlpha = 0; self.indexHydraulics.mt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexHydraulics#index")); end;
function adattatore:readStream(streamId, connection) self:setAlphas(streamReadFloat32(streamId), streamReadFloat32(streamId), true); end;
function adattatore:writeStream(streamId, connection) streamWriteFloat32(streamId, self.currentLowerAlpha); streamWriteFloat32(streamId, self.currentUpperAlpha); end;
function adattatore:setAlphas(lower, upper, noEventSend) local jointdesc;
	if self.attacherVehicle ~= nil then	for _, implement in pairs(self.attacherVehicle.attachedImplements) do if implement.object == self then jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex]; end; end;	end;
	if jointDesc ~= nil then jointDesc.lowerAlpha = lower; jointDesc.upperAlpha = upper; self.currentLowerAlpha = lower; self.currentUpperAlpha = upper; end; SetAlphasEvent.sendEvent(self, lower, upper, noEventSend); end;
function adattatore:delete() end;
function adattatore:mouseEvent(posX, posY, isDown, isUp, button) end;
function adattatore:keyEvent(unicode, sym, modifier, isDown) end;
function adattatore:update(dt) end;
function adattatore:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) return BaseMission.VEHICLE_LOAD_OK; end;
function adattatore:getSaveAttributesAndNodes(nodeIdent) end;
function adattatore:updateTick(dt) if self.nodesToMovingTools[self.indexHydraulics.mt].lastRotSpeed ~= 0 or self.indexHydraulics.uAA then
	local x, y, z = getRotation(self.nodesToMovingTools[self.indexHydraulics.mt].node); local t = 1-math.abs(math.max(math.min((x-self.nodesToMovingTools[self.indexHydraulics.mt].rotMin)/(self.nodesToMovingTools[self.indexHydraulics.mt].rotMax-self.nodesToMovingTools[self.indexHydraulics.mt].rotMin), 1), 0));
	if self.attacherVehicle ~= nil then	for _, implement in pairs(self.attacherVehicle.attachedImplements) do if implement.object == self then
		local smax = self.indexHydraulics.max; local smin = self.indexHydraulics.min; self:setAlphas((smax-smin)*t+smin, (smax-smin)*t+smin);
		if self.indexHydraulics.uAA then self.indexHydraulics.uAA = false; end; end; end; end; end; end;
function adattatore:draw() end;
function adattatore:onAttach() self.indexHydraulics.uAA = true; end;
function adattatore:onDetach() end;
function adattatore:onDeactivate() end;
SetAlphasEvent = {}; SetAlphasEvent_mt = Class(SetAlphasEvent, Event); InitEventClass(SetAlphasEvent, "SetAlphasEvent");
function SetAlphasEvent:emptyNew() local self = Event:new(SetAlphasEvent_mt); self.className="SetAlphasEvent"; return self; end;
function SetAlphasEvent:new(vehicle, upper, lower) local self = SetAlphasEvent:emptyNew() self.vehicle = vehicle; self.upper = upper; self.lower = lower; return self; end;
function SetAlphasEvent:readStream(streamId, connection) local id = streamReadInt32(streamId); self.vehicle = networkGetObject(id);	self.upper = streamReadFloat32(streamId); self.lower = streamReadFloat32(streamId); if self.vehicle ~= nil then	self.vehicle:setAlphas(self.upper, self.lower, true); end; if not connection:getIsServer() then g_server:broadcastEvent(SetAlphasEvent:new(self.vehicle, self.upper, self.lower), nil, connection, self.vehicle); end; end;
function SetAlphasEvent:writeStream(streamId, connection) streamWriteInt32(streamId, networkGetObjectId(self.vehicle)); streamWriteFloat32(streamId, self.upper); streamWriteFloat32(streamId, self.lower); end;
function SetAlphasEvent.sendEvent(vehicle, upper, lower, noEventSend) if noEventSend == nil or noEventSend == false then if g_server ~= nil then g_server:broadcastEvent(SetAlphasEvent:new(vehicle, upper, lower), nil, nil, vehicle); else g_client:getServerConnection():sendEvent(SetAlphasEvent:new(vehicle, upper, lower)); end; end; end;