--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);
	if self.count ~= 0 then
		for i=1, self.count do
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText("ic_button_on");
			local offMessage = g_i18n:getText("ic_button_off");

			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;

end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;

	return instance;
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		self.isOpen = self.vehicle.currentLight == 3;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleMotorIgnition" then		
			self.isOpen = self.vehicle.isMotorStarted;
		end;
	end;

	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
	if self.event == "toggleFrontWiper" then
		if self.vehicle ~= nil then
			if self.vehicle.wiperFrontOn then
				self.vehicle.wiperFrontOn = false;
			else
				self.vehicle.wiperFrontOn = true;
			end;
		end;
	end;
	if self.event == "toggleBackWiper" then
		if self.vehicle ~= nil then
			if self.vehicle.wiperBackOn then
				self.vehicle.wiperBackOn = false;
			else
				self.vehicle.wiperBackOn = true;
			end;
		end;
	end;
	if self.event == "lightCoronas" then
		if self.vehicle ~= nil then
			if self.vehicle.realLightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "Display_Off" then
		if self.vehicle ~= nil then
			if self.vehicle.realLightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "toggleFrontWorklights" then
		if self.vehicle ~= nil then
			local i = 1;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;

	if self.event == "toggleBackWorklights" then
		if self.vehicle ~= nil then
			local i = 2;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
		if self.event == "toggleFrontWorklights2" then
		if self.vehicle ~= nil then
			local i = 3;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	
	if self.event == "toggleRightIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.turnSignalRight[1].a then
					self.vehicle:setState("turnSignalLeft", false);
					self.vehicle:setState("turnSignalRight", false);
				else
					self.vehicle:setState("turnSignalLeft", false);
					self.vehicle:setState("turnSignalRight", true);
				end;
			end;
		end;
	end;
	if self.event == "toggleLeftIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.turnSignalLeft[1].a then
					self.vehicle:setState("turnSignalLeft", false);
					self.vehicle:setState("turnSignalRight", false);
				else
					self.vehicle:setState("turnSignalLeft", true);
					self.vehicle:setState("turnSignalRight", false);
				end;
			end;
		end;
	end;
	if self.event == "toggleWarningLights" then
		if self.vehicle ~= nil then
			if self.vehicle.B3.wl then
				self.vehicle:setState("warnlights", false);
				self.vehicle:setState("turnSignalLeft", false);
				self.vehicle:setState("turnSignalRight", false);
			else
				self.vehicle:setState("warnlights", true);
				self.vehicle:setState("turnSignalLeft", true);
				self.vehicle:setState("turnSignalRight", true);
			end;
		end;
	end;
	if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;
	end;
	if self.vehicle ~= nil then
        if self.event == "toggleMotorIgnition" then
			if self.vehicle.isMotorStarted then
				self.vehicle:invokeIgnition(false, noEventSend);
			else
				self.vehicle:invokeIgnition(true, noEventSend);
			end;
		end;	
	end;
	if self.event == "lowerBack" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
	end;
	if self.event == "lowerBack2" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
	end;
	if self.event == "lowerFront" then
		if self.vehicle.lowerFront then
			self.vehicle:setJointMoveDown(2, false);
			self.vehicle.lowerFront = false;
		else
			self.vehicle:setJointMoveDown(2, true);
			self.vehicle.lowerFront = true;
		end;
	end;
	if self.event == "toggleallrad" then
		if self.vehicle ~= nil then
			self.vehicle:allradState(not self.vehicle.AllradV41Active);
		end;
	end;
	if self.event == "Display_Off" then
		if self.vehicle ~= nil then
			for k, implement in pairs(self.vehicle.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn ~= nil then
						if implement.object.isTurnedOn then
							implement.object.isTurnedOn = false;
						else
							implement.object.isTurnedOn = true;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;
