--***************************************************************
_G[g_currentModName..".mogliBase"].newClass( "GearboxHud" )
--***************************************************************

function GearboxHud:load(xmlFile)
	self.getHudGearNumber = GearboxHud.getHudGearNumber
	self.getHudDirection  = GearboxHud.getHudDirection
end

function GearboxHud:getHudGearNumber()
	if type( self.mrGbMGetIsOnOff ) ~= "function" or type( self.mrGbMGetGearNumber ) ~= "function" or not ( self:mrGbMGetIsOnOff() ) then
		return 0
	end
	local gear = self:mrGbMGetGearNumber()
	if gear ~= nil then
		if     self:mrGbMGetReverseActive() then
			-- R
			gear = gear + 400
		elseif gear >= 17 then
			-- H
			gear = 216
		elseif gear >= 16 then
			-- L
			gear = 316
		end
		return gear
	end
	return 0
end

function GearboxHud:getHudDirection()
	if type( self.mrGbMGetIsOnOff ) == "function" and self:mrGbMGetIsOnOff() then
		if     self:mrGbMGetReverseActive() then
			--reverse
			return 006
		elseif self:mrGbMGetNeutralActive() then
			--neutral
			return 070
		else
			--forward
			return 500
		end
	end
	
	-- drive control
	if      type( self.dCcheckModule )           == "function"
			and self.driveControl                    ~= nil 
			and self:dCcheckModule("shuttle")
			and self.driveControl.shuttle            ~= nil 
			and self.driveControl.shuttle.isActive 
			and self.driveControl.shuttle.direction  ~= nil then
		if     self.driveControl.shuttle.direction > 0 then
			--forward
			return 500
		elseif self.driveControl.shuttle.direction < 0 then
			--reverse
			return 006
		else
			--neutral
			return 070
		end
	end
	
	if     self.movingDirection > 0 then
		--forward
		return 500
	elseif self.movingDirection < 0 then
		--reverse
		return 006
	end
	--neutral
	return 070
end