--
-- BumbGewicht
-- Specialization for BumbGewicht
--
-- @author Filip "MonkeyWalk" F. und Marhu
-- @date  01/02/16 v1.0
--
-- Copyright (C) MonkeyWalk, All Rights Reserved.
--


BumbGewichtSide = {};

function BumbGewichtSide.prerequisitesPresent(specializations)
    return true;
end;

function BumbGewichtSide:load(xmlFile)
	self.setSideState = SpecializationUtil.callSpecializationsFunction("setSideState");
	
	self.sideRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.sideRight#index"));
    self.sideLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.sideLeft#index"));	
	
    self.SideState = 0;	
end;

function BumbGewichtSide:delete()
end;

function BumbGewichtSide:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BumbGewichtSide:keyEvent(unicode, sym, modifier, isDown)
end;

function BumbGewichtSide:update(dt)
    if self:getIsActiveForInput() then
	     if self.isClient and InputBinding.hasEvent(InputBinding.moveSides) then
			 g_client:getServerConnection():sendEvent(BumbGewichtSideEvent:new(self, self.SideState + 1 ));
		 end;
	end;  
	if self.newSideState then
		self.newSideState = nil;
		if self.SideState == 0  then
			setTranslation(self.sideRight, 0.345, 0.132, 0.177);
			setTranslation(self.sideLeft, -0.349, 0.132, 0.178);
		elseif self.SideState == 1 then
			setTranslation(self.sideRight, 0.44, 0.132, 0.226);
			setTranslation(self.sideLeft, -0.44, 0.132, 0.226);
		elseif self.SideState == 2 then
			setTranslation(self.sideRight, 0.537, 0.132, 0.277);
			setTranslation(self.sideLeft, -0.537, 0.132, 0.277);
		elseif self.SideState == 3 then
			setTranslation(self.sideRight, 0.608, 0.132, 0.316);
			setTranslation(self.sideLeft, -0.608, 0.132, 0.316);
        elseif self.SideState == 4 then
			setTranslation(self.sideRight, 0.655, 0.132, 0.345);
			setTranslation(self.sideLeft, -0.655, 0.132, 0.345);
        elseif self.SideState == 5 then
		    setTranslation(self.sideRight, 0.345, 0.132, 0.177);
			setTranslation(self.sideLeft, -0.349, 0.132, 0.178);
			self.SideState = 0;			
		end;
	end;
end;
function BumbGewichtSide:setSideState(state)
	self.SideState = state;
	self.newSideState = true;
	if self.isServer then
        g_server:broadcastEvent(BumbGewichtSideEvent:new(self, self.SideState), true, nil, self);
	end;
end
function BumbGewichtSide:updateTick(dt)
end;

function BumbGewichtSide:draw()
g_currentMission:addHelpButtonText(g_i18n:getText("moveSides"), InputBinding.moveSides);	
end;

BumbGewichtSideEvent = {};
BumbGewichtSideEvent_mt = Class(BumbGewichtSideEvent, Event);
InitEventClass(BumbGewichtSideEvent, "BumbGewichtSideEvent");
function BumbGewichtSideEvent:emptyNew()
    local self = Event:new(BumbGewichtSideEvent_mt);
    return self;
end;
function BumbGewichtSideEvent:new(object, stateId)
    local self = BumbGewichtSideEvent:emptyNew()
    self.object = object;
    self.SideStateId = stateId;
    return self;
end;
function BumbGewichtSideEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.SideStateId = streamReadInt8(streamId);
    self:run(connection);
end;
function BumbGewichtSideEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.SideStateId);
   
end;
function BumbGewichtSideEvent:run(connection)
	if self.object.SideState ~= self.SideStateId then
		self.object:setSideState(self.SideStateId);
	end
end;