--
-- BumbGewicht
-- Specialization for BumbGewicht
--
-- @author Filip "MonkeyWalk" F. und Marhu
-- @date  01/02/16 v1.0
--
-- Copyright (C) MonkeyWalk, All Rights Reserved.
--


BumbGewicht = {};

function BumbGewicht.prerequisitesPresent(specializations)
    return true;
end;

function BumbGewicht:load(xmlFile)
	self.setGewichtState = SpecializationUtil.callSpecializationsFunction("setGewichtState");
	
	self.panelRight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.panelRight1#index"));
    self.panelLeft1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.panelLeft1#index"));
    self.panelRight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.panelRight2#index"));
    self.panelLeft2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BumbGewicht.panelLeft2#index"));	
	
    self.GewichtState = 0;	
end;

function BumbGewicht:delete()
end;

function BumbGewicht:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BumbGewicht:keyEvent(unicode, sym, modifier, isDown)
end;

function BumbGewicht:update(dt)
    if self:getIsActiveForInput() then
	     if self.isClient and InputBinding.hasEvent(InputBinding.movePanels) then
			 g_client:getServerConnection():sendEvent(BumbGewichtEvent:new(self, self.GewichtState + 1 ));
		 end;
	end;  
	if self.newGewichtState then
		self.newGewichtState = nil;
		if self.GewichtState == 0  then
			setRotation(self.panelRight1, 0, 0, 0);
			setRotation(self.panelRight2, 0, 0, 0);
	        setRotation(self.panelLeft1, 0, 0, 0);
			setRotation(self.panelLeft2, 0, 0, 0);
		elseif self.GewichtState == 1 then
			setRotation(self.panelRight1, 0, -0.142, 0);
			setRotation(self.panelRight2, 0, -0.392, 0);
			setRotation(self.panelLeft1, 0, 0.142, 0);
			setRotation(self.panelLeft2, 0, 0.392, 0);
		elseif self.GewichtState == 2 then
			setRotation(self.panelRight1, 0, -0.304, 0);
			setRotation(self.panelRight2, 0, -0.864, 0);
			setRotation(self.panelLeft1, 0, 0.304, 0);
			setRotation(self.panelLeft2, 0, 0.864, 0);
		elseif self.GewichtState == 3 then
			setRotation(self.panelRight1, 0, -0.458, 0);
			setRotation(self.panelRight2, 0, -1.518, 0);
			setRotation(self.panelLeft1, 0, 0.458, 0);
			setRotation(self.panelLeft2, 0, 1.518, 0);
        elseif self.GewichtState == 4 then
			setRotation(self.panelRight1, 0, 0.180, 0);
			setRotation(self.panelRight2, 0, 0.342, 0);
			setRotation(self.panelLeft1, 0, -0.180, 0);
			setRotation(self.panelLeft2, 0, -0.342, 0);
        elseif self.GewichtState == 5 then
		    setRotation(self.panelRight1, 0, 0, 0);
			setRotation(self.panelRight2, 0, 0, 0);
	        setRotation(self.panelLeft1, 0, 0, 0);
			setRotation(self.panelLeft2, 0, 0, 0);
			self.GewichtState = 0;			
		end;
	end;
end;
function BumbGewicht:setGewichtState(state)
	self.GewichtState = state;
	self.newGewichtState = true;
	if self.isServer then
        g_server:broadcastEvent(BumbGewichtEvent:new(self, self.GewichtState), true, nil, self);
	end;
end
function BumbGewicht:updateTick(dt)
end;

function BumbGewicht:draw()
  g_currentMission:addHelpButtonText(g_i18n:getText("movePanels"), InputBinding.movePanels);	
end;

BumbGewichtEvent = {};
BumbGewichtEvent_mt = Class(BumbGewichtEvent, Event);
InitEventClass(BumbGewichtEvent, "BumbGewichtEvent");
function BumbGewichtEvent:emptyNew()
    local self = Event:new(BumbGewichtEvent_mt);
    return self;
end;
function BumbGewichtEvent:new(object, stateId)
    local self = BumbGewichtEvent:emptyNew()
    self.object = object;
    self.GewichtStateId = stateId;
    return self;
end;
function BumbGewichtEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.GewichtStateId = streamReadInt8(streamId);
    self:run(connection);
end;
function BumbGewichtEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.GewichtStateId);
   
end;
function BumbGewichtEvent:run(connection)
	if self.object.GewichtState ~= self.GewichtStateId then
		self.object:setGewichtState(self.GewichtStateId);
	end
end;