--
-- @version 		v1.1
-- @date  			26/12/10
-- @author  		fruktor
--

Rolls = {};

function Rolls.prerequisitesPresent(specializations)
	return true;
end;

function Rolls:load(xmlFile)
	self.rollsDis = {};
	self.rollsDis.object = {};
	self.rollsDis.speed = {};
	local i=1;
	while true do 
		local tmp = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.rolls#rollDis%d",i)));
		if tmp == nil then
			break;
		end;
		self.rollsDis.object[i] = tmp;
		self.rollsDis.speed[i] = 0;
		i=i+1;
	end;	
end;

function Rolls:delete()
end;

function Rolls:readStream(streamId, connection)
end;

function Rolls:writeStream(streamId, connection)
end;

function Rolls:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rolls:keyEvent(unicode, sym, modifier, isDown)
end;

function Rolls:update(dt)

end;


function Rolls:updateTick(dt)	

	if self:getIsActive() then

		if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then

			for i, j in pairs(self.rollsDis.object) do
				local rX, rY, rZ = getRotation(j);
				self.rollsDis.speed[i] = self.rollsDis.speed[i] + 0.005 + math.random()/200;
				self.rollsDis.speed[i] = math.min(self.rollsDis.speed[i], 0.3);
				if i==2 then
					rX = rX - self.rollsDis.speed[i];
				else
					rX = rX + self.rollsDis.speed[i];
				end;
				setRotation(j, rX, rY, rZ);
			end;
		end;
		
		if self.tipState == Trailer.TIPSTATE_CLOSING then
			for i, j in pairs(self.rollsDis.object) do
				local rX, rY, rZ = getRotation(j);
				self.rollsDis.speed[i] = self.rollsDis.speed[i] - 0.005 - math.random()/200;
				self.rollsDis.speed[i] = math.max(self.rollsDis.speed[i], 0.0);
				if i==2 then
					rX = rX + self.rollsDis.speed[i];
				else
					rX = rX - self.rollsDis.speed[i];
				end;
				setRotation(j, rX, rY, rZ);
			end;
		end;
	end;
	
end;

function Rolls:draw()		
end;

function Rolls:onAttach(attacherVehicle)
end;

function Rolls:onDetach()
end;

function Rolls:onLeave()
end;

function Rolls:onDeactivate()
end;

function Rolls:onDeactivateSounds()
end;

function Rolls:onStartTip(currentTipTrigger, noEventSend)
end;

function Rolls:onEndTip(noEventSend)
end;
