bossini_SG200DU = {};

function bossini_SG200DU.prerequisitesPresent(specializations) return true; end;

function bossini_SG200DU:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
	self.axle3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index3")); end;

function bossini_SG200DU:delete() end;

function bossini_SG200DU:mouseEvent(posX, posY, isDown, isUp, button) end;

function bossini_SG200DU:keyEvent(unicode, sym, modifier, isDown) end;

function bossini_SG200DU:update(dt)	
	if self:getIsActive() then
		xr1,_,_ = getRotation(self.axle1); xr2,_,_ = getRotation(self.axle2); xr3,_,_ = getRotation(self.axle3);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].driveNode);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].driveNode);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].driveNode);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].driveNode);
		xrw5,yrw5,zrw5 = getRotation(self.wheels[5].driveNode);
		xrw6,yrw6,zrw6 = getRotation(self.wheels[6].driveNode);
		self.newRot1 = zrw1 - xr1; self.newRot2 = zrw3 - xr2; self.newRot3 = zrw5 - xr3;
		setRotation(self.wheels[1].driveNode, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].driveNode, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].driveNode, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].driveNode, xrw4,yrw4,self.newRot2)
		setRotation(self.wheels[5].driveNode, xrw5,yrw5,self.newRot3)
		setRotation(self.wheels[6].driveNode, xrw6,yrw6,self.newRot3) end; end;

function bossini_SG200DU:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) return BaseMission.VEHICLE_LOAD_OK; end;

function bossini_SG200DU:getSaveAttributesAndNodes(nodeIdent) end;

function bossini_SG200DU:updateTick(dt) end;

function bossini_SG200DU:draw() end;

function bossini_SG200DU:onAttach(attacherVehicle, jointDescIndex) end;
		
function bossini_SG200DU:onDetach()	end;

function bossini_SG200DU:onDeactivate() end;