-- Specjalizacja dla Bizon ZO56 --
-- Autor: Rockstar94 --
-- 24.01.2015 (v1.2 ** 18.02.2015)--



ZO56 = {};

function ZO56.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ZO56:load(xmlFile)
	self.sieczkarniaParticleSystems = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.sieczkarniaParticleSystems.sieczkarniaParticleSystem(%d)", i);

		local particleSystem = {};
		particleSystem.ps = {};
		local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, self.components, false, nil, self.baseDirectory)
		if ps == nil then
			break;
		end;
		table.insert(self.sieczkarniaParticleSystems, particleSystem);
		i = i+1;
	end;
	
	self.hederParticleSystems = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.hederParticleSystems.hederParticleSystem(%d)", i);

		local particleSystem = {};
		particleSystem.ps = {};
		local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, self.components, false, nil, self.baseDirectory)
		if ps == nil then
			break;
		end;
		table.insert(self.hederParticleSystems, particleSystem);
		i = i+1;
	end;
	
	self.gazParticleSystems = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.gazParticleSystems.gazParticleSystem(%d)", i);

		local particleSystem = {};
		particleSystem.ps = {};
		local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, self.components, false, nil, self.baseDirectory)
		if ps == nil then
			break;
		end;
		table.insert(self.gazParticleSystems, particleSystem);
		i = i+1;
	end;

	self.lancuch = {};
	
    local i = 0;
	
    while true do
        local key = string.format("vehicle.lancuch.lancuch(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node ~= nil then
            table.insert(self.lancuch, {node=node});
        end;
	    i = i +1;
    end;

	self.lancuch1 = {};
	
    local i = 0;
	
    while true do
        local key = string.format("vehicle.lancuch1.lancuch1(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node1 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node1 ~= nil then
            table.insert(self.lancuch1, {node1=node1});
        end;
	    i = i +1;
    end;

	self.lancuch2 = {};
	
    local i = 0;
	
    while true do
        local key = string.format("vehicle.lancuch2.lancuch2(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node2 ~= nil then
            table.insert(self.lancuch2, {node2=node2});
        end;
	    i = i +1;
    end;

	self.lancuch3 = {};
	
    local i = 0;
	
    while true do
        local key = string.format("vehicle.lancuch3.lancuch3(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node3 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node3 ~= nil then
            table.insert(self.lancuch3, {node3=node3});
        end;
	    i = i +1;
    end;
	
	self.lancuch4 = {};
	
    local i = 0;
	
    while true do
        local key = string.format("vehicle.lancuch4.lancuch4(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node4 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node4 ~= nil then
            table.insert(self.lancuch4, {node4=node4});
        end;
	    i = i +1;
    end;
	
	local klapa_lewa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_lewa#index"));
	if klapa_lewa ~= nil then
		self.klapa_lewa = klapa_lewa;
	end;
	
	local klapa_prawa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_prawa#index"));
	if klapa_prawa ~= nil then
		self.klapa_prawa = klapa_prawa;
	end;	
	
	local klapa_silnik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_silnik#index"));
	if klapa_silnik ~= nil then
		self.klapa_silnik = klapa_silnik;
	end;	
	
	local klapa_zbiornik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_zbiornik#index"));
	if klapa_zbiornik ~= nil then
		self.klapa_zbiornik = klapa_zbiornik;
	end;
	
	local rura = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rura#index"));
	if rura ~= nil then
		self.rura = rura;
	end;
	
	--[[local drzwi_lewe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi_lewe#index"));
	if drzwi_lewe ~= nil then
		self.drzwi_lewe = drzwi_lewe;
	end;]]
	
	local sieczkarnia = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.sieczkarnia#index"));
	if sieczkarnia ~= nil then
		self.sieczkarnia = sieczkarnia;
	end;
	
	local swiatlo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.swiatlo#index"));
	if swiatlo ~= nil then
		self.swiatlo = swiatlo;
	end;
	
	self.ropePanelAnimation = getXMLString(xmlFile, "vehicle.ropePanel#animationName");
	self.setRopePanel = SpecializationUtil.callSpecializationsFunction("setRopePanel");
	
	--[[openSoundFile = Utils.getFilename("Dzwieki/otworzdrzwi.wav", self.baseDirectory);
	self.openSoundId = createSample("Sample");
	loadSample(self.openSoundId, openSoundFile, false);
	self.openPlaying = false;	
	
	clouseSoundFile = Utils.getFilename("Dzwieki/zamknijdrzwi.wav", self.baseDirectory);
	self.clouseSoundId = createSample("Sample");
	loadSample(self.clouseSoundId, clouseSoundFile, false);
	self.clousePlaying = false;
	
	wycieraczkaSoundFile = Utils.getFilename("Dzwieki/wycieraczka.wav", self.baseDirectory);
    self.wycieraczkaSoundId = createSample("LizardHor12nSound");
    loadSample(self.wycieraczkaSoundId, wycieraczkaSoundFile, false);
    self.wycieraczkaPlaying = false;]]
	
	hydraulikaSoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulikaSoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulikaSoundId, hydraulikaSoundFile, false);
    self.hydraulikaPlaying = false;

	hydraulika1SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika1SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika1SoundId, hydraulika1SoundFile, false);
    self.hydraulika1Playing = false;
	
	hydraulika2SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika2SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika2SoundId, hydraulika2SoundFile, false);
    self.hydraulika2Playing = false;
	
	hydraulika3SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika3SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika3SoundId, hydraulika3SoundFile, false);
    self.hydraulika3Playing = false;
	
	open1SoundFile = Utils.getFilename("Dzwieki/bieg.wav", self.baseDirectory);
	self.open1SoundId = createSample("Sample");
	loadSample(self.open1SoundId, open1SoundFile, false);
	self.open1Playing = false;	
	
	open2SoundFile = Utils.getFilename("Dzwieki/bieg.wav", self.baseDirectory);
	self.open2SoundId = createSample("Sample");
	loadSample(self.open2SoundId, open2SoundFile, false);
	self.open2Playing = false;	
	
	open3SoundFile = Utils.getFilename("Dzwieki/bieg.wav", self.baseDirectory);
	self.open3SoundId = createSample("Sample");
	loadSample(self.open3SoundId, open3SoundFile, false);
	self.open3Playing = false;	
	
	mlocSoundFile = Utils.getFilename("Dzwieki/leylandmlocarnia.wav", self.baseDirectory);
    self.mlocSoundId = createSample("LizardHor12nSound");
    loadSample(self.mlocSoundId, mlocSoundFile, false);
    self.mlocPlaying = false;
	
	mlocsSoundFile = Utils.getFilename("Dzwieki/leylandmlocarnia_start.wav", self.baseDirectory);
	self.mlocsSoundId = createSample("Sample");
	loadSample(self.mlocsSoundId, mlocsSoundFile, false);
	self.mlocsPlaying = false;	
	
	sypanieSoundFile = Utils.getFilename("Dzwieki/sypanie.wav", self.baseDirectory);
    self.sypanieSoundId = createSample("LizardHor12nSound");
    loadSample(self.sypanieSoundId, sypanieSoundFile, false);
    self.sypaniePlaying = false;
	
	hydraulika4SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika4SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika4SoundId, hydraulika4SoundFile, false);
    self.hydraulika4Playing = false;

	hydraulika5SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika5SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika5SoundId, hydraulika5SoundFile, false);
    self.hydraulika5Playing = false;

	hydraulika6SoundFile = Utils.getFilename("Dzwieki/skret.wav", self.baseDirectory);
    self.hydraulika6SoundId = createSample("LizardHor12nSound");
    loadSample(self.hydraulika6SoundId, hydraulika6SoundFile, false);
    self.hydraulika6Playing = false;
	
	zzzSoundFile = Utils.getFilename("Dzwieki/mlocarnia.wav", self.baseDirectory);
    self.zzzSoundId = createSample("LizardHor12nSound");
    loadSample(self.zzzSoundId, zzzSoundFile, false);
    self.zzzPlaying = false;

	mlocarnia_stopSoundFile = Utils.getFilename("Dzwieki/gaz/gaz_stop.wav", self.baseDirectory);
    self.mlocarnia_stopSoundId = createSample("LizardHor12nSound");
    loadSample(self.mlocarnia_stopSoundId, mlocarnia_stopSoundFile, false);
    self.mlocarnia_stopPlaying = false;

	mlocarnia_startSoundFile = Utils.getFilename("Dzwieki/gaz/gaz_start.wav", self.baseDirectory);
    self.mlocarnia_startSoundId = createSample("LizardHor12nSound");
    loadSample(self.mlocarnia_startSoundId, mlocarnia_startSoundFile, false);
    self.mlocarnia_startPlaying = false;
	
	--[[self.swiatlo_vis = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.swiatlo2#index"));
	self.swiatlo2 = true;
	setVisibility(self.swiatlo_vis, not self.swiatlo2);]]
end;

function ZO56:delete()
	for k, v in pairs(self.gazParticleSystems) do
		Utils.deleteParticleSystem(v.ps)
	end;
  
	for k, v in pairs(self.sieczkarniaParticleSystems) do
		Utils.deleteParticleSystem(v.ps)
	end;
	
	for k, v in pairs(self.hederParticleSystems) do
		Utils.deleteParticleSystem(v.ps)
	end;
	
	if self.mlocPlaying ~= nil then
		delete(self.mlocSoundId)
	end;
	
	if self.zzzPlaying ~= nil then
		delete(self.zzzSoundId)
	end;	
end;

function ZO56:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ZO56:keyEvent(unicode, sym, modifier, isDown)
	--[[if isDown and sym == Input.KEY_f6 then
		self.wentylator = not self.wentylator;
	end;]]
	
	--[[if isDown and sym == Input.KEY_f7 then
		self.wycieraczka = not self.wycieraczka;
	end;]]
	
	if isDown and sym == Input.KEY_x then
		self.mlocarnia = not self.mlocarnia;
	end;
	
	--[[if isDown and sym == Input.KEY_f3 then
		self.swiatlo2 = not self.swiatlo2;
	end;]]
end;

function ZO56:update(dt)
	if self:getIsActive() then
		if self.animationParts[25].clipEndTime and self.mlocarnia then
			for k,v in ipairs(self.gazParticleSystems) do
				Utils.setEmittingState(v.ps, true);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if not self.animationParts[25].clipEndTime or not self.mlocarnia then
			for k,v in ipairs(self.gazParticleSystems) do
				Utils.setEmittingState(v.ps, false);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if self.mlocarnia then
			for k,v in ipairs(self.sieczkarniaParticleSystems) do
				Utils.setEmittingState(v.ps, true);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if not self.mlocarnia then
			for k,v in ipairs(self.sieczkarniaParticleSystems) do
				Utils.setEmittingState(v.ps, false);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if self.isTurnedOn then
			for k,v in ipairs(self.hederParticleSystems) do
				Utils.setEmittingState(v.ps, true);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if not self.isTurnedOn then
			for k,v in ipairs(self.hederParticleSystems) do
				Utils.setEmittingState(v.ps, false);
			end;
		end;
	end;

	if not self.isEntered then
		for k,v in ipairs(self.hederParticleSystems) do
			Utils.setEmittingState(v.ps, false);
		end;	
		
		for k,v in ipairs(self.sieczkarniaParticleSystems) do
			Utils.setEmittingState(v.ps, false);
		end;	
		
		for k,v in ipairs(self.gazParticleSystems) do
			Utils.setEmittingState(v.ps, false);
		end;	
	end;
	
	if self.mlocarnia then
		for _, part in pairs(self.lancuch) do
			setShaderParameter(part.node, "uvScrollSpeed", 0, 1, 0, 0, false);
		end;
	end;
	
	if not self.mlocarnia or not self.isEntered then
		for _, part in pairs(self.lancuch) do
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;

	if self.animationParts[43].clipStartTime and self.mlocarnia then
		for _, part in pairs(self.lancuch1) do
			setShaderParameter(part.node1, "uvScrollSpeed", 0, -1, 0, 0, false);
		end;
	end;
	
	if not self.animationParts[43].clipStartTime or not self.mlocarnia or not self.isEntered then
		for _, part in pairs(self.lancuch1) do
			setShaderParameter(part.node1, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;
	
	if self.isMotorStarted then
		for _, part in pairs(self.lancuch2) do
			setShaderParameter(part.node2, "uvScrollSpeed", 0, 2, 0, 0, false);
		end;
	else
		for _, part in pairs(self.lancuch2) do
			setShaderParameter(part.node2, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;
	
	if self.mlocarnia then
		for _, part in pairs(self.lancuch3) do
			setShaderParameter(part.node3, "uvScrollSpeed", 0, -2, 0, 0, false);
		end;
	end;
	
	if not self.mlocarnia or not self.isEntered then
		for _, part in pairs(self.lancuch3) do
			setShaderParameter(part.node3, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;	
	
	if self.isTurnedOn then
		for _, part in pairs(self.lancuch4) do
			setShaderParameter(part.node4, "uvScrollSpeed", 0, -2, 0, 0, false);
		end;
	else
		for _, part in pairs(self.lancuch4) do
			setShaderParameter(part.node4, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;
		
	--[[if self.isEntered then
		setVisibility(self.swiatlo_vis, not self.swiatlo2);
	end;
	
	if self.isEntered then
		if self.swiatlo2 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("oswietlenie")), InputBinding.swiatlo2);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("oswietlenie_off")), InputBinding.swiatlo2);
		end;
	end;]]

	if not self.isEntered then
		if self.sound11 then
			if self.mlocPlaying then
				stopSample(self.mlocSoundId);
				self.mlocPlaying = false;
			end;
		end;
		if self.sound18 then
			if self.zzzPlaying then
				stopSample(self.zzzSoundId);
				self.zzzPlaying = false;
			end;
		end;
	   --[[ if self.sound3 then
			if self.wycieraczkaPlaying then
				stopSample(self.wycieraczkaSoundId);
				self.wycieraczkaPlaying = false;
			end;
		end;]]
		--[[if self.sound1 then
			if self.openPlaying then
			   stopSample(self.openSoundId);
			   self.openPlaying = false;
			end;   
		end;]]
		--[[if self.sound2 then
			if self.clousePlaying then
				stopSample(self.clouseSoundId);
				self.clousePlaying = false;
			end;    
		end;]]
		if self.sound4 then
			if self.hydraulikaPlaying then
				stopSample(self.hydraulikaSoundId);
				self.hydraulikaPlaying = false;
			end;
		end;
		if self.sound5 then
			if self.hydraulika1Playing then
				stopSample(self.hydraulika1SoundId);
				self.hydraulika1Playing = false;
			end;
		end;
		if self.sound6 then
			if self.hydraulika2Playing then
				stopSample(self.hydraulika2SoundId);
				self.hydraulika2Playing = false;
			end;
		end;
		if self.sound7 then
			if self.hydraulika3Playing then
				stopSample(self.hydraulika3SoundId);
				self.hydraulika3Playing = false;
			end;
		end;
		if self.sound8 then
			if self.open1Playing then
			   stopSample(self.open1SoundId);
			   self.open1Playing = false;
			end;        
		end;	
		if self.sound9 then
			if self.open2Playing then
			   stopSample(self.open2SoundId);
			   self.open2Playing = false;
			end;        
		end;	
		if self.sound10 then
			if self.open3Playing then
				stopSample(self.open3SoundId);
				self.open3Playing = false;
			end;        
		end;	
	    if self.sound13 then
			if self.sypaniePlaying then
				stopSample(self.sypanieSoundId);
				self.sypaniePlaying = false;
			end;
		end;
	    if self.sound16 then
			if self.hydraulika6Playing then
				stopSample(self.hydraulika6SoundId);
				self.hydraulika6Playing = false;
			end;
		end;
	    if self.sound15 then
			if self.hydraulika5Playing then
				stopSample(self.hydraulika5SoundId);
				self.hydraulika5Playing = false;
			end;
		end;
	    if self.sound14 then
			if self.hydraulika4Playing then
				stopSample(self.hydraulika4SoundId);
				self.hydraulika4Playing = false;
			end;
		end;
	end;
	
	if not self.isEntered then
		stopSample(self.mlocarnia_stopSoundId)
		stopSample(self.mlocarnia_startSoundId)
	end;

	if self.isEntered then
		if self.sound19 then
			if not self.mlocarnia_stopPlaying then
				playSample(self.mlocarnia_stopSoundId, 1, 0.8, 3);
				self.mlocarnia_stopPlaying = true;
			end;      
		else
			if self.mlocarnia_stopPlaying then
			   stopSample(self.mlocarnia_stopSoundId);
			   self.mlocarnia_stopPlaying = false;
			end;        
		end;
	end;
	
	if self.isEntered then
		if self.sound20 then
			if not self.mlocarnia_startPlaying then
				playSample(self.mlocarnia_startSoundId, 1, 0.5, 3);
				self.mlocarnia_startPlaying = true;
			end;      
		else
			if self.mlocarnia_startPlaying then
			   stopSample(self.mlocarnia_startSoundId);
			   self.mlocarnia_startPlaying = false;
			end;        
		end;
	end;
	
	if self.isEntered then
	    if self.sound11 then
		   if not self.mlocPlaying then
				playSample(self.mlocSoundId, 0, 0.6, 0);
				self.mlocPlaying = true;
			end;
		else
			if self.mlocPlaying then
				stopSample(self.mlocSoundId);
				self.mlocPlaying = false;
			end;
		end;
	end;

	if self.isEntered then
	    if self.sound18 then
		   if not self.zzzPlaying then
				playSample(self.zzzSoundId, 0, 10, 0);
				self.zzzPlaying = true;
			end;
		else
			if self.zzzPlaying then
				stopSample(self.zzzSoundId);
				self.zzzPlaying = false;
			end;
		end;
	end;
	
	if self.isEntered then
	    if self.sound16 then
		   if not self.hydraulika6Playing then
				playSample(self.hydraulika6SoundId, 0, 1, 0);
				self.hydraulika6Playing = true;
			end;
		else
			if self.hydraulika6Playing then
				stopSample(self.hydraulika6SoundId);
				self.hydraulika6Playing = false;
			end;
		end;
	end;
	
	if self.isEntered then
	    if self.sound15 then
		   if not self.hydraulika5Playing then
				playSample(self.hydraulika5SoundId, 0, 1, 0);
				self.hydraulika5Playing = true;
			end;
		else
			if self.hydraulika5Playing then
				stopSample(self.hydraulika5SoundId);
				self.hydraulika5Playing = false;
			end;
		end;
	end;
	
	if self.isEntered then
	    if self.sound14 then
		   if not self.hydraulika4Playing then
				playSample(self.hydraulika4SoundId, 0, 1, 0);
				self.hydraulika4Playing = true;
			end;
		else
			if self.hydraulika4Playing then
				stopSample(self.hydraulika4SoundId);
				self.hydraulika4Playing = false;
			end;
		end;
	end;

	if self.isEntered then
	    if self.sound13 then
		   if not self.sypaniePlaying then
				playSample(self.sypanieSoundId, 0, 1, 0);
				self.sypaniePlaying = true;
			end;
		else
			if self.sypaniePlaying then
				stopSample(self.sypanieSoundId);
				self.sypaniePlaying = false;
			end;
		end;
	end;

	if self.sound10 then
		if not self.open3Playing then
			playSample(self.open3SoundId, 1, 3, 3);
			self.open3Playing = true;
		end;      
    else
		if self.open3Playing then
		   stopSample(self.open3SoundId);
		   self.open3Playing = false;
		end;        
    end;	
	
	if self.sound9 then
		if not self.open2Playing then
			playSample(self.open2SoundId, 1, 3, 3);
			self.open2Playing = true;
		end;      
    else
		if self.open2Playing then
		   stopSample(self.open2SoundId);
		   self.open2Playing = false;
		end;        
    end;	
	
	if self.sound8 then
		if not self.open1Playing then
			playSample(self.open1SoundId, 1, 3, 3);
			self.open1Playing = true;
		end;      
    else
		if self.open1Playing then
		   stopSample(self.open1SoundId);
		   self.open1Playing = false;
		end;        
    end;	
	
	if self.isEntered then
	    if self.sound7 then
		   if not self.hydraulika3Playing then
				playSample(self.hydraulika3SoundId, 0, 1, 0);
				self.hydraulika3Playing = true;
			end;
		else
			if self.hydraulika3Playing then
				stopSample(self.hydraulika3SoundId);
				self.hydraulika3Playing = false;
			end;
		end;
	end;

	if self.isEntered then
	    if self.sound6 then
		   if not self.hydraulika2Playing then
				playSample(self.hydraulika2SoundId, 0, 1, 0);
				self.hydraulika2Playing = true;
			end;
		else
			if self.hydraulika2Playing then
				stopSample(self.hydraulika2SoundId);
				self.hydraulika2Playing = false;
			end;
		end;
	end;

	if self.isEntered then
	    if self.sound5 then
		   if not self.hydraulika1Playing then
				playSample(self.hydraulika1SoundId, 0, 1, 0);
				self.hydraulika1Playing = true;
			end;
		else
			if self.hydraulika1Playing then
				stopSample(self.hydraulika1SoundId);
				self.hydraulika1Playing = false;
			end;
		end;
	end;

	if self.isEntered then
	    if self.sound4 then
		   if not self.hydraulikaPlaying then
				playSample(self.hydraulikaSoundId, 0, 1, 0);
				self.hydraulikaPlaying = true;
			end;
		else
			if self.hydraulikaPlaying then
				stopSample(self.hydraulikaSoundId);
				self.hydraulikaPlaying = false;
			end;
		end;
	end;

	--[[if self.isEntered then
	    if self.sound3 then
		   if not self.wycieraczkaPlaying then
				playSample(self.wycieraczkaSoundId, 0, 1, 0);
				self.wycieraczkaPlaying = true;
			end;
		else
			if self.wycieraczkaPlaying then
				stopSample(self.wycieraczkaSoundId);
				self.wycieraczkaPlaying = false;
			end;
		end;
	end;]]

	--[[if self.sound1 then
		if not self.openPlaying then
			playSample(self.openSoundId, 1, 3, 3);
			self.openPlaying = true;
		end;      
    else
		if self.openPlaying then
		   stopSample(self.openSoundId);
		   self.openPlaying = false;
		end;        
    end;]]	
	
	--[[if self.sound2 then
		if not self.clousePlaying then
			playSample(self.clouseSoundId, 1, 3, 3);
			self.clousePlaying = true;
		end;       
	else
		if self.clousePlaying then
			stopSample(self.clouseSoundId);
			self.clousePlaying = false;
		end;        
    end;]]

	if self.isMotorStarted then
        self:setAnimationTime(1, 1);
    else
        self:setAnimationTime(1, 0);
    end;
	
	local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.swiatlo);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_swiatlo = true;
		else
			self.przy_swiatlo = false;
		end;
		
    if self.przy_swiatlo then
		if InputBinding.hasEvent(InputBinding.skladanie) then
			if self.animationParts[48].clipEndTime then
				self:setAnimationTime(48, self.animationParts[48].offSet);
			elseif self.animationParts[48].clipStartTime  then
				self:setAnimationTime(48, self.animationParts[48].animDuration);			
			end;
		end;
    end;
	
	if self.przy_swiatlo then
		if self.animationParts[48].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_otw")), InputBinding.skladanie);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_zam")), InputBinding.skladanie);
		end;
	end;

    if self.przy_sieczkarnia then
		if InputBinding.hasEvent(InputBinding.klapa_silnik) then
			if self.animationParts[57].clipEndTime then
				self:setAnimationTime(57, self.animationParts[57].offSet);
			elseif self.animationParts[57].clipStartTime  then
				self:setAnimationTime(57, self.animationParts[57].animDuration);			
			end;
		end;
    end;

	if self.przy_sieczkarnia then
		if InputBinding.hasEvent(InputBinding.skladanie1) then
			if self.animationParts[52].clipEndTime then
				self:setAnimationTime(52, self.animationParts[52].offSet);
			elseif self.animationParts[52].clipStartTime  then
				self:setAnimationTime(52, self.animationParts[52].animDuration);	
			end;
		end;
    end;
	
	if self.przy_sieczkarnia then
		if self.animationParts[47].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_otw")), InputBinding.skladanie);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_zam")), InputBinding.skladanie);
		end;
	end;

	if self.przy_sieczkarnia then
		if self.animationParts[52].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_otw1")), InputBinding.skladanie1);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_zam1")), InputBinding.skladanie1);
		end;
	end;
	
	if self.przy_sieczkarnia then
		if self.animationParts[57].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_otw1")), InputBinding.klapa_silnik);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("skladanie_zam1")), InputBinding.klapa_silnik);
		end;
	end;
	
    if self.przy_sieczkarnia then
		if InputBinding.hasEvent(InputBinding.skladanie) then
			if self.animationParts[47].clipEndTime then
				self:setAnimationTime(47, self.animationParts[47].offSet);
			elseif self.animationParts[47].clipStartTime  then
				self:setAnimationTime(47, self.animationParts[47].animDuration);	
			end;
		end;
    end;
	
	local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.sieczkarnia);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_sieczkarnia = true;
		else
			self.przy_sieczkarnia = false;
		end;
	
    if self.przy_sieczkarnia then
		if InputBinding.hasEvent(InputBinding.mlocarnia) then
			if self.animationParts[43].clipEndTime then
				self:setAnimationTime(43, self.animationParts[43].offSet);
				elseif self.animationParts[43].clipStartTime  then
				self:setAnimationTime(43, self.animationParts[43].animDuration);
			end;
			if self.animationParts[50].clipEndTime then
				self:setAnimationTime(50, self.animationParts[50].offSet);
			elseif self.animationParts[50].clipStartTime  then
				self:setAnimationTime(50, self.animationParts[50].animDuration);	
			end;
		end;
    end;
	
	if self.animationParts[43].clipEndTime then
		self.isStrawEnabled = true;
	end;
	
	if self.animationParts[43].clipStartTime then
		self.isStrawEnabled = false;
	end;
	
	if self.przy_sieczkarnia then
		if self.animationParts[43].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sieczkarnia_otw")), InputBinding.mlocarnia);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sieczkarnia_zam")), InputBinding.mlocarnia);
		end;
	end;
	
	if self.animationParts[43].clipStartTime then
		if self.mlocarnia then
			self:setAnimationTime(44, 1);
			self:setAnimationTime(45, 1);
		else 
			self:setAnimationTime(44, 0);
			self:setAnimationTime(45, 0);
		end;
	end;

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_lewa);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_lewa = true;
		else
			self.przy_klapa_lewa = false;
		end;
		
    if self.przy_klapa_lewa then
		if InputBinding.hasEvent(InputBinding.klapa_lewa) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime  then
				self:setAnimationTime(2, self.animationParts[2].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_lewa then
		if self.animationParts[2].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_lewa_otw")), InputBinding.klapa_lewa);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_lewa_zam")), InputBinding.klapa_lewa);
		end;
	end;

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_prawa);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_prawa = true;
		else
			self.przy_klapa_prawa = false;
		end;
		
    if self.przy_klapa_prawa then
		if InputBinding.hasEvent(InputBinding.klapa_lewa) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime  then
				self:setAnimationTime(3, self.animationParts[3].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_prawa then
		if self.animationParts[3].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_lewa_otw")), InputBinding.klapa_lewa);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_lewa_zam")), InputBinding.klapa_lewa);
		end;
	end;

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_prawa);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_prawa = true;
		else
			self.przy_klapa_prawa = false;
		end;
		
    if self.przy_klapa_prawa then
		if InputBinding.hasEvent(InputBinding.klapa_chlodnica) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime  then
				self:setAnimationTime(4, self.animationParts[4].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_prawa then
		if self.animationParts[4].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_chlodnica")), InputBinding.klapa_chlodnica);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_chlodnica_zam")), InputBinding.klapa_chlodnica);
		end;
	end;

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_silnik);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_silnik = true;
		else
			self.przy_klapa_silnik = false;
		end;
		
    if self.przy_klapa_silnik then
		if InputBinding.hasEvent(InputBinding.klapa_silnik) then
			if self.animationParts[5].clipEndTime then
				self:setAnimationTime(5, self.animationParts[5].offSet);
			elseif self.animationParts[5].clipStartTime  then
				self:setAnimationTime(5, self.animationParts[5].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_silnik then
		if self.animationParts[5].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_silnik")), InputBinding.klapa_silnik);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_silnik_zam")), InputBinding.klapa_silnik);
		end;
	end;

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_silnik);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_silnik = true;
		else
			self.przy_klapa_silnik = false;
		end;
		
    if self.przy_klapa_silnik then
		if InputBinding.hasEvent(InputBinding.klapa_klawisze) then
			if self.animationParts[6].clipEndTime then
				self:setAnimationTime(6, self.animationParts[6].offSet);
			elseif self.animationParts[6].clipStartTime  then
				self:setAnimationTime(6, self.animationParts[6].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_silnik then
		if self.animationParts[6].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_klawisze")), InputBinding.klapa_klawisze);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_klawisze_zam")), InputBinding.klapa_klawisze);
		end;
	end;	

    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_zbiornik);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_zbiornik = true;
		else
			self.przy_klapa_zbiornik = false;
		end;
		
    if self.przy_klapa_zbiornik then
		if InputBinding.hasEvent(InputBinding.klapa_zbiornik) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].offSet);
			elseif self.animationParts[7].clipStartTime  then
				self:setAnimationTime(7, self.animationParts[7].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_zbiornik then
		if self.animationParts[7].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_zbiornik")), InputBinding.klapa_zbiornik);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klapa_zbiornik_zam")), InputBinding.klapa_zbiornik);
		end;
	end;	
	
    local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.rura);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_rura = true;
		else
			self.przy_rura = false;
		end;
		
    if self.przy_rura then
		if InputBinding.hasEvent(InputBinding.rura) then
			if self.animationParts[8].clipEndTime then
				self:setAnimationTime(8, self.animationParts[8].offSet);
			elseif self.animationParts[8].clipStartTime  then
				self:setAnimationTime(8, self.animationParts[8].animDuration);	
			end;
		end;
    end;
	
	if self.przy_rura then
		if self.animationParts[8].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rura")), InputBinding.rura);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rura_zam")), InputBinding.rura);
		end;
	end;	
	
	if self.isEntered then
		if self.animationParts[8].clipStartTime and Input.isKeyPressed(Input.KEY_o) then
			g_currentMission:addWarning(g_i18n:getText("info3"), 0.07+0.022, 0.019+0.029);
		end;
	end;
	
	if self.isEntered then
		if self.animationParts[8].clipStartTime then
			self.currentPipeState = 1;
			self.targetPipeState = 1;
		end;
	end;
	
	if self.isEntered then
		if self.targetPipeState == 1 then
			self.sound13 = false;
		else
			self.sound13 = true;
		end;
	end;
	
	--[[if self.isEntered then
		if self.wentylator then
			self:setAnimationTime(12, 1);
		else
			self:setAnimationTime(12, 0);
		end;
	end;
	
	if self.isEntered then
		if self.wentylator then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wentylator_stop")), InputBinding.wentylator);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wentylator")), InputBinding.wentylator);
		end;
	end;]]
	
	--[[if self.isEntered then
		if self.wycieraczka then
			self:setAnimationTime(13, 1);
			self.sound3 = true;
		else
			self:setAnimationTime(13, 0);
			self.sound3 = false;
		end;
	end;
	
	if self.isEntered then
		if self.wycieraczka then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wycieraczka_stop")), InputBinding.wycieraczka);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wycieraczka")), InputBinding.wycieraczka);
		end;
	end;]]
	
   --[[ local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.drzwi_lewe);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_drzwi_lewe = true;
		else
			self.przy_drzwi_lewe = false;
		end;
		
    if self.przy_drzwi_lewe or self.isEntered then
		if InputBinding.hasEvent(InputBinding.drzwi_lewe) then
			if self.animationParts[9].clipEndTime then
				self:setAnimationTime(9, self.animationParts[9].offSet);
				self.sound1 = true;
				self.sound2 = false;
			elseif self.animationParts[9].clipStartTime  then
				self:setAnimationTime(9, self.animationParts[9].animDuration);	
				self.sound1 = false;
				self.sound2 = true;
			end;
		end;
    end;

	if self.przy_drzwi_lewe or self.isEntered then
		if self.animationParts[9].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("drzwi_lewe")), InputBinding.drzwi_lewe);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("drzwi_lewe_zam")), InputBinding.drzwi_lewe);
		end;
	end;]]
	
    --[[if self.isEntered then
		if InputBinding.hasEvent(InputBinding.tylna) then
			if self.animationParts[11].clipEndTime then
				self:setAnimationTime(11, self.animationParts[11].offSet);
			elseif self.animationParts[11].clipStartTime  then
				self:setAnimationTime(11, self.animationParts[11].animDuration);	
			end;
		end;
    end;
	
	if self.isEntered then
		if self.animationParts[11].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("tylna")), InputBinding.tylna);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("tylna_zam")), InputBinding.tylna);
		end;
	end;	]]
	
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.camera) then
			if self.animationParts[46].clipEndTime then
				self:setAnimationTime(46, self.animationParts[46].offSet);
			elseif self.animationParts[46].clipStartTime  then
				self:setAnimationTime(46, self.animationParts[46].animDuration);	
			end;
		end;
    end;
	

    --[[if self.isEntered then
		if InputBinding.hasEvent(InputBinding.boczna) then
			if self.animationParts[10].clipEndTime then
				self:setAnimationTime(10, self.animationParts[10].offSet);
			elseif self.animationParts[10].clipStartTime  then
				self:setAnimationTime(10, self.animationParts[10].animDuration);	
			end;
		end;
    end;
	
	if self.isEntered then
		if self.animationParts[10].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("boczna")), InputBinding.boczna);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("boczna_zam")), InputBinding.boczna);
		end;
	end;	]]

	if self.isEntered then
		g_currentMission:addExtraPrintText(g_i18n:getText("gardziel"));
	end;
	
	if self.isEntered then
		if InputBinding.isPressed(InputBinding.gardziel_gora) then
			self:setAnimationTime(28,self.animationParts[28].animDuration);
		else 
			self:setAnimationTime(28,self.animationParts[28].offSet);
		end;
	end;

	if self.isEntered then
		if InputBinding.isPressed(InputBinding.gardziel_dol) then
			self:setAnimationTime(27,self.animationParts[27].animDuration);
			self.sound7 = true;
		else 
			self:setAnimationTime(27,self.animationParts[27].offSet);
			self.sound7 = false;
		end;
	end;

    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.klepisko) then
			if self.animationParts[24].clipEndTime then
				self:setAnimationTime(24, self.animationParts[24].offSet);
			elseif self.animationParts[24].clipStartTime  then
				self:setAnimationTime(24, self.animationParts[24].animDuration);	
			end;
		end;
    end;
	
	if self.isEntered then
		if self.animationParts[24].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klepisko")), InputBinding.klepisko);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("klepisko_zam")), InputBinding.klepisko);
		end;
	end;	

    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.gaz) then
			if self.animationParts[25].clipStartTime then
				self:setAnimationTime(25, self.animationParts[25].animDuration);
				self.sound20 = true;
				self.sound19 = false;
			elseif self.animationParts[25].clipEndTime  then
				self:setAnimationTime(25, self.animationParts[25].offSet);	
				self.sound20 = false;
				self.sound19 = true;
			end;
		end;
    end;
	
	if self.animationParts[25].clipEndTime then
		self:setAnimationTime(55, 1) 
		self.sound11 = true;
	else
		self:setAnimationTime(55, 0)
		self.sound11 = false;
	end;

	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.gaz) then
			if self.animationParts[36].clipStartTime then
				self:setAnimationTime(36, self.animationParts[36].animDuration);
			elseif self.animationParts[36].clipEndTime  then
				self:setAnimationTime(36, self.animationParts[36].offSet);	
			end;
		end;
    end;
	
	if self.isEntered then
		if self.lastSpeed*3600 > 13 or self.mlocarnia then
			self:setAnimationTime(37, self.animationParts[37].animDuration)
		else
			self:setAnimationTime(37, self.animationParts[37].offSet)
		end;
	end;
	
	if self.isEntered then
		if self.animationParts[25].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("gaz")), InputBinding.gaz);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("gaz_zam")), InputBinding.gaz);
		end;
	end;	
	
	if self.animationParts[25].clipEndTime then
		if self.animationParts[15].clipSpeed < 3 then
			self.animationParts[15].clipSpeed = self.animationParts[15].clipSpeed+1;
		end;
	end;
	
	if self.animationParts[25].clipStartTime then
		if self.animationParts[15].clipSpeed > 1.5 then
			self.animationParts[15].clipSpeed = self.animationParts[15].clipSpeed-1;
		end;
	end;
	
	if self.isTurnedOn and self.animationParts[25].clipStartTime then
		g_currentMission:addWarning(g_i18n:getText("info2"), 0.07+0.022, 0.019+0.029);
	end;

	if self.isEntered then
		if self.animationParts[46].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("camera")), InputBinding.camera);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("camera_zam")), InputBinding.camera);
		end;
	end;

	if self.isMotorStarted then
		if self.mlocarnia then
			self:setAnimationTime(15, 1);
			self:setAnimationTime(22, 1);
			self:setAnimationTime(38, 1);
			self:setAnimationTime(39, 1);
			self:setAnimationTime(40, 1);
			self:setAnimationTime(41, 1);
			self:setAnimationTime(42, 1);
			self:setAnimationTime(49, 1);
			self:setAnimationTime(51, 1);
			self.sound18 = true;
		else
			self:setAnimationTime(15, 0);
			self:setAnimationTime(22, 0);
			self:setAnimationTime(38, 0);
			self:setAnimationTime(39, 0);
			self:setAnimationTime(40, 0);
			self:setAnimationTime(41, 0);
			self:setAnimationTime(42, 0);
			self:setAnimationTime(49, 0);
			self:setAnimationTime(51, 0);
			self.sound18 = false;
		end;
	end;
	
	if not self.isMotorStarted then
		self:setAnimationTime(15, 0);
		self:setAnimationTime(22, 0);
		self:setAnimationTime(38, 0);
		self:setAnimationTime(39, 0);
		self:setAnimationTime(40, 0);
		self:setAnimationTime(41, 0);
		self:setAnimationTime(42, 0);
		self:setAnimationTime(44, 0);
		self:setAnimationTime(45, 0);
		self:setAnimationTime(49, 0);
		self:setAnimationTime(51, 0);
		self:setAnimationTime(53, 0);
		self:setAnimationTime(54, 0);
		self.sound18 = false;
	end;
	
	if self.isMotorStarted then
		if self.mlocarnia and self.animationParts[36].clipEndTime then
			self:setAnimationTime(53, 1);
			self:setAnimationTime(54, 1);
			self:setAnimationTime(56, 1);
		end;
	end;
	
	if self.isMotorStarted then
		if not self.mlocarnia or not self.animationParts[36].clipEndTime then
			self:setAnimationTime(53, 0);
			self:setAnimationTime(54, 0);
			self:setAnimationTime(56, 0);
		end;
	end;
	
	if self.isEntered then
		if self.mlocarnia then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("mlocarnia_stop")), InputBinding.mlocarnia);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("mlocarnia")), InputBinding.mlocarnia);
		end;
	end;	
	
	if self.animationParts[25].clipEndTime then
		if self.animationParts[40].clipSpeed < 1.3 then
			self.animationParts[40].clipSpeed = self.animationParts[40].clipSpeed+1;
		end;
	end;
	
	if self.animationParts[25].clipStartTime then
		if self.animationParts[40].clipSpeed > 1 then
			self.animationParts[40].clipSpeed = self.animationParts[40].clipSpeed-1;
		end;
	end;

    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.mlocarnia) then
			if self.animationParts[16].clipEndTime then
				self:setAnimationTime(16, self.animationParts[16].offSet);
			elseif self.animationParts[16].clipStartTime  then
				self:setAnimationTime(16, self.animationParts[16].animDuration);	
			end;
		end;
    end;
	
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.mlocarnia) then
			if self.animationParts[35].clipEndTime then
				self:setAnimationTime(35, self.animationParts[35].offSet);
			elseif self.animationParts[35].clipStartTime  then
				self:setAnimationTime(35, self.animationParts[35].animDuration);	
			end;
		end;
    end;
	
	if self.animationParts[16].clipStartTime then
		self:stopThreshing(true);
		self.isTurnedOn = false;
	end;
	
	if self.isEntered then
		if self.animationParts[16].clipStartTime and Input.isKeyPressed(Input.KEY_b) then
			g_currentMission:addWarning(g_i18n:getText("info1"), 0.07+0.022, 0.019+0.029);
		end;
	end;

	if self.isEntered then
		if not self.brakeLightsVisibility then
			if self.animationParts[17].clipEndTime then
				self:setAnimationTime(17, self.animationParts[17].offSet);
			end;
		end;
		if self.brakeLightsVisibility then
			if self.animationParts[17].clipStartTime then
				self:setAnimationTime(17, self.animationParts[17].animDuration);	
			end;
		end;
	end;	

	if self.isEntered then
		if not self.brakeLightsVisibility and self.lastSpeed*3600 < 1 then
			if InputBinding.hasEvent(InputBinding.sprzeglo) or InputBinding.hasEvent(InputBinding.sprzeglo1) then
				self:setRopePanel(not self.ropePanel);
			end;
		end
	end;

	if self.isEntered then
		if not self.isTurnedOn then 
			if self.movingDirection > 0 then
				if Input.isKeyPressed(Input.KEY_w) or self.lastSpeed*3600 > 1 then
					self:setAnimationTime(19,self.animationParts[19].animDuration);
					self.sound10 = true;
				else 
					self:setAnimationTime(19,self.animationParts[19].offSet);
					self.sound10 = false;
				end;
			end;
		end;
	end;	
		
	if self.isEntered then
		if not self.brakeLightsVisibility then
			if self.movingDirection < 0 and Input.isKeyPressed(Input.KEY_s) then
				self:setAnimationTime(20,self.animationParts[20].animDuration);
				self.sound8 = true;
			else 
				self:setAnimationTime(20,self.animationParts[20].offSet);
				self.sound8 = false;
			end;
		end;
	end;	

	if self.isEntered then
		if self.isTurnedOn then
			if self.movingDirection > 0 then
				if not self.isHired then
					if Input.isKeyPressed(Input.KEY_w) or self.lastSpeed*3600 > 1 then
						self:setAnimationTime(18,self.animationParts[18].animDuration);
						self.sound9 = true;
					else 
						self:setAnimationTime(18,self.animationParts[18].offSet);
						self.sound9 = false;
					end;		
				end;
			end;
		end;
	end;	
	
	if self.isEntered and self.isTurnedOn then
		self:setAnimationTime(21, 1);
	end;
	
	if not self.isEntered or not self.isTurnedOn then
		self:setAnimationTime(21, 0);
	end;
	
    if self.isTurnedOn then
		self:setAnimationTime(23, self.animationParts[23].animDuration);
	end;
	
	if not self.isTurnedOn then
		self:setAnimationTime(23, self.animationParts[23].offSet);
	end;

	if self.isEntered then
		if self.currentPipeState ~= 1 then
			self:setAnimationTime(26, self.animationParts[26].animDuration);
		else
			self:setAnimationTime(26, self.animationParts[26].offSet);
		end;
	end;
		
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_8) then
			self:setAnimationTime(30,self.animationParts[30].animDuration);
			self.sound6 = true;
		else 
			self:setAnimationTime(30,self.animationParts[30].offSet);
			self.sound6 = false;
		end;
	end;

	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_5) then
			self:setAnimationTime(29,self.animationParts[29].animDuration);
			self.sound16 = true;
		else 
			self:setAnimationTime(29,self.animationParts[29].offSet);
			self.sound16 = false;
		end;
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_9) then
			self:setAnimationTime(31,self.animationParts[31].animDuration);
			self.sound5 = true;
		else 
			self:setAnimationTime(31,self.animationParts[31].offSet);
			self.sound5 = false;
		end;
	end;

	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_6) then
			self:setAnimationTime(32,self.animationParts[32].animDuration);
			self.sound15 = true;
		else 
			self:setAnimationTime(32,self.animationParts[32].offSet);
			self.sound15 = false;
		end;
	end;
	
	if self.isEntered then
		g_currentMission:addExtraPrintText(g_i18n:getText("moto3"));
	end;
	
	if self.isEntered then
		g_currentMission:addExtraPrintText(g_i18n:getText("moto1"));
	end;
	
	if self.isEntered then
		g_currentMission:addExtraPrintText(g_i18n:getText("moto2"));
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_7) then
			self:setAnimationTime(33,self.animationParts[33].animDuration);
			self.sound4 = true;
		else 
			self:setAnimationTime(33,self.animationParts[33].offSet);
			self.sound4 = false;
		end;
	end;

	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_KP_4) then
			self:setAnimationTime(34,self.animationParts[34].animDuration);
			self.sound14 = true;
		else 
			self:setAnimationTime(34,self.animationParts[34].offSet);
			self.sound14 = false;
		end;
	end;

	if self.isEntered then
		if self.currentPipeState ~= 1 then
			g_currentMission:addExtraPrintText(g_i18n:getText("info5"));
		end;
		if Input.isKeyPressed(Input.KEY_comma) then
			g_currentMission:addWarning(g_i18n:getText("info10"), 0.07+0.022, 0.019+0.029);
		end;
	end;
	
	if self.animationParts[25].clipEndTime then
		self.overloadingCapacity = 70
	else
		self.overloadingCapacity = 20
	end;
	
	--[[if self.isEntered then
		if self.animationParts[25].clipStartTime then
			if self.lastSpeed*3600 > 8 then
				self:setAnimationTime(58,self.animationParts[58].animDuration);
			else 
				self:setAnimationTime(58,self.animationParts[58].offSet);
			end;		
		end;
	end;]]
end;

function ZO56:setRopePanel(isRopePanel)
	if isRopePanel then
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, 1, nil, true);
			self.ropePanel = true;
		end;
	else
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, -1, nil, true);
			self.ropePanel = false;
		end;
	end;
end;

function ZO56:onLeave()
end;

function ZO56:onEnter()
end;

function ZO56:onDeactivate()
end;

function ZO56:draw()
end;