-- Lulu88520
-- Script pour la benne duchesne
-- Ls-Modteam-France
-- @date  14/09/2014
-- http://www.ls-modteam-france.com

if g_currentModName ~= "Benne_duchesne" then
	print("Error: Benne duchesne must not be renamed. It must be called Benne_duchesne.zip");
end;

duchesne = {};

function duchesne.prerequisitesPresent(specializations)
	  return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function duchesne:load(xmlFile)

	 self.toggleSupport = SpecializationUtil.callSpecializationsFunction("toggleSupport");  
    self.manualSupportAnimation = getXMLString(xmlFile, "vehicle.manualSupport#animationName");
    self.supportRangeIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manualSupport#rangeIndex"));
    self.isInRangeSupport = false;
    self.isSupportDown = true;	
	
end;

function duchesne:delete()
end;

function duchesne:readStream(streamId, connection)	
   local isSupportDown = streamReadBool(streamId);
	self:toggleSupport(isSupportDown, true); 	
end;

function duchesne:writeStream(streamId, connection)
streamWriteBool(streamId, self.isSupportDown);
      
end;

function duchesne:mouseEvent(posX, posY, isDown, isUp, button)
end;

function duchesne:keyEvent(unicode, sym, modifier, isDown) 
end;

function duchesne:update(dt)
         if self:getIsActive() then		
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- Show warning about the support being down
			if self.isSupportDown then
				g_currentMission:addWarning(string.format(g_i18n:getText("BJR_SUPPORT_WARNING")), 0.018, 0.033);
			end;
		end;
	end;
         if self.supportRangeIndex then
		-- Manage key events for inrange support --
		if self.isInRangeSupport then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.isSupportDown then
					self:toggleSupport(false);
				else
					self:toggleSupport(true);
				end;
			end;
			-- Display key when in range --
			if self.isSupportDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_RAISE_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_LOWER_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;    
	
	
	

end;

function duchesne:updateTick(dt)

 if self.supportRangeIndex then
		if g_currentMission.player ~= nil then
			-- Getting the distance between the player and the support
			local nearestDistance = 1.5; --max distance allowed
			local px, py, pz = getWorldTranslation(self.supportRangeIndex);
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				self.isInRangeSupport = true;
			else
				self.isInRangeSupport = false;
			end;
		end;
	else
		self.isInRangeSupport = false;
	end;   
end;

function duchesne:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isSupportDown = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isSupportDown"), false);
	self:toggleSupport(isSupportDown);	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function duchesne:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isSupportDown="' .. tostring(self.isSupportDown) .. '"';
    return attributes, nil;
end;
  
function duchesne:onDetach()
end;

function duchesne:onAttach()
end;

function duchesne:draw()
end;

function duchesne:toggleSupport(isSupportDown, noEventSend)
	ToggleSupportEvent.sendEvent(self, isSupportDown, noEventSend);	
	
	if not isSupportDown then
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, -1, nil, true);
		end;
	else
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, 1, nil, true);
		end;
	end;
	
	self.isSupportDown = isSupportDown;
end;


-- Support event

ToggleSupportEvent = {};
ToggleSupportEvent_mt = Class(ToggleSupportEvent, Event);

InitEventClass(ToggleSupportEvent, "ToggleSupportEvent");

function ToggleSupportEvent:emptyNew()
    local self = Event:new(ToggleSupportEvent_mt);
	self.className="ToggleSupportEvent";
    return self;
end;

function ToggleSupportEvent:new(object, isSupportDown)
    local self = ToggleSupportEvent:emptyNew()
    self.object = object;
	self.isSupportDown = isSupportDown;
    return self;
end;

function ToggleSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.isSupportDown = streamReadBool(streamId);
    self:run(connection);
end;

function ToggleSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.isSupportDown);
end;

function ToggleSupportEvent:run(connection)
	self.object:toggleSupport(self.isSupportDown, true);
	 if not connection:getIsServer() then
        g_server:broadcastEvent(ToggleSupportEvent:new(object, self.isSupportDown), nil, connection, self.object);
    end;
end;

function ToggleSupportEvent.sendEvent(object, isSupportDown, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleSupportEvent:new(object, isSupportDown), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(ToggleSupportEvent:new(object, isSupportDown));
		end;
	end;
end;


