--
-- BuyableTwinWheelsAttacher
-- Specialization for Buyable Twin Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--				v3.0 - Added dynamic collision support, ls13-ready
--
-- free for noncommerical-usage
--

BuyableTwinWheelsAttacher = {};

function BuyableTwinWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableTwinWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
    self.setDirtAmount = Utils.overwrittenFunction(self.setDirtAmount, BuyableTwinWheelsAttacher.setDirtAmount);
    self.getDriveGroundParticleSystemsScale = Utils.overwrittenFunction(self.getDriveGroundParticleSystemsScale, BuyableTwinWheelsAttacher.getDriveGroundParticleSystemsScale);
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableTwinWheels.twinWheels = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	
	
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.wheels.wheel(%d)", i);        
        local collisionStr = getXMLString(xmlFile, wheelnamei .. "#twinWheelCollisionIndex");
        if collisionStr == nil then
            break;
        end;
		local wheel = self.wheels[i+1];
        wheel.twinWheelCollisionNode = Utils.indexToObject(self.components, collisionStr);
        wheel.twinWheelPosition = Utils.getVectorNFromString(getXMLString(xmlFile, wheelnamei .. "#twinWheelPosition"), 3);
        wheel.twinWheelDefaultPosition = { getTranslation(wheel.twinWheelCollisionNode) };
        i = i+1;
    end;	
    
    for i,drivePS in pairs(self.driveGroundParticleSystems) do
        local key = string.format("vehicle.driveGroundParticleSystems.driveGroundParticleSystem(%d)", i-1);
        drivePS.isTwinWheelPS = Utils.getNoNil(getXMLBool(xmlFile, key.."#isTwinWheelPS"), false);
    end
end;

function BuyableTwinWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableTwinWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableTwinWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableTwinWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableTwinWheels;
		if wheels.wheelsInRange ~= nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_TWINWHEELS_ATTACH) then
					if wheels.twinWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:draw()
	local wheels = self.buyableTwinWheels;
	if wheels.wheelsInRange ~= nil then
		if wheels.twinWheels ~= nil then
			if wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:onAssembling(buyableTwinWheels)
	self.buyableTwinWheels.twinWheels = buyableTwinWheels;
end;

function BuyableTwinWheelsAttacher:onDisassembling()
	self.buyableTwinWheels.twinWheels = nil;
end;

function BuyableTwinWheelsAttacher:setDirtAmount(superFunc, dirtAmount, force)    
    if self.buyableTwinWheels.twinWheels ~= nil then
        local dirtDelta = dirtAmount - self.dirtAmount;
        self.buyableTwinWheels.twinWheels:setDirtAmount(self.buyableTwinWheels.twinWheels.dirtAmount + dirtDelta, force);
    end;
    superFunc(self, dirtAmount, force);
end

function BuyableTwinWheelsAttacher:getDriveGroundParticleSystemsScale(superFunc, particleSystem)
    if particleSystem.isTwinWheelPS and self.buyableTwinWheels.twinWheels == nil then
        return 0;
    else
        return superFunc(self, particleSystem);
    end
end