--
-- federung
--
-- author: upsidedown
-- date: 16.03.2014

-- NO RELEASE CANDIDATE!


federung = {};


function federung.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function federung:load(xmlFile)
	
	self.federung = {};
	local i=0;
    while true do
        local areaKey = string.format("vehicle.federung.part(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then			
            break;
        end
		
        local part = {};
		
		part.object = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#index"));	
		
		part.y0 = Utils.getNoNil(getXMLFloat(xmlFile, areaKey .. "#y0"),0);
		
		part.damp = getXMLFloat(xmlFile, areaKey .. "#damper")/100;
		part.spring = getXMLFloat(xmlFile, areaKey .. "#spring")/10000;
		
		part.minY = getXMLFloat(xmlFile, areaKey .. "#minY")
		part.maxY = getXMLFloat(xmlFile, areaKey .. "#maxY")
		--part.lastY = 0;
		part.lastV_Y = 0;
		
        i = i + 1;
		self.federung[i] = part;		
    end
	
end;

function federung:delete()
	
end;

function federung:mouseEvent(posX, posY, isDown, isUp, button)
end;

function federung:keyEvent(unicode, sym, modifier, isDown)
end;

function federung:update(dt)
		
end;

function federung:updateTick(dt)
	if self:getIsActive() then		
		for _,part in pairs(self.federung) do			
			local x,y,z = getTranslation(part.object);
			
			local _,wy,_ = getWorldTranslation(part.object);
			if part.lastY == nil then
				part.lastY = wy;
			end;
			
			local dy = wy - part.lastY;
			
			--reset to original coordinates:
			local newY = y - dy;
			
			--lets do some elementary physics:			
			local Fspring = -part.spring*(newY-part.y0);
			local Fdamp = -part.damp*part.lastV_Y;
			
			local v = part.lastV_Y + (Fspring+Fdamp)*dt
			part.lastV_Y = v;
			
			newY = newY + v*dt;
			
			newY = Utils.clamp(newY,part.y0 + part.minY,part.y0 + part.maxY);
			setTranslation(part.object,x,newY,z);
			
			_,wy,_ = getWorldTranslation(part.object);
			part.lastY = wy;
		end;
	end;
end;


function federung:draw()
	
end;


function federung:onDeactivate()
	
end;