--
-- HelpPanel
-- Specialization to display additional info
--
-- @author:  	Burner
-- @date:		06.03.2012
-- 
--

HelpPanel = {};

function HelpPanel.prerequisitesPresent(specializations)
    return true;
end;

function HelpPanel:load(xmlFile)
	self.helpPanelPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.helpPanel#posX"), 0.6295);
	self.helpPanelPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.helpPanel#posY"), 0.436);
    self.helpPanelWidth = 0.36;
    self.helpPanelHeight = 0.44;
    self.helpPanelOverlay = Overlay:new("helpPanel", Utils.getFilename("Items/hud.png", self.baseDirectory), self.helpPanelPoxX, self.helpPanelPoxY, self.helpPanelWidth, self.helpPanelHeight);
	
	self.helpPanelLogoPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.helpPanel#logoPosX"), 0.82);
	self.helpPanelLogoPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.helpPanel#logoPosY"), 0.39);
	self.helpPanelLogoWidth = 0.18;
    self.helpPanelLogoHeight = 0.225;
	self.helpPanelLogoOverlay = Overlay:new("helpPanelLogo", Utils.getFilename("Items/hud_logo.png", self.baseDirectory), self.helpPanelLogoPoxX, self.helpPanelLogoPoxY, self.helpPanelLogoWidth, self.helpPanelLogoHeight);
	
	self.helpPanelActive = false;
	
	self.num5Active = false;
	self.num8Active = false;
end;

function HelpPanel:delete()
end;

function HelpPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HelpPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function HelpPanel:update(dt)
	self.num5Active = false;
	self.num8Active = false;
	
	if self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.RopaEuroTiger_OpenPanel) then
			self.helpPanelActive = not self.helpPanelActive;
		end;
		if self.isMotorStarted then
			if InputBinding.isPressed(InputBinding.RopaEuroTiger_PipeUp) then
				self.num8Active = true
			elseif InputBinding.isPressed(InputBinding.RopaEuroTiger_PipeDown) then
				self.num5Active = true;
			end;
		end;
	end;
end;

function HelpPanel:draw()
	if self.helpPanelActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("RopaEuroTiger_HelpPanelOff"), InputBinding.RopaEuroTiger_OpenPanel);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("RopaEuroTiger_HelpPanelOn"), InputBinding.RopaEuroTiger_OpenPanel);
	end;
	
	if self.helpPanelActive then
		setTextBold(false);
		if self.helpPanelOverlay ~= nil then
			self.helpPanelOverlay:render();
			self.helpPanelLogoOverlay:render();
		end;

		if not self.steeringLocked then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.84, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_AUTOSTEER)..": "..g_i18n:getText("RopaEuroTiger_Autosteer"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.84, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_AUTOSTEER)..": "..g_i18n:getText("RopaEuroTiger_Autosteer"))));
		end;
		if self.steeringMode == RopaEuroTiger_XL.SynchronizedSteering then
			if self.isMotorStarted then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.82, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_SynchronizedSteering)..": "..g_i18n:getText("RopaEuroTiger_SynchronizedSteering"))));
		else
			if self.isMotorStarted then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.82, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_SynchronizedSteering)..": "..g_i18n:getText("RopaEuroTiger_SynchronizedSteering"))));
		end;
		
		if self.steeringMode == RopaEuroTiger_XL.OffsetSteerLeft then
			if self.isMotorStarted then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.80, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_OffsetSteerLeft)..": "..g_i18n:getText("RopaEuroTiger_OffsetSteerLeft"))));
		else
			if self.isMotorStarted then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.80, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_OffsetSteerLeft)..": "..g_i18n:getText("RopaEuroTiger_OffsetSteerLeft"))));
		end;
		if self.steeringMode == RopaEuroTiger_XL.OffsetSteerRight then
			if self.isMotorStarted then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.78, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_OffsetSteerRight)..": "..g_i18n:getText("RopaEuroTiger_OffsetSteerRight"))));
		else
			if self.isMotorStarted then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.78, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_OffsetSteerRight)..": "..g_i18n:getText("RopaEuroTiger_OffsetSteerRight"))));
		end;

		if self.steeringMode == RopaEuroTiger_XL.TotalSteer then
			if self.isMotorStarted then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.76, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_TotalSteer)..": "..g_i18n:getText("RopaEuroTiger_TotalSteer"))));
		else
			if self.isMotorStarted then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.76, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_TotalSteer)..": "..g_i18n:getText("RopaEuroTiger_TotalSteer"))));
		end;
		if self.steeringMode == RopaEuroTiger_XL.AllWheelSteer then
			if self.isMotorStarted then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.74, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_AllWheelSteer)..": "..g_i18n:getText("RopaEuroTiger_AllWheelSteer"))));
		else
			if self.isMotorStarted then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.74, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_AllWheelSteer)..": "..g_i18n:getText("RopaEuroTiger_AllWheelSteer"))));
		end;
		if self.num8Active then
			if self:getIsPipeStateChangeAllowed(2) then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.72, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_PipeUp), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_PipeUp"))));
		else
			if self:getIsPipeStateChangeAllowed(2) then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.72, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_PipeUp), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_PipeUp"))));
		end;
		if self.num5Active then
			if self:getIsPipeStateChangeAllowed(2) then
				setTextColor(0.95,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.70, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_PipeDown), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_PipeDown"))));
		else
			if self:getIsPipeStateChangeAllowed(2) then
				setTextColor(0,0,0,1);
			else
				setTextColor(0,0,0,0.3);
			end;
			renderText(0.6445, 0.70, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_PipeDown), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_PipeDown"))));
		end;
		
		if self.B3["work"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.68, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_FrontWorkLight)..": "..g_i18n:getText("RopaEuroTiger_FrontWorkLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.68, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_FrontWorkLight)..": "..g_i18n:getText("RopaEuroTiger_FrontWorkLight"))));
		end;
		if self.B3["work"][2].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.66, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_BackWorkLight)..": "..g_i18n:getText("RopaEuroTiger_BackWorkLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.66, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_BackWorkLight)..": "..g_i18n:getText("RopaEuroTiger_BackWorkLight"))));
		end;
		if self.B3["work"][3].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.64, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_ElevatorLight)..": "..g_i18n:getText("RopaEuroTiger_ElevatorLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.64, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_ElevatorLight)..": "..g_i18n:getText("RopaEuroTiger_ElevatorLight"))));
		end;
		if self.B3["work"][4].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.62, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_LeftWorkLight)..": "..g_i18n:getText("RopaEuroTiger_LeftWorkLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.62, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_LeftWorkLight)..": "..g_i18n:getText("RopaEuroTiger_LeftWorkLight"))));
		end;
		if self.B3["work"][5].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.60, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_RightWorkLight)..": "..g_i18n:getText("RopaEuroTiger_RightWorkLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.60, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_RightWorkLight)..": "..g_i18n:getText("RopaEuroTiger_RightWorkLight"))));
		end;
		if self.B3["work"][6].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.58, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_CleanersLight)..": "..g_i18n:getText("RopaEuroTiger_CleanersLight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.58, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_CleanersLight)..": "..g_i18n:getText("RopaEuroTiger_CleanersLight"))));
		end;
		
		if self.B3["dirLeft"][1].a and not self.B3["dirRight"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.56, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3LEFT), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_LeftBlinker"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.56, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3LEFT), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_LeftBlinker"))));
		end;
		if self.B3["dirRight"][1].a and not self.B3["dirLeft"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.54, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_RightBlinker"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.54, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_RightBlinker"))));
		end;
		if self.B3["dirLeft"][1].a and self.B3["dirRight"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.52, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3WARN), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_WarnLights"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.52, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3WARN), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_WarnLights"))));
		end;
		
		if self.animationParts[10].clipEndTime then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.50, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_DoorOpen), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_CloseDoor"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.50, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_DoorOpen), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_OpenDoor"))));
		end;
		
		if self.animationParts[9].clipEndTime then
			setTextColor(0.95,0,0,1);
			renderText(0.6445, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_WindowOpen), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_CloseWindow"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.6445, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.RopaEuroTiger_WindowOpen), "PAD", "")..": "..g_i18n:getText("RopaEuroTiger_OpenWindow"))));
		end;
	end;
	setTextColor(0,0,0,1);
end;