--
-- class for tueren
--
-- Author Sebastian B. (Blancker, www.landwirtschaftssimulator-2009.de)
--
-- Date  08.08.2009
--
-- Copyright (C) Blancker
-- Edit by Mario


tueren = {}

function tueren.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function tueren:load(xmlFile)        
	
	local rotationPartNodeworkLights = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.workLights#index"));
    if rotationPartNodeworkLights ~= nil then
        self.rotationPartworkLights = {};
        self.rotationPartworkLights.node = rotationPartNodeworkLights;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartworkLights#minRot"));
        self.rotationPartworkLights.minRot = {};
        self.rotationPartworkLights.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartworkLights.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartworkLights.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.workLights#maxRot"));
        self.rotationPartworkLights.maxRot = {};
        self.rotationPartworkLights.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartworkLights.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartworkLights.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartworkLights.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.workLights#rotTime"), 2)*1000;
        self.rotationPartworkLights.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.workLights#touchRotLimit"), 10));
    end;
	local rotationPartNodeleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left#index"));
    if rotationPartNodeleft ~= nil then
        self.rotationPartleft = {};
        self.rotationPartleft.node = rotationPartNodeleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft#minRot"));
        self.rotationPartleft.minRot = {};
        self.rotationPartleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left#maxRot"));
        self.rotationPartleft.maxRot = {};
        self.rotationPartleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#rotTime"), 2)*1000;
        self.rotationPartleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#touchRotLimit"), 10));
    end;
	local rotationPartNodeforward = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.forward#index"));
    if rotationPartNodeforward ~= nil then
        self.rotationPartforward = {};
        self.rotationPartforward.node = rotationPartNodeforward;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartforward#minRot"));
        self.rotationPartforward.minRot = {};
        self.rotationPartforward.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartforward.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartforward.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.forward#maxRot"));
        self.rotationPartforward.maxRot = {};
        self.rotationPartforward.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartforward.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartforward.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartforward.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.forward#rotTime"), 2)*1000;
        self.rotationPartforward.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.forward#touchRotLimit"), 10));
    end;
	local rotationPartNodeback = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.back#index"));
    if rotationPartNodeback~= nil then
        self.rotationPartback = {};
        self.rotationPartback.node = rotationPartNodeback;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartback#minRot"));
        self.rotationPartback.minRot = {};
        self.rotationPartback.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartback.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartback.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.back#maxRot"));
        self.rotationPartback.maxRot = {};
        self.rotationPartback.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartback.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartback.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartback.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.back#rotTime"), 2)*1000;
        self.rotationPartback.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.back#touchRotLimit"), 10));
    end;
	local rotationPartNodecenter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.center#index"));
    if rotationPartNodecenter~= nil then
        self.rotationPartcenter = {};
        self.rotationPartcenter.node = rotationPartNodecenter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcenter#minRot"));
        self.rotationPartcenter.minRot = {};
        self.rotationPartcenter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.center#maxRot"));
        self.rotationPartcenter.maxRot = {};
        self.rotationPartcenter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartcenter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#rotTime"), 2)*1000;
        self.rotationPartcenter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#touchRotLimit"), 10));
    end;
	local rotationPartNoderight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.right#index"));
    if rotationPartNoderight ~= nil then
        self.rotationPartright = {};
        self.rotationPartright.node = rotationPartNoderight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartright#minRot"));
        self.rotationPartright.minRot = {};
        self.rotationPartright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.right#maxRot"));
        self.rotationPartright.maxRot = {};
        self.rotationPartright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#rotTime"), 2)*1000;
        self.rotationPartright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#touchRotLimit"), 10));
    end;
	local rotationPartNodeaworkLights = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aworkLights#index"));
    if rotationPartNodeaworkLights ~= nil then
        self.rotationPartaworkLights = {};
        self.rotationPartaworkLights.node = rotationPartNodeaworkLights;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaworkLights#minRot"));
        self.rotationPartaworkLights.minRot = {};
        self.rotationPartaworkLights.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaworkLights.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaworkLights.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aworkLights#maxRot"));
        self.rotationPartaworkLights.maxRot = {};
        self.rotationPartaworkLights.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaworkLights.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaworkLights.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaworkLights.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aworkLights#rotTime"), 2)*1000;
        self.rotationPartaworkLights.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aworkLights#touchRotLimit"), 10));
    end;
	local rotationPartNodealeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aleft#index"));
    if rotationPartNodealeft ~= nil then
        self.rotationPartaleft = {};
        self.rotationPartaleft.node = rotationPartNodealeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaleft#minRot"));
        self.rotationPartaleft.minRot = {};
        self.rotationPartaleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aleft#maxRot"));
        self.rotationPartaleft.maxRot = {};
        self.rotationPartaleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#rotTime"), 2)*1000;
        self.rotationPartaleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#touchRotLimit"), 10));
    end;
	local rotationPartNodeaforward = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aforward#index"));
    if rotationPartNodeaforward ~= nil then
        self.rotationPartaforward = {};
        self.rotationPartaforward.node = rotationPartNodeaforward;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaforward#minRot"));
        self.rotationPartaforward.minRot = {};
        self.rotationPartaforward.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaforward.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaforward.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aforward#maxRot"));
        self.rotationPartaforward.maxRot = {};
        self.rotationPartaforward.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaforward.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaforward.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaforward.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aforward#rotTime"), 2)*1000;
        self.rotationPartaforward.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aforward#touchRotLimit"), 10));
    end;
	local rotationPartNodeaback = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aback#index"));
    if rotationPartNodeaback ~= nil then
        self.rotationPartaback = {};
        self.rotationPartaback.node = rotationPartNodeaback;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaback#minRot"));
        self.rotationPartaback.minRot = {};
        self.rotationPartaback.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaback.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaback.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aback#maxRot"));
        self.rotationPartaback.maxRot = {};
        self.rotationPartaback.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaback.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaback.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaback.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aback#rotTime"), 2)*1000;
        self.rotationPartaback.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aback#touchRotLimit"), 10));
    end;
	local rotationPartNodeacenter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.acenter#index"));
    if rotationPartNodeacenter ~= nil then
        self.rotationPartacenter = {};
        self.rotationPartacenter.node = rotationPartNodeacenter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartacenter#minRot"));
        self.rotationPartacenter.minRot = {};
        self.rotationPartacenter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartacenter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartacenter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.acenter#maxRot"));
        self.rotationPartacenter.maxRot = {};
        self.rotationPartacenter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartacenter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartacenter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartacenter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.acenter#rotTime"), 2)*1000;
        self.rotationPartacenter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.acenter#touchRotLimit"), 10));
    end;
	local rotationPartNodearight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aright#index"));
    if rotationPartNodearight ~= nil then
        self.rotationPartaright = {};
        self.rotationPartaright.node = rotationPartNodearight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaright#minRot"));
        self.rotationPartaright.minRot = {};
        self.rotationPartaright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aright#maxRot"));
        self.rotationPartaright.maxRot = {};
        self.rotationPartaright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#rotTime"), 2)*1000;
        self.rotationPartaright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#touchRotLimit"), 10));
    end;

        self.crankshaft1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft1#index"));
        self.crankshaft2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft2#index"));
end;
      
function tueren:delete()    
end;

function tueren:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function tueren:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_j then 
		self.rotationMaxworkLights = not self.rotationMaxworkLights;
		self.rotationMaxaworkLights = not self.rotationMaxaworkLights;
	end;
	if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxleft = not self.rotationMaxleft;
		self.rotationMaxaleft = not self.rotationMaxaleft;
	end;
	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxforward = not self.rotationMaxforward;
		self.rotationMaxaforward = not self.rotationMaxaforward;
	end;
	if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxback = not self.rotationMaxback;
		self.rotationMaxaback = not self.rotationMaxaback;
	end;
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxcenter = not self.rotationMaxcenter;
		self.rotationMaxacenter = not self.rotationMaxacenter;
	end;
	if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxright = not self.rotationMaxright;
		self.rotationMaxaright = not self.rotationMaxaright;
	end;
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;

function tueren:update(dt)   
	
	if self.rotationPartworkLights ~= nil then
		local x, y, z = getRotation(self.rotationPartworkLights.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartworkLights.maxRot, self.rotationPartworkLights.minRot, 3, self.rotationPartworkLights.rotTime, dt, not self.rotationMaxworkLights);
		setRotation(self.rotationPartworkLights.node, unpack(newRot));
	end;
	if self.rotationPartleft ~= nil then
		local x, y, z = getRotation(self.rotationPartleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft.maxRot, self.rotationPartleft.minRot, 3, self.rotationPartleft.rotTime, dt, not self.rotationMaxleft);
		setRotation(self.rotationPartleft.node, unpack(newRot));
	end;
	if self.rotationPartforward  ~= nil then
		local x, y, z = getRotation(self.rotationPartforward .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartforward.maxRot, self.rotationPartforward.minRot, 3, self.rotationPartforward.rotTime, dt, not self.rotationMaxforward);
		setRotation(self.rotationPartforward .node, unpack(newRot));
	end;
	if self.rotationPartback  ~= nil then
		local x, y, z = getRotation(self.rotationPartback .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartback.maxRot, self.rotationPartback.minRot, 3, self.rotationPartback.rotTime, dt, not self.rotationMaxback);
		setRotation(self.rotationPartback .node, unpack(newRot));
	end;
	if self.rotationPartcenter  ~= nil then
		local x, y, z = getRotation(self.rotationPartcenter .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartcenter.maxRot, self.rotationPartcenter.minRot, 3, self.rotationPartcenter.rotTime, dt, not self.rotationMaxcenter);
		setRotation(self.rotationPartcenter .node, unpack(newRot));
	end;
	if self.rotationPartright ~= nil then
		local x, y, z = getRotation(self.rotationPartright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartright.maxRot, self.rotationPartright.minRot, 3, self.rotationPartright.rotTime, dt, not self.rotationMaxright);
		setRotation(self.rotationPartright.node, unpack(newRot));
             end;
	if self.rotationPartaworkLights ~= nil then
		local x, y, z = getRotation(self.rotationPartaworkLights.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaworkLights.maxRot, self.rotationPartaworkLights.minRot, 3, self.rotationPartaworkLights.rotTime, dt, not self.rotationMaxaworkLights);
		setRotation(self.rotationPartaworkLights.node, unpack(newRot));
	end;
	if self.rotationPartaleft ~= nil then
		local x, y, z = getRotation(self.rotationPartaleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaleft.maxRot, self.rotationPartaleft.minRot, 3, self.rotationPartaleft.rotTime, dt, not self.rotationMaxaleft);
		setRotation(self.rotationPartaleft.node, unpack(newRot));
	end;
	if self.rotationPartaforward  ~= nil then
		local x, y, z = getRotation(self.rotationPartaforward .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaforward .maxRot, self.rotationPartaforward .minRot, 3, self.rotationPartaforward .rotTime, dt, not self.rotationMaxaforward);
		setRotation(self.rotationPartaforward .node, unpack(newRot));
	end;	
	if self.rotationPartaback  ~= nil then
		local x, y, z = getRotation(self.rotationPartaback .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaback .maxRot, self.rotationPartaback .minRot, 3, self.rotationPartaback .rotTime, dt, not self.rotationMaxaback);
		setRotation(self.rotationPartaback .node, unpack(newRot));
	end;
	if self.rotationPartacenter  ~= nil then
		local x, y, z = getRotation(self.rotationPartacenter .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartacenter .maxRot, self.rotationPartacenter .minRot, 3, self.rotationPartacenter .rotTime, dt, not self.rotationMaxacenter);
		setRotation(self.rotationPartacenter .node, unpack(newRot));
	end;
	if self.rotationPartaright ~= nil then
		local x, y, z = getRotation(self.rotationPartaright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaright.maxRot, self.rotationPartaright.minRot, 3, self.rotationPartaright.rotTime, dt, not self.rotationMaxaright);
		setRotation(self.rotationPartaright.node, unpack(newRot));
	end;
if self.crankshaft1Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft1Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
if self.crankshaft2Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft2Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
end;

function tueren:onLeave()
end;

function tueren:draw()

	if not self.helpPanel then
			renderText(0.8533, 0.16, 0.01, g_i18n:getText("Info_ON"));
		else
			renderText(0.8533, 0.16, 0.01, g_i18n:getText("Info_OFF"));
		end;
		if self.helpPanel then
			renderText(0.76, 0.68, 0.025, g_i18n:getText("Info_MTZ"));
			renderText(0.76, 0.64, 0.02, g_i18n:getText("Front_Lig")); 
			renderText(0.76, 0.62, 0.02, g_i18n:getText("Left_door")); 
			renderText(0.76, 0.60, 0.02, g_i18n:getText("Right_door")); 
			renderText(0.76, 0.58, 0.02, g_i18n:getText("Left_window")); 
			renderText(0.76, 0.56, 0.02, g_i18n:getText("Back_window")); 
			renderText(0.76, 0.54, 0.02, g_i18n:getText("Right_window")); 
			renderText(0.76, 0.52, 0.02, g_i18n:getText("BEL3LEFT")); 
			renderText(0.76, 0.50, 0.02, g_i18n:getText("BEL3WARN")); 
			renderText(0.76, 0.48, 0.02, g_i18n:getText("BEL3RIGHT")); 
	end;	
end;

