--
-- Ritchie 1498
-- LS_UK Modteam
-- 25/05/2011
--


ritchie = {};

function ritchie.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function ritchie:load(xmlFile)

	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

	self.brakelightsActive = false;
    self.braking = false;	
	
	self.hudInfoBasePosX = 0.55;
	self.hudInfoBasePosY = 0.76;
	self.hudInfoBaseWidth = 0.23;
	self.hudInfoBaseHeight = 0.233;
    self.infoPanelPath = Utils.getFilename("textures/ritchie_menu.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = false;

	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

	self.setArmTwo = SpecializationUtil.callSpecializationsFunction("setArmTwo");
	self.ArmTwoAnimation = getXMLString(xmlFile, "vehicle.armTwo#animationName");
	self.ArmTwo = false;

	self.setArmThree = SpecializationUtil.callSpecializationsFunction("setArmThree");
	self.ArmThreeAnimation = getXMLString(xmlFile, "vehicle.armThree#animationName");
	self.ArmThree = false;

	self.setArmFour = SpecializationUtil.callSpecializationsFunction("setArmFour");
	self.ArmFourAnimation = getXMLString(xmlFile, "vehicle.armFour#animationName");
	self.ArmFour = false;

	self.setArmFive = SpecializationUtil.callSpecializationsFunction("setArmFive");
	self.ArmFiveAnimation = getXMLString(xmlFile, "vehicle.armFive#animationName");
	self.ArmFive = false;

	self.setArmSix = SpecializationUtil.callSpecializationsFunction("setArmSix");
	self.ArmSixAnimation = getXMLString(xmlFile, "vehicle.armSix#animationName");
	self.ArmSix = false;

	self.setArmSeven = SpecializationUtil.callSpecializationsFunction("setArmSeven");
	self.ArmSevenAnimation = getXMLString(xmlFile, "vehicle.armSeven#animationName");
	self.ArmSeven = false;
	
	self.setArmEight = SpecializationUtil.callSpecializationsFunction("setArmEight");
	self.ArmEightAnimation = getXMLString(xmlFile, "vehicle.armEight#animationName");
	self.ArmEight = false;

	self.stand = {};
	self.stand[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.stand#index1"));
	self.stand[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.stand#index2"));
	

	
end;
function ritchie:readStream(streamId, connection)
    self:setArmOne(streamReadBool(streamId), true);
    self:setArmTwo(streamReadBool(streamId), true); 
    self:setArmThree(streamReadBool(streamId), true);
    self:setArmFour(streamReadBool(streamId), true);
    self:setArmFive(streamReadBool(streamId), true);
    self:setArmSix(streamReadBool(streamId), true);
    self:setArmSeven(streamReadBool(streamId), true);
    self:setArmEight(streamReadBool(streamId), true);	
	
end;

function ritchie:writeStream(streamId, connection)
   streamWriteBool(streamId, self.ArmOne);
   streamWriteBool(streamId, self.ArmTwo);
   streamWriteBool(streamId, self.ArmThree);
   streamWriteBool(streamId, self.ArmFour);
   streamWriteBool(streamId, self.ArmFive);
   streamWriteBool(streamId, self.ArmSix);
   streamWriteBool(streamId, self.ArmSeven);
   streamWriteBool(streamId, self.ArmEight);
end;

function ritchie:update(dt)

	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;

		
	if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
	end;

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ARMFRONT1498) then
			self:setArmOne(not self.isArmOneOn);
			self:setArmTwo(not self.isArmTwoOn);
		end;
		if InputBinding.hasEvent(InputBinding.ARMMIDDLE1498) then
			self:setArmThree(not self.isArmThreeOn);			  
			self:setArmFour(not self.isArmFourOn);	
		end;
		if InputBinding.hasEvent(InputBinding.ARMBACK1498) then
			self:setArmFive(not self.isArmFiveOn);				  
			self:setArmSix(not self.isArmSixOn);	
		end;
		if InputBinding.hasEvent(InputBinding.ARMNEWBACK1498) then
			self:setArmSeven(not self.isArmSevenOn);				  
			self:setArmEight(not self.isArmEightOn);	
		end;
		if InputBinding.hasEvent(InputBinding.ARMALLUP1498) then
			self:setArmOne(true,false);
			self:setArmTwo(true,false);
			self:setArmThree(true,false);
			self:setArmFour(true,false);
			self:setArmFive(true,false);
			self:setArmSix(true,false);
			self:setArmSeven(true,false);
			self:setArmEight(true,false);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENTHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;

function ritchie:draw()

	if self:getIsActive() then
		if self.showHudInfoBase then
			self.hudInfoBaseOverlay:render();
			g_currentMission:addHelpButtonText(g_i18n:getText("IMPLEMENTHUDOFF"), InputBinding.IMPLEMENTHUD);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("IMPLEMENTHUD"), InputBinding.IMPLEMENTHUD);
		end;
	end;
end;

function ritchie:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ritchie:getSaveAttributesAndNodes(nodeIdent)
   -- local attributes = ' side="'..tostring(self.currentSide)..'"';
    local attributes = nil;
    local node = nil;
    return attributes, node;
end;

function ritchie:delete()
end;

function ritchie:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ritchie:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == Input.KEY_KP_enter then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
end;

function ritchie:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

function ritchie:setArmTwo(isArmTwo,noEventSend)
	SetArmTwoEvent.sendEvent(self, isArmTwo, noEventSend);
	-- Play ArmTwo animation --
	self.isArmTwoOn = isArmTwo;
	if self.isArmTwoOn then
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, -1, nil, true);
			self.ArmTwo = true;
		end;
	else
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, 1, nil, true);
			self.ArmTwo = false;
		end;
	end;	
end;

function ritchie:setArmThree(isArmThree,noEventSend)
	SetArmThreeEvent.sendEvent(self, isArmThree, noEventSend);
	-- Play ArmThree animation --
	self.isArmThreeOn = isArmThree;
	if self.isArmThreeOn then
		if self.ArmThreeAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmThreeAnimation, -1, nil, true);
			self.ArmThree = true;
		end;
	else
		if self.ArmThreeAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmThreeAnimation, 1, nil, true);
			self.ArmThree = false;
		end;
	end;	
end;

function ritchie:setArmFour(isArmFour,noEventSend)
	SetArmFourEvent.sendEvent(self, isArmFour, noEventSend);
	-- Play ArmFour animation --
	self.isArmFourOn = isArmFour;
	if self.isArmFourOn then
		if self.ArmFourAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmFourAnimation, -1, nil, true);
			self.ArmFour = true;
		end;
	else
		if self.ArmFourAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmFourAnimation, 1, nil, true);
			self.ArmFour = false;
		end;
	end;	
end;

function ritchie:setArmFive(isArmFive,noEventSend)
	SetArmFiveEvent.sendEvent(self, isArmFive, noEventSend);
	-- Play ArmFive animation --
	self.isArmFiveOn = isArmFive;
	if self.isArmFiveOn then
		if self.ArmFiveAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmFiveAnimation, -1, nil, true);
			self.ArmFive = true;
		end;
	else
		if self.ArmFiveAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmFiveAnimation, 1, nil, true);
			self.ArmFive = false;
		end;
	end;	
end;

function ritchie:setArmSix(isArmSix,noEventSend)
	SetArmSixEvent.sendEvent(self, isArmSix, noEventSend);
	-- Play ArmSix animation --
	self.isArmSixOn = isArmSix;
	if self.isArmSixOn then
		if self.ArmSixAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmSixAnimation, -1, nil, true);
			self.ArmSix = true;
		end;
	else
		if self.ArmSixAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmSixAnimation, 1, nil, true);
			self.ArmSix = false;
		end;
	end;	
end;

function ritchie:setArmSeven(isArmSeven,noEventSend)
	SetArmSevenEvent.sendEvent(self, isArmSeven, noEventSend);
	-- Play ArmSeven animation --
	self.isArmSevenOn = isArmSeven;
	if self.isArmSevenOn then
		if self.ArmSevenAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmSevenAnimation, -1, nil, true);
			self.ArmSeven = true;
		end;
	else
		if self.ArmSevenAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmSevenAnimation, 1, nil, true);
			self.ArmSeven = false;
		end;
	end;	
end;

function ritchie:setArmEight(isArmEight,noEventSend)
	SetArmEightEvent.sendEvent(self, isArmEight, noEventSend);
	-- Play ArmEight animation --
	self.isArmEightOn = isArmEight;
	if self.isArmEightOn then
		if self.ArmEightAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmEightAnimation, -1, nil, true);
			self.ArmEight = true;
		end;
	else
		if self.ArmEightAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmEightAnimation, 1, nil, true);
			self.ArmEight = false;
		end;
	end;	
end;

function ritchie:onAttach(attacherVehicle)
	  
	
end;

function ritchie:onDetach()
	
		
end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;

SetArmTwoEvent = {};
SetArmTwoEvent_mt = Class(SetArmTwoEvent, Event);

InitEventClass(SetArmTwoEvent, "SetArmTwoEvent");

function SetArmTwoEvent:emptyNew()
    local self = Event:new(SetArmTwoEvent_mt);
    self.className="SetArmTwoEvent";
    return self;
end;

function SetArmTwoEvent:new(vehicle, isArmTwo)
    local self = SetArmTwoEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmTwo = isArmTwo;
    return self;
end;

function SetArmTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmTwo = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmTwo);
end;

function SetArmTwoEvent:run(connection)   
	self.vehicle:setArmTwo(self.isArmTwo, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmTwoEvent:new(self.vehicle, self.isArmTwo), nil, connection, self.vehicle);
    end;
end;

function SetArmTwoEvent.sendEvent(vehicle, isArmTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmTwoEvent:new(vehicle, isArmTwo), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmTwoEvent:new(vehicle, isArmTwo));
		end;
	end;
end;

SetArmThreeEvent = {};
SetArmThreeEvent_mt = Class(SetArmThreeEvent, Event);

InitEventClass(SetArmThreeEvent, "SetArmThreeEvent");

function SetArmThreeEvent:emptyNew()
    local self = Event:new(SetArmThreeEvent_mt);
    self.className="SetArmThreeEvent";
    return self;
end;

function SetArmThreeEvent:new(vehicle, isArmThree)
    local self = SetArmThreeEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmThree = isArmThree;
    return self;
end;

function SetArmThreeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmThree = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmThreeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmThree);
end;

function SetArmThreeEvent:run(connection)   
	self.vehicle:setArmThree(self.isArmThree, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmThreeEvent:new(self.vehicle, self.isArmThree), nil, connection, self.vehicle);
    end;
end;

function SetArmThreeEvent.sendEvent(vehicle, isArmThree, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmThreeEvent:new(vehicle, isArmThree), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmThreeEvent:new(vehicle, isArmThree));
		end;
	end;
end;

SetArmFourEvent = {};
SetArmFourEvent_mt = Class(SetArmFourEvent, Event);

InitEventClass(SetArmFourEvent, "SetArmFourEvent");

function SetArmFourEvent:emptyNew()
    local self = Event:new(SetArmFourEvent_mt);
    self.className="SetArmFourEvent";
    return self;
end;

function SetArmFourEvent:new(vehicle, isArmFour)
    local self = SetArmFourEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmFour = isArmFour;
    return self;
end;

function SetArmFourEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmFour = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmFourEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmFour);
end;

function SetArmFourEvent:run(connection)   
	self.vehicle:setArmFour(self.isArmFour, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmFourEvent:new(self.vehicle, self.isArmFour), nil, connection, self.vehicle);
    end;
end;

function SetArmFourEvent.sendEvent(vehicle, isArmFour, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmFourEvent:new(vehicle, isArmFour), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmFourEvent:new(vehicle, isArmFour));
		end;
	end;
end;

SetArmFiveEvent = {};
SetArmFiveEvent_mt = Class(SetArmFiveEvent, Event);

InitEventClass(SetArmFiveEvent, "SetArmFiveEvent");

function SetArmFiveEvent:emptyNew()
    local self = Event:new(SetArmFiveEvent_mt);
    self.className="SetArmFiveEvent";
    return self;
end;

function SetArmFiveEvent:new(vehicle, isArmFive)
    local self = SetArmFiveEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmFive = isArmFive;
    return self;
end;

function SetArmFiveEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmFive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmFiveEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmFive);
end;

function SetArmFiveEvent:run(connection)   
	self.vehicle:setArmFive(self.isArmFive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmFiveEvent:new(self.vehicle, self.isArmFive), nil, connection, self.vehicle);
    end;
end;

function SetArmFiveEvent.sendEvent(vehicle, isArmFive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmFiveEvent:new(vehicle, isArmFive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmFiveEvent:new(vehicle, isArmFive));
		end;
	end;
end;

SetArmSixEvent = {};
SetArmSixEvent_mt = Class(SetArmSixEvent, Event);

InitEventClass(SetArmSixEvent, "SetArmSixEvent");

function SetArmSixEvent:emptyNew()
    local self = Event:new(SetArmSixEvent_mt);
    self.className="SetArmSixEvent";
    return self;
end;

function SetArmSixEvent:new(vehicle, isArmSix)
    local self = SetArmSixEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmSix = isArmSix;
    return self;
end;

function SetArmSixEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmSix = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmSixEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmSix);
end;

function SetArmSixEvent:run(connection)   
	self.vehicle:setArmSix(self.isArmSix, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmSixEvent:new(self.vehicle, self.isArmSix), nil, connection, self.vehicle);
    end;
end;

function SetArmSixEvent.sendEvent(vehicle, isArmSix, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmSixEvent:new(vehicle, isArmSix), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmSixEvent:new(vehicle, isArmSix));
		end;
	end;
end;

SetArmSevenEvent = {};
SetArmSevenEvent_mt = Class(SetArmSevenEvent, Event);

InitEventClass(SetArmSevenEvent, "SetArmSevenEvent");

function SetArmSevenEvent:emptyNew()
    local self = Event:new(SetArmSevenEvent_mt);
    self.className="SetArmSevenEvent";
    return self;
end;

function SetArmSevenEvent:new(vehicle, isArmSeven)
    local self = SetArmSevenEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmSeven = isArmSeven;
    return self;
end;

function SetArmSevenEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmSeven = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmSevenEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmSeven);
end;

function SetArmSevenEvent:run(connection)   
	self.vehicle:setArmSeven(self.isArmSeven, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmSevenEvent:new(self.vehicle, self.isArmSeven), nil, connection, self.vehicle);
    end;
end;

function SetArmSevenEvent.sendEvent(vehicle, isArmSeven, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmSevenEvent:new(vehicle, isArmSeven), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmSevenEvent:new(vehicle, isArmSeven));
		end;
	end;
end;


SetArmEightEvent = {};
SetArmEightEvent_mt = Class(SetArmEightEvent, Event);

InitEventClass(SetArmEightEvent, "SetArmEightEvent");

function SetArmEightEvent:emptyNew()
    local self = Event:new(SetArmEightEvent_mt);
    self.className="SetArmEightEvent";
    return self;
end;

function SetArmEightEvent:new(vehicle, isArmEight)
    local self = SetArmEightEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmEight = isArmEight;
    return self;
end;

function SetArmEightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmEight = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmEightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmEight);
end;

function SetArmEightEvent:run(connection)   
	self.vehicle:setArmEight(self.isArmEight, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmEightEvent:new(self.vehicle, self.isArmEight), nil, connection, self.vehicle);
    end;
end;

function SetArmEightEvent.sendEvent(vehicle, isArmEight, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmEightEvent:new(vehicle, isArmEight), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmEightEvent:new(vehicle, isArmEight));
		end;
	end;
end;