RitchieBaleRight2Event = {};
RitchieBaleRight2Event_mt = Class(RitchieBaleRight2Event, Event);

InitEventClass(RitchieBaleRight2Event, "RitchieBaleRight2Event");

function RitchieBaleRight2Event:emptyNew()
    local self = Event:new(RitchieBaleRight2Event_mt);
    self.className="RitchieBaleRight2Event";

    return self;
end;

function RitchieBaleRight2Event:new(vehicle, baleId)
    local self = RitchieBaleRight2Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleRight2Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleRight2Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleRight2Event:run(connection)
	self.vehicle:setBaleRight2(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleRight2Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleRight2Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleRight2Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleRight2Event:new(vehicle, baleId));
		end;
	end;
end;