RitchieBaleLeft3Event = {};
RitchieBaleLeft3Event_mt = Class(RitchieBaleLeft3Event, Event);

InitEventClass(RitchieBaleLeft3Event, "RitchieBaleLeft3Event");

function RitchieBaleLeft3Event:emptyNew()
    local self = Event:new(RitchieBaleLeft3Event_mt);
    self.className="RitchieBaleLeft3Event";

    return self;
end;

function RitchieBaleLeft3Event:new(vehicle, baleId)
    local self = RitchieBaleLeft3Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleLeft3Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleLeft3Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleLeft3Event:run(connection)
	self.vehicle:setBaleLeft3(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleLeft3Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleLeft3Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleLeft3Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleLeft3Event:new(vehicle, baleId));
		end;
	end;
end;