RitchieBaleLeft1Event = {};
RitchieBaleLeft1Event_mt = Class(RitchieBaleLeft1Event, Event);

InitEventClass(RitchieBaleLeft1Event, "RitchieBaleLeft1Event");

function RitchieBaleLeft1Event:emptyNew()
    local self = Event:new(RitchieBaleLeft1Event_mt);
    self.className="RitchieBaleLeft1Event";

    return self;
end;

function RitchieBaleLeft1Event:new(vehicle, baleId)
    local self = RitchieBaleLeft1Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleLeft1Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleLeft1Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleLeft1Event:run(connection)
	self.vehicle:setBaleLeft1(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleLeft1Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleLeft1Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleLeft1Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleLeft1Event:new(vehicle, baleId));
		end;
	end;
end;