--
-- Ritchie 1498
-- LS_UK Modteam
-- 25/05/2011
--


Ritchie1498 = {};

function Ritchie1498.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(ritchie, specializations);
end;

function Ritchie1498:load(xmlFile)	

	self.setBaleLeft = SpecializationUtil.callSpecializationsFunction("setBaleLeft");
	self.setBaleRight = SpecializationUtil.callSpecializationsFunction("setBaleRight");
	self.setBaleLeft1 = SpecializationUtil.callSpecializationsFunction("setBaleLeft1");
	self.setBaleRight1 = SpecializationUtil.callSpecializationsFunction("setBaleRight1");
	self.setBaleLeft2 = SpecializationUtil.callSpecializationsFunction("setBaleLeft2");
	self.setBaleRight2 = SpecializationUtil.callSpecializationsFunction("setBaleRight2");
	self.setBaleLeft3 = SpecializationUtil.callSpecializationsFunction("setBaleLeft3");
	self.setBaleRight3 = SpecializationUtil.callSpecializationsFunction("setBaleRight3");
	self.objectInRange = Ritchie1498.objectInRange;

	self.lockLeft = {};
	self.lockLeft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeLeft#index"));
	self.lockLeft.child = getChildAt(self.lockLeft.node, 0);
	self.lockLeft.baleId = nil;
	
	self.lockRight = {};
	self.lockRight.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeRight#index"));
	self.lockRight.child = getChildAt(self.lockRight.node, 0);
	self.lockRight.baleId = nil;

	self.lockLeft1 = {};
	self.lockLeft1.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeLeft1#index"));
	self.lockLeft1.child = getChildAt(self.lockLeft1.node, 0);
	self.lockLeft1.baleId = nil;
	
	self.lockRight1 = {};
	self.lockRight1.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeRight1#index"));
	self.lockRight1.child = getChildAt(self.lockRight1.node, 0);
	self.lockRight1.baleId = nil;

	self.lockLeft2 = {};
	self.lockLeft2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeLeft2#index"));
	self.lockLeft2.child = getChildAt(self.lockLeft2.node, 0);
	self.lockLeft2.baleId = nil;
	
	self.lockRight2 = {};
	self.lockRight2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeRight2#index"));
	self.lockRight2.child = getChildAt(self.lockRight2.node, 0);
	self.lockRight2.baleId = nil;

	self.lockLeft3 = {};
	self.lockLeft3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeLeft3#index"));
	self.lockLeft3.child = getChildAt(self.lockLeft3.node, 0);
	self.lockLeft3.baleId = nil;
	
	self.lockRight3 = {};
	self.lockRight3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeRight3#index"));
	self.lockRight3.child = getChildAt(self.lockRight3.node, 0);
	self.lockRight3.baleId = nil;
end;

function Ritchie1498:delete()
	self:setBaleLeft(nil, false);
	self:setBaleRight(nil, false);
	self:setBaleLeft1(nil, false);
	self:setBaleRight1(nil, false);
	self:setBaleLeft2(nil, false);
	self:setBaleRight2(nil, false);
	self:setBaleLeft3(nil, false);
	self:setBaleRight3(nil, false);	
end;

function Ritchie1498:readStream(streamId, connection)
	self:setBaleLeft(streamReadInt32(streamId), true);
	self:setBaleRight(streamReadInt32(streamId), true);
	self:setBaleLeft1(streamReadInt32(streamId), true);
	self:setBaleRight1(streamReadInt32(streamId), true);
	self:setBaleLeft2(streamReadInt32(streamId), true);
	self:setBaleRight2(streamReadInt32(streamId), true);
	self:setBaleLeft3(streamReadInt32(streamId), true);
	self:setBaleRight3(streamReadInt32(streamId), true);	
end;

function Ritchie1498:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.lockLeft.baleId);
	streamWriteInt32(streamId, self.lockRight.baleId);
	streamWriteInt32(streamId, self.lockLeft1.baleId);
	streamWriteInt32(streamId, self.lockRight1.baleId);
	streamWriteInt32(streamId, self.lockLeft2.baleId);
	streamWriteInt32(streamId, self.lockRight2.baleId);
	streamWriteInt32(streamId, self.lockLeft3.baleId);
	streamWriteInt32(streamId, self.lockRight3.baleId);
end;

function Ritchie1498:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ritchie1498:keyEvent(unicode, sym, modifier, isDown)
end;

function Ritchie1498:update(dt)

	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.lockLeft.node ~= nil then 
				if self.movingDirection == 1 and self.lockLeft.baleId == nil then
					local bale = self:objectInRange(self.lockLeft);
					
					if bale ~= nil then
						self:setBaleLeft(networkGetObjectId(bale), false);
						self:setArmTwo(true,false);
					end;
				elseif self:getAnimationTime(self.ArmTwoAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleLeft(nil, false);
				end;
			end;
			if self.lockRight.node ~= nil then
				if self.movingDirection == 1 and self.lockRight.baleId == nil then
					local bale = self:objectInRange(self.lockRight);
					
					if bale ~= nil then
						self:setBaleRight(networkGetObjectId(bale), false);
						self:setArmOne(true,false);
					end;
				elseif self:getAnimationTime(self.ArmOneAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleRight(nil, false);
				end;
			end;
			if self.lockLeft1.node ~= nil then 
				if self.movingDirection == 1 and self.lockLeft1.baleId == nil then
					local bale = self:objectInRange(self.lockLeft1);
					
					if bale ~= nil then
						self:setBaleLeft1(networkGetObjectId(bale), false);
						self:setArmFour(true,false);
					end;
				elseif self:getAnimationTime(self.ArmFourAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleLeft1(nil, false);
				end;
			end;
			if self.lockRight1.node ~= nil then
				if self.movingDirection == 1 and self.lockRight1.baleId == nil then
					local bale = self:objectInRange(self.lockRight1);
					
					if bale ~= nil then
						self:setBaleRight1(networkGetObjectId(bale), false);
						self:setArmThree(true,false);
					end;
				elseif self:getAnimationTime(self.ArmThreeAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleRight1(nil, false);
				end;
			end;
			if self.lockLeft2.node ~= nil then 
				if self.movingDirection == 1 and self.lockLeft2.baleId == nil then
					local bale = self:objectInRange(self.lockLeft2);
					
					if bale ~= nil then
						self:setBaleLeft2(networkGetObjectId(bale), false);
						self:setArmSix(true,false);
					end;
				elseif self:getAnimationTime(self.ArmSixAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleLeft2(nil, false);
				end;
			end;
			if self.lockRight2.node ~= nil then
				if self.movingDirection == 1 and self.lockRight2.baleId == nil then
					local bale = self:objectInRange(self.lockRight2);
					
					if bale ~= nil then
						self:setBaleRight2(networkGetObjectId(bale), false);
						self:setArmFive(true,false);
					end;
				elseif self:getAnimationTime(self.ArmFiveAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleRight2(nil, false);
				end;
			end;
			if self.lockLeft3.node ~= nil then 
				if self.movingDirection == 1 and self.lockLeft3.baleId == nil then
					local bale = self:objectInRange(self.lockLeft3);
					
					if bale ~= nil then
						self:setBaleLeft3(networkGetObjectId(bale), false);
						self:setArmEight(true,false);
					end;
				elseif self:getAnimationTime(self.ArmEightAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleLeft3(nil, false);
				end;
			end;
			if self.lockRight3.node ~= nil then
				if self.movingDirection == 1 and self.lockRight3.baleId == nil then
					local bale = self:objectInRange(self.lockRight3);
					
					if bale ~= nil then
						self:setBaleRight3(networkGetObjectId(bale), false);
						self:setArmSeven(true,false);
					end;
				elseif self:getAnimationTime(self.ArmSevenAnimation) == 1 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					self:setBaleRight3(nil, false);
				end;
			end;
		end;
	end;
end;

function Ritchie1498:draw()
	if (self.lockLeft.baleId ~= nil and self:getAnimationTime(self.ArmTwoAnimation) == 1) or (self.lockRight.baleId ~= nil and self:getAnimationTime(self.ArmOneAnimation) == 1) or (self.lockLeft1.baleId ~= nil and self:getAnimationTime(self.ArmFourAnimation) == 1) or (self.lockRight1.baleId ~= nil and self:getAnimationTime(self.ArmThreeAnimation) == 1) or (self.lockLeft2.baleId ~= nil and self:getAnimationTime(self.ArmSixAnimation) == 1) or (self.lockRight2.baleId ~= nil and self:getAnimationTime(self.ArmFiveAnimation) == 1) or (self.lockLeft3.baleId ~= nil and self:getAnimationTime(self.ArmEightAnimation) == 1) or (self.lockRight3.baleId ~= nil and self:getAnimationTime(self.ArmSevenAnimation) == 1) then
		g_currentMission:addHelpButtonText(g_i18n:getText("Unlock"), InputBinding.unlock);
	end;
end;

function Ritchie1498:setBaleLeft(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockLeft.child ~= nil then
			local bale = nil;

			if self.lockLeft.baleId ~= nil then
				bale = networkGetObject(self.lockLeft.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockLeft.baleId = nil;
				end;
			end;

			RitchieBaleLeftEvent.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockLeft.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockLeft.child, 0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockLeft.baleId = baleId;
			end;
		end;
	else
		RitchieBaleLeftEvent.sendEvent(self, baleId, noEventSend);

		if self.lockLeft.baleId ~= nil then
			local bale = networkGetObject(self.lockLeft.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockLeft.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleRight(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockRight.child ~= nil then
			local bale = nil;

			if self.lockRight.baleId ~= nil then
				bale = networkGetObject(self.lockRight.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockRight.baleId = nil;
				end;
			end;

			RitchieBaleRightEvent.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockRight.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockRight.child, -0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockRight.baleId = baleId;
			end;
		end;
	else
		RitchieBaleRightEvent.sendEvent(self, baleId, noEventSend);

		if self.lockRight.baleId ~= nil then
			local bale = networkGetObject(self.lockRight.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockRight.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleLeft1(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockLeft1.child ~= nil then
			local bale = nil;

			if self.lockLeft1.baleId ~= nil then
				bale = networkGetObject(self.lockLeft1.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockLeft1.baleId = nil;
				end;
			end;

			RitchieBaleLeft1Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockLeft1.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockLeft1.child, 0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockLeft1.baleId = baleId;
			end;
		end;
	else
		RitchieBaleLeft1Event.sendEvent(self, baleId, noEventSend);

		if self.lockLeft1.baleId ~= nil then
			local bale = networkGetObject(self.lockLeft1.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockLeft1.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleRight1(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockRight1.child ~= nil then
			local bale = nil;

			if self.lockRight1.baleId ~= nil then
				bale = networkGetObject(self.lockRight1.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockRight1.baleId = nil;
				end;
			end;

			RitchieBaleRight1Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockRight1.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockRight1.child, -0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockRight1.baleId = baleId;
			end;
		end;
	else
		RitchieBaleRight1Event.sendEvent(self, baleId, noEventSend);

		if self.lockRight1.baleId ~= nil then
			local bale = networkGetObject(self.lockRight1.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockRight1.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleLeft2(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockLeft2.child ~= nil then
			local bale = nil;

			if self.lockLeft2.baleId ~= nil then
				bale = networkGetObject(self.lockLeft2.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockLeft2.baleId = nil;
				end;
			end;

			RitchieBaleLeft2Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockLeft2.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockLeft2.child, 0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockLeft2.baleId = baleId;
			end;
		end;
	else
		RitchieBaleLeft2Event.sendEvent(self, baleId, noEventSend);

		if self.lockLeft2.baleId ~= nil then
			local bale = networkGetObject(self.lockLeft2.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockLeft2.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleRight2(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockRight2.child ~= nil then
			local bale = nil;

			if self.lockRight2.baleId ~= nil then
				bale = networkGetObject(self.lockRight2.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockRight2.baleId = nil;
				end;
			end;

			RitchieBaleRight2Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockRight2.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockRight2.child, -0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockRight2.baleId = baleId;
			end;
		end;
	else
		RitchieBaleRight2Event.sendEvent(self, baleId, noEventSend);

		if self.lockRight2.baleId ~= nil then
			local bale = networkGetObject(self.lockRight2.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockRight2.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleLeft3(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockLeft3.child ~= nil then
			local bale = nil;

			if self.lockLeft3.baleId ~= nil then
				bale = networkGetObject(self.lockLeft3.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockLeft3.baleId = nil;
				end;
			end;

			RitchieBaleLeft3Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockLeft3.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockLeft3.child, 0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockLeft3.baleId = baleId;
			end;
		end;
	else
		RitchieBaleLeft3Event.sendEvent(self, baleId, noEventSend);

		if self.lockLeft3.baleId ~= nil then
			local bale = networkGetObject(self.lockLeft3.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockLeft3.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:setBaleRight3(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockRight3.child ~= nil then
			local bale = nil;

			if self.lockRight3.baleId ~= nil then
				bale = networkGetObject(self.lockRight3.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockRight3.baleId = nil;
				end;
			end;

			RitchieBaleRight3Event.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockRight3.child, 0,0,0, 0,0,0);
				else
					bale:mount(self, self.lockRight3.child, -0.17,0,-0.08, 0,math.pi/2,0);
				end;

				self.lockRight3.baleId = baleId;
			end;
		end;
	else
		RitchieBaleRight3Event.sendEvent(self, baleId, noEventSend);

		if self.lockRight3.baleId ~= nil then
			local bale = networkGetObject(self.lockRight3.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockRight3.baleId = nil;
			end;
		end;
	end;
end;

function Ritchie1498:objectInRange(refNode)
    local nearestDistance = 0.8;
    local nearestBale = nil;
    local px, py, pz = getWorldTranslation(refNode.node);

    for index, item in pairs(g_currentMission.itemsToSave) do
        if item.item:isa(Bale) then
				local vx, vy, vz = getWorldTranslation(item.item.nodeId);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					nearestDistance = distance;
					nearestBale = item.item;
				end;
        end;
    end;

    return nearestBale;
end;
