SetCollectingBales = {};
SetCollectingBales_mt = Class(SetCollectingBales, Event);

InitEventClass(SetCollectingBales, "SetCollectingBales");

function SetCollectingBales:emptyNew()
    local self = Event:new(SetCollectingBales_mt);
    self.className="SetCollectingBales";
    return self;
end;

function SetCollectingBales:new(vehicle, collectingBales)
    local self = SetCollectingBales:emptyNew()
    self.vehicle = vehicle;
    self.collectingBales = collectingBales;
    return self;
end;

function SetCollectingBales:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.collectingBales = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetCollectingBales:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.collectingBales);
end;

function SetCollectingBales:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle);
    end;
    self.vehicle:setIsCollectingBales(self.collectingBales, true);
end;

function SetCollectingBales.sendEvent(vehicle, collectingBales, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCollectingBales:new(vehicle, collectingBales), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCollectingBales:new(vehicle, collectingBales));
		end;
	end;
end;