--
-- moveCutNode V2
-- Specialization for moving the cutNode to give a new dimension to the cutNode
--
-- author: Patar (Thomas Heck)
-- date: 28.01.15
--
-- extended V2: 01.09.2015/Patar

moveCutNode = {};

function moveCutNode.prerequisitesPresent(specializations)
    return true;
end;

function moveCutNode:load(xmlFile)
-- V1
	self.moveMinZ = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#moveMinZ"), -1);
	self.moveMaxZ = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#moveMaxZ"), 1);
	self.moveStep = 0.15;
	
-- V2
	self.secondLineY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#secondLineY"), -1);
	self.secondLineX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#secondLineX"), -1);
	
	self.isSecondLine = false;
	
	local x, y, z = getTranslation(self.stumpCutterCutNode);
	self.firstLineY = y; self.firstLineX = x;
	
	self.secondLineXRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#secondLineXRot"), 0);
	self.secondLineYRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#secondLineYRot"), 0);
	self.secondLineZRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#secondLineZRot"), 0);
	
	local xRot, yRot, zRot = getRotation(self.stumpCutterCutNode);
	self.firstLineXRot = xRot; self.firstLineYRot = yRot; self.firstLineZRot = zRot;
	
	self.shouldMovePS = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.stumpCutter.particleSystem#shouldMoveZ"), false);
	
	self.stumpCutterParticleSystems.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stumpCutter.particleSystem#node"))
end;

function moveCutNode:delete()
end;

function moveCutNode:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveCutNode:keyEvent(unicode, sym, modifier, isDown)
end;

function moveCutNode:update(dt)
	if self:getIsTurnedOn() then
		if self.stumpCutterParticleSystems.isEmitting == false then
			local x,y,z = getTranslation(self.stumpCutterCutNode);
			if z > self.moveMaxZ or z < self.moveMinZ then
				self.isSecondLine = not self.isSecondLine;
				self.moveStep = -self.moveStep;
			end;
			z = z + self.moveStep;
			if self.isSecondLine then
				y = self.secondLineY; x = self.secondLineX;
				setRotation(self.stumpCutterCutNode, math.rad(self.secondLineXRot), math.rad(self.secondLineYRot), math.rad(self.secondLineZRot));
			else
				y = self.firstLineY; x = self.firstLineX;
				setRotation(self.stumpCutterCutNode, self.firstLineXRot, self.firstLineYRot, self.firstLineZRot);
			end;
			setTranslation(self.stumpCutterCutNode, x, y, z);
		end;
		if self.shouldMovePS then
			if self.curSplitShape ~= nil and self.isServer then
				x1, y1, z1 = getWorldTranslation(self.curSplitShape);
				x1, y1, z1 = worldToLocal(getParent(self.stumpCutterParticleSystems.node), x1, y1, z1);
				local moveX, moveY, moveZ = getTranslation(self.stumpCutterParticleSystems.node);
				setTranslation(self.stumpCutterParticleSystems.node, moveX, moveY, math.max(math.min(z1, self.moveMaxZ),self.moveMinZ));
			end;
			if self.isClient and not self.isServer then
				local moveX, moveY, moveZ = getTranslation(self.stumpCutterParticleSystems.node);
				setTranslation(self.stumpCutterParticleSystems.node, moveX, moveY, 0);
			end;
		end;
	end;
end;

function moveCutNode:updateTick(dt)
end;

function moveCutNode:draw()
end;

function moveCutNode:onEnter()
end;