--
-- ahwiFM700
-- special functions for Ahwi FM700 V3 (downgraded for FM700H).
--
-- author: Patar (Thomas Heck)
-- date: 03.01.15
--
-- extended V3: 01.09.15/Patar

ahwiFM700 = {};

function ahwiFM700.prerequisitesPresent(specializations)
    return true;
end;

function ahwiFM700:load(xmlFile)

-- StumpColliMovement (SCM)
	self.SCM = {};
	self.SCM.valueY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueY"), 1);
	self.SCM.valueX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueX"), -1);
	self.SCM.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stumpColli#index"))
	self.maxCutTime = 6000;
-- StumpColliMovement (SCM)

-- DustParticles (DP)
	self.DP = {PS={}, free=false, isPloughing=false};
	Utils.loadParticleSystem(xmlFile, self.DP.PS, "vehicle.stumpCutter.dustParticleSystem", self.components, false, nil, self.baseDirectory)
-- DustParticles (DP)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	self.workAreas[1].disableBackwards = false;
	self.PE = {PS={}, maxResetTime=1000, resetTime=0, isActive=false};
	Utils.loadParticleSystem(xmlFile, self.PE.PS, "vehicle.ploughParticleSystem", self.components, false, nil, self.baseDirectory);
	self.PE.PS.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ploughParticleSystem#node"))
	self.PE.refNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ploughParticleSystem#refNode"))
	self.PE.rotOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughParticleSystem#rotOffset"), 0);
	self.PE.flapWarning = {
							overlay = Overlay:new("flapWarning", Utils.getFilename("shared/smallUpDown.dds", self.baseDirectory), 0.475, 0.8, 0.1, 0.1*g_screenAspectRatio),
							active = true,
							timer = 0,
							timerMax = 700,
							};
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	self.MCL = {};
	self.MCL.backupBig = {
							rotMax = self.movingTools[2].rotMax;
							rotMin = self.movingTools[2].rotMin;
							};
	self.MCL.backupSmall = {
							rotMax = self.movingTools[1].rotMax;
							rotMin = self.movingTools[1].rotMin;
							};
-- MouseControlLimit (MCL)

--[[ WoodChipsCreator (WCC)
	self.WCC = {
				upspeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#upspeed"), 0),
				downspeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#downspeed"), 0),
				node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.woodChipsCreator#node")),
				xMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#xMax"), 0.3),
				};
-- WoodChipsCreator (WCC) ]]

-- ShredEverything (SE)
	self.SE = {};
	self.SE.deleteShapes = {};
	self.ahwiSplitShapeCallback = ahwiFM700.ahwiSplitShapeCallback;
	StumpCutter.stumpCutterSplitShapeCallback = ahwiFM700.stumpCutterSplitShapeCallback;
-- ShredEverything (SE)

end;

function ahwiFM700:delete()
	Utils.deleteParticleSystem(self.DP.PS);
	Utils.deleteParticleSystem(self.PE.PS);
end;

function ahwiFM700:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ahwiFM700:keyEvent(unicode, sym, modifier, isDown)
end;

function ahwiFM700:update(dt)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	if self.isServer and self.lastPloughArea > 0 then
		self.PE.resetTime = 0;
	end;
	local x,_,z = getWorldTranslation(self.components[1].node);
	local fieldOwned = g_currentMission:getIsFieldOwnedAtWorldPos(x,z);
	if self.isClient and not self.isServer and self.ploughHasGroundContact and self:getLastSpeed() > 3 and g_currentMission:getHasPermission("createFields", self:getOwner()) and not self.ploughLimitToField then
		self.PE.resetTime = 0;
	end;
	self.PE.resetTime = self.PE.resetTime + dt;
	self.PE.isActive = self.PE.resetTime < self.PE.maxResetTime;
-- PloughingExtension (PE) ]]

end;

function ahwiFM700:updateTick(dt)

-- StumpColliMovement (SCM)
	if not self.stumpCutterParticleSystems.isEmitting then
		setTranslation(self.SCM.index, 0, self.SCM.valueY, 0);
	else
		local actX = (1-self.nextCutTime/self.maxCutTime)*self.SCM.valueX;
		setTranslation(self.SCM.index, actX, 0, 0);
	end;
-- StumpColliMovement (SCM)

-- DirtParticles (DP)
	if self.stumpCutterParticleSystems.isEmitting then
		--print("isEmitting");
		self.DP.free = true;
	end;
	Utils.setEmittingState(self.DP.PS, (self.resetCutTime > 0 and self.DP.free and self:getIsTurnedOn()) or (self.hasWheelGroundContact and self:getIsTurnedOn()));
-- DirtParticles (DP)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	Utils.setEmittingState(self.PE.PS, self.ploughHasGroundContact and self:getIsTurnedOn() and self.PE.isActive);
	local x, y, z = getRotation(self.PE.refNode);
	setRotation(self.PE.PS.node, math.max(x-math.rad(self.PE.rotOffset), 0), y, z);
	if self.PE.flapWarning.timer > self.PE.flapWarning.timerMax then
		self.PE.flapWarning.active = not self.PE.flapWarning.active;
		self.PE.flapWarning.timer = 0;
	end;
	self.PE.flapWarning.timer = self.PE.flapWarning.timer + dt;
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	if self.movingTools[2].curRot[3] < -0.619 then
		self.movingTools[1].rotMax = self.movingTools[1].rotMin+0.005;
	else
		self.movingTools[1].rotMax = self.MCL.backupSmall.rotMax;
	end;
	if self.movingTools[1].curRot[3] > self.MCL.backupSmall.rotMin+0.01 then
		self.movingTools[2].rotMin = -0.619;
	else
		self.movingTools[2].rotMin = self.MCL.backupBig.rotMin;
	end;
-- MouseControlLimit (MCL)

--[[WoodChipsCreator (WCC)
	if self.stumpCutterParticleSystems.isEmitting then
		local x,_,_ = getTranslation
-- WoodChipsCreator (WCC) ]]


-- ShredEverything (SE)

	
	for shape in pairs(self.SE.deleteShapes) do
		local newFillLevel = self.fillLevel+getVolume(shape)*1000*SplitUtil.splitTypes[getSplitType(shape)].woodChipsPerLiter;
		self:setFillLevel(newFillLevel, Fillable.FILLTYPE_WOODCHIPS);
		delete(shape)
		self.SE.deleteShapes[shape] = nil;
	end;
	
	
	if not self.isSecondLine and self.isServer then
		if self.curSplitShape ~= nil then
			x,y,z = getWorldTranslation(self.stumpCutterCutNode);
			nx,ny,nz = localDirectionToWorld(self.stumpCutterCutNode, 1,0,0);
			yx,yy,yz = localDirectionToWorld(self.stumpCutterCutNode, 0,1,0);
			lenBelow, lenAbove = getSplitShapePlaneExtents(self.curSplitShape, x,y,z, nx,ny,nz);
		end;
		
		if lenBelow ~= nil then
			if lenAbove > 0.17 and self.curSplitShape ~= nil then
				splitShape(self.curSplitShape, x,y,z, nx,ny,nz, yx,yy,yz, self.stumpCutterCutSizeY, self.stumpCutterCutSizeZ, "ahwiSplitShapeCallback", self);
				self.curSplitShape = nil;
			end;
		end;
	end;
-- ShredEverything (SE)

end;

function ahwiFM700:draw()
--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	local x, y, z = getRotation(self.PE.PS.node);
	if self.ploughHasGroundContact and self:getIsTurnedOn() and self.PE.isActive and x == 0 and self.PE.flapWarning.active then
		self.PE.flapWarning.overlay:render();
	end;
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	if (InputBinding.getInputAxis(InputBinding.AXIS_FRONTLOADER_ARM) < 0 or InputBinding.getIsInputMouseAxisTriggered(InputBinding.AXIS_FRONTLOADER_ARM)) and self.movingTools[2].curRot[1] == 0.619 then
		setTextColor(1,0.1,0.1,1); setTextBold(true);
		renderText(0.25, 0.92, 0.03, g_i18n:getText("MCL_pleaseLower"))
		setTextColor(1,1,1,1); setTextBold(false);
	end;
-- MouseControlLimit (MCL)

end;

function ahwiFM700:onEnter()
end;

function ahwiFM700:ahwiSplitShapeCallback(shape, isBelow, isAbove, minY, maxY, minZ, maxZ)
	if not isBelow then
		self.SE.deleteShapes[shape] = shape;
	end;
end;
