fendt310LSA = {};
fendt310LSA.modDir = g_currentModDirectory;

function fendt310LSA.prerequisitesPresent(specializations)
	print("......LOADING FENDT FARMER 310 LSA BY RIVALBOMB......");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function fendt310LSA:load(xmlFile)
	
	-- INTERNAL SOUND init values --
	self.internalSound = {};
	self.internalSound.factor = 0.5;
	self.internalSound.doorOpenFactor = 0.9;
	self.internalSound.sideWindowOpenFactor = 0.8;
	self.internalSound.backWindowOpenFactor = 0.65;
	self.internalSound.dCwasTurnedOn = false;
	
	local path = fendt310LSA.modDir;
	
	local Xml;
	local file = path.."modDesc.xml";
		
	if fileExists(file) then
		Xml = loadXMLFile("modDesc", file);
	
		self.Fendt310author = getXMLString(Xml, "moddesc.author");
		self.Fendt310modNameDE = getXMLString(Xml, "moddesc.title.de");
		self.Fendt310modNameEN = getXMLString(Xml, "moddesc.title.en");
		self.Fendt310vehicleType = getXMLString(Xml, "moddesc.vehicleTypes.type#name");
		self.Fendt310storeNameDE = getXMLString(Xml, "moddesc.storeItems.storeItem.name.de");
		self.Fendt310storeNameEN = getXMLString(Xml, "moddesc.storeItems.storeItem.name.en");
	end;

	-- Uhr / clock
	self.uhrZeigerKlein = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.Uhr#zeigerKleinIndex"));
	self.uhrZeigerGross = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.Uhr#zeigerGrossIndex"));
	
	-- Blinkerhebel
	self.blinkerHebel = {};
	self.blinkerHebel.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.Blinkerhebel#index"))
	self.blinkerHebel.rotLeft = getXMLString(xmlFile, "vehicle.Fendt310Animations.Blinkerhebel#rotLeft");
	self.blinkerHebel.rotRight = getXMLString(xmlFile, "vehicle.Fendt310Animations.Blinkerhebel#rotRight");
	self.blinkerHebel.rotNormal = getXMLString(xmlFile, "vehicle.Fendt310Animations.Blinkerhebel#rotNormal");
	--local BlinkerHebelSound = getXMLString(xmlFile, "vehicle.Fendt310Animations.Blinkerhebel#soundFile");
	--if BlinkerHebelSound ~= nil and BlinkerHebelSound ~= "" then
	--	BlinkerHebelSound = Utils.getFilename(BlinkerHebelSound, self.baseDirectory);
	--	self.blinkerHebel.sound = createSample("BlinkerSound");
	--	self.blinkerHebel.soundPlayed = false;
    --	loadSample(self.blinkerHebel.sound, BlinkerHebelSound, false);
	--end;

	
	-- Zusätzliche Blinkleuchten in den Armaturen bei angehängten Anhängern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
end;
function fendt310LSA:delete()
	if self.blinkerHebel.sound ~= nil then
		delete(self.blinkerHebel.sound);
	end;
end;
function fendt310LSA:mouseEvent(posX, posY, isDown, isUp, button)
end;
function fendt310LSA:keyEvent(unicode, sym, modifier, isDown)
end;
function fendt310LSA:update(dt)
local _ = 			[[ INTERNAL-SOUND ]]

	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			self.internalSound.dCwasTurnedOn = true;
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;
		
		if self:getIsActiveForSound() then
			if self.sampleMotor ~= nil then
				local samples = {self.sampleMotor, self.sampleMotorRun2, self.sampleMotorStart, self.sampleMotorStop, self.sampleThreshingStop, self.sampleHonk, self.sampleRefuel, self.samplePipe, self.sampleThreshingStart, self.sampleReverseDrive, self.sampleThreshing, self.sampleCompression, self.sampleHydraulic, self.sampleCompressedAir, self.sampleCylinderedHydraulic};
				for _,sample in pairs(samples) do
					if sample ~= nil then
						local targetVolume = sample.volume;
						if self.camIndex == 2 and self.animations["winRBSource"].currentTime == 0 and self.animations["winLBSource"].currentTime == 0 and self.animations["winFrontSource"].currentTime == 0 and self.animations["winBackSource"].currentTime == 0 and self.animations["doorLeftSource"].currentTime == 0 and self.animations["doorRightSource"].currentTime == 0 then
							targetVolume = self.internalSound.factor*targetVolume;
						elseif self.camIndex == 2 and self.animations["winFrontSource"].currentTime ~= 0 then
							targetVolume = sample.volume;
						elseif self.camIndex == 2 and (self.animations["doorLeftSource"].currentTime ~= 0 or self.animations["doorRightSource"].currentTime ~= 0) then
							targetVolume = self.internalSound.doorOpenFactor*targetVolume;
						elseif self.camIndex == 2 and (self.animations["winRBSource"].currentTime ~= 0 or self.animations["winLBSource"].currentTime ~= 0) then
							targetVolume = self.internalSound.sideWindowOpenFactor*targetVolume;
						elseif self.camIndex == 2 and self.animations["winBackSource"].currentTime ~= 0 then
							targetVolume = self.internalSound.backWindowOpenFactor*targetVolume;
						end;
						if sample.sample ~= nil then --or volume ~= targetVolume then
							setSampleVolume(sample.sample,targetVolume)
						end;
					end;	
				end;
			end;
		end;
	end;
	if self.Fendt310author ~= "schlüterfan1977, RivalBomb" or self.Fendt310modNameDE ~= "Fendt Farmer 310 LSA" or self.Fendt310modNameEN ~= "Fendt Farmer 310 LSA" or self.Fendt310vehicleType ~= "FendtFarmer310LSA" or self.Fendt310storeNameDE ~= "FARMER 310 LSA" or self.Fendt310storeNameDE ~= "FARMER 310 LSA" then
		print("!!!!!! THIS SCRIPT IS ONLY FOR THE FENDT FARMER 310 LSA BY RIVALBOMB !!!!!!");
		print("!!! DO NOT STEAL MODS OR SCRIPTS !!!");
		print("- - - - - - - - - - - quit game - - - - - - - - - - -");
		requestExit();
	end;
	if self.isEntered then
		local input = 0;
		if self.axisForward ~= nil then
			input = self.axisForward;
		end;
	
		if self.sampleMotorRun ~= nil then
			local roundPerMinute = 620;
			if self.lastRoundPerMinute ~= nil and self.motor.lastMotorRpm ~= nil then
				roundPerMinute = self.lastRoundPerMinute*0.9 + (1-0.9)*(self.motor.lastMotorRpm-self.motor.minRpm);
			end;
			local rpmVolume = 0.8;
	
			if math.abs(input) > 0.01 then -- or self.motor.speedLevel ~= 0
				if self.camIndex == 2 and self.animations["winRBSource"].currentTime == 0 and self.animations["winLBSource"].currentTime == 0 and self.animations["winFrontSource"].currentTime == 0 and self.animations["winBackSource"].currentTime == 0 and self.animations["doorLeftSource"].currentTime == 0 and self.animations["doorRightSource"].currentTime == 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.factor;
				elseif self.camIndex == 2 and self.animations["winFrontSource"].currentTime ~= 0 then
					rpmVolume = Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8);
				elseif self.camIndex == 2 and (self.animations["doorLeftSource"].currentTime ~= 0 or self.animations["doorRightSource"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.doorOpenFactor;
				elseif self.camIndex == 2 and (self.animations["winRBSource"].currentTime ~= 0 or self.animations["winLBSource"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.sideWindowOpenFactor;
				elseif self.camIndex == 2 and self.animations["winBackSource"].currentTime ~= 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.backWindowOpenFactor;
				end;
			else
				if self.camIndex == 2 and self.animations["winRBSource"].currentTime == 0 and self.animations["winLBSource"].currentTime == 0 and self.animations["winFrontSource"].currentTime == 0 and self.animations["winBackSource"].currentTime == 0 and self.animations["doorLeftSource"].currentTime == 0 and self.animations["doorRightSource"].currentTime == 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.factor;
				elseif self.camIndex == 2 and self.animations["winFrontSource"].currentTime ~= 0 then
					rpmVolume = Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8);
				elseif self.camIndex == 2 and (self.animations["doorLeftSource"].currentTime ~= 0 or self.animations["doorRightSource"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.doorOpenFactor;
				elseif self.camIndex == 2 and (self.animations["winRBSource"].currentTime ~= 0 or self.animations["winLBSource"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.sideWindowOpenFactor;
				elseif self.camIndex == 2 and self.animations["winBackSource"].currentTime ~= 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.backWindowOpenFactor;
				end;
			end;
			if self.camIndex == 2 then
				setSampleVolume(self.sampleMotorRun.sample, rpmVolume);
			end;
		end;
	else
		if g_currentMission.driveControl ~= nil and not g_currentMission.driveControl.useModules.inDoorSound and self.internalSound.dCwasTurnedOn then
			g_currentMission.driveControl.useModules.inDoorSound = true;
		end;
	end;

	if self:getIsActive() then
local _ = 			[[ UHR ]]
		local clockTime = g_currentMission.environment.dayTime;
		local gr = clockTime / 10000;
		local kl = clockTime / 120000;
		setRotation(self.uhrZeigerKlein, 0, math.rad(-kl), 0);
		setRotation(self.uhrZeigerGross, 0, math.rad(-gr), 0);
	end;
end;
function fendt310LSA:updateTick(dt)

local _ = 			[[ BLINKER-LEUCHTEN ]]

	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);	
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);
		end;
	end;
	
local _ = 			[[ BLINKER-HEBEL ]]
	
	if self.turnSignalState~=nil then
		if self.turnSignalState==1 then	-- Blinker links
			setRotation(self.blinkerHebel.index, 0, math.rad(self.blinkerHebel.rotLeft), 0);
			--if self:getIsActiveForSound() and not (self.blinkerHebel.soundPlayed) and self.blinkerHebel.playSound then
			--	playSample(self.blinkerHebel.sound, 1, 1, 0);
			--	self.blinkerHebel.soundPlayed = true;
			--elseif not self.blinkerHebel.playSound then
			--	stopSample(self.blinkerHebel.sound);
			--	self.blinkerHebel.soundPlayed = false;
			--end;
		elseif self.turnSignalState==2 then	-- Blinker rechts
			setRotation(self.blinkerHebel.index, 0, math.rad(self.blinkerHebel.rotRight), 0);
		else
			setRotation(self.blinkerHebel.index, 0, math.rad(self.blinkerHebel.rotNormal), 0);
		end;
    end;
end;
function fendt310LSA:draw()	
end;
