--
-- InteractiveComponent Interface
-- Specifies an interactive component
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--
-- free for noncommerical-usage
--

InteractiveComponentInterface = {};

function InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, mt)

	local mTable = mt;
	if mTable == nil then
		mTable = Class(InteractiveComponentInterface);
	end;
    local instance = {};
    setmetatable(instance, mTable);
	
	instance.node = node;
	instance.highlight = highlight;
	instance.scaleX, instance.scaleY, instance.scaleZ = getScale(instance.highlight);
	instance.name = name;
	instance.mark = mark;
	setVisibility(mark,false);
	instance.scale = 0.01;
	instance.size = size;
	instance.isActive = true;
	instance.isMouseOver = false;
	instance.isOpen = false;
	instance.onMessage = Utils.getNoNil(onMessage, g_i18n:getText("ic_component_open"));
	instance.offMessage = Utils.getNoNil(offMessage, g_i18n:getText("ic_component_close"));
	instance.synch = true;

	instance.infoBarX = infobar.posX;
	instance.infoBarY = infobar.posY;
	instance.infoBarWidth = infobar.width;		
	instance.infoBar = infobar.hud;
	
	return instance;	
end;


function InteractiveComponentInterface:delete()
end;

function InteractiveComponentInterface:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveComponentInterface:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveComponentInterface:update(dt)	
	if self.isActive then
		if self.highlight ~= nil then
			if self.isMouseOver then	
				self.scale = self.scale - 0.0003 * dt;
				setScale(self.highlight, self.scaleX + self.scale, self.scaleY + self.scale, self.scaleZ);				
				if self.scaleX + self.scale <= 0.95 then
					self.scale = 0.05;
				end;				
			end;
		end;
	end;
end;

function InteractiveComponentInterface:draw()
	if self.isMouseOver then
		self.infoBar:render();
		setTextColor(1,1,1,1);
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_LEFT);
		local lineHeight = g_currentMission.hudHelpTextLineSpacing + g_currentMission.hudHelpTextSize;
		local posY = ((self.infoBarY + 0.0326) - lineHeight);
		if self.isOpen then
			renderText(self.infoBarX + 0.016, posY, 0.018, string.format(self.offMessage, self.name));
		else
			renderText(self.infoBarX + 0.016, posY, 0.018, string.format(self.onMessage, self.name));
		end;
		setTextAlignment(RenderText.ALIGN_LEFT);
	end;
end;

function InteractiveComponentInterface:doAction(forceValue)
	if forceValue ~= nil then
		self.isOpen = forceValue;
	else
		self.isOpen = not self.isOpen;
	end;
end;

function InteractiveComponentInterface:onEnter(dt)
	self.isMouseOver = true;
end;

function InteractiveComponentInterface:onExit(dt)
	self.isMouseOver = false;
end;

function InteractiveComponentInterface:setActive(isActive)
	self.isActive = isActive;
end;

function InteractiveComponentInterface:setVisible(isVisible)
	if self.mark ~= nil then
		setVisibility(self.mark, isVisible);
	end;
end;