-- Specjalizacja dla Ursus C360 --
-- Autor: Rolnik7245 --
-- 1.1: 10.07.2015 --
-- 1.2: 29.11.2015 --


C360 = {};

function C360.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function C360:load(xmlFile)
	self.isSelected = true;

	self.setHydraulicTime = 30;
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;

	local rotationPartNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;	
	
	self.Belka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Belka#index"));
	setVisibility((self.Belka), true);
	
	self.Sruba = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Sruba#index"));
	setVisibility((self.Sruba), false);
	
	self.Tur = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Tur#index"));
	setVisibility((self.Tur), true);

	self.PitchArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#Index"));
	self.PitchArmRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#refNode"));	
	
	self.ScrollParts = Utils.loadScrollers(self.components, xmlFile, "vehicle.Paski.Pasek", {}, false);
	
	local maska = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.maska#index"));
	if maska ~= nil then
		self.maska = maska;
	end;
	
	local drzwi_lewe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi_lewe#index"));
	if drzwi_lewe ~= nil then
		self.drzwi_lewe = drzwi_lewe;
	end;

	local drzwi_prawe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi_prawe#index"));
	if drzwi_prawe ~= nil then
		self.drzwi_prawe = drzwi_prawe;
	end;	

	local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zaczep#index"));
	if zaczep ~= nil then
		self.zaczep = zaczep;
	end;	
	
	self.swiatlo_vis = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.swiatlo2#index"));
	self.swiatlo2 = true;
	setVisibility(self.swiatlo_vis, not self.swiatlo2);
	
	openSoundFile = Utils.getFilename("Dzwieki/Elementy/maska_otwieranie.wav", self.baseDirectory);
	self.openSoundId = createSample("Sample");
	loadSample(self.openSoundId, openSoundFile, false);
	self.openPlaying = false;	
	
	clouseSoundFile = Utils.getFilename("Dzwieki/Elementy/maska_otwieranie.wav", self.baseDirectory);
	self.clouseSoundId = createSample("Sample");
	loadSample(self.clouseSoundId, clouseSoundFile, false);
	self.clousePlaying = false;

	open1SoundFile = Utils.getFilename("Dzwieki/Elementy/seatSound.wav", self.baseDirectory);
	self.open1SoundId = createSample("Sample");
	loadSample(self.open1SoundId, open1SoundFile, false);
	self.open1Playing = false;	
	
	clouse1SoundFile = Utils.getFilename("Dzwieki/Elementy/seatSound.wav", self.baseDirectory);
	self.clouse1SoundId = createSample("Sample");
	loadSample(self.clouse1SoundId, clouse1SoundFile, false);
	self.clouse1Playing = false;
	
	open2SoundFile = Utils.getFilename("Dzwieki/Elementy/seatSound.wav", self.baseDirectory);
	self.open2SoundId = createSample("Sample");
	loadSample(self.open2SoundId, open2SoundFile, false);
	self.open2Playing = false;	
	
	clouse2SoundFile = Utils.getFilename("Dzwieki/Elementy/seatSound.wav", self.baseDirectory);
	self.clouse2SoundId = createSample("Sample");
	loadSample(self.clouse2SoundId, clouse2SoundFile, false);
	self.clouse2Playing = false;
	
	wycieraczkaSoundFile = Utils.getFilename("Dzwieki/Elementy/wycieraczka.wav", self.baseDirectory);
    self.wycieraczkaSoundId = createSample("LizardHor12nSound");
    loadSample(self.wycieraczkaSoundId, wycieraczkaSoundFile, false);
    self.wycieraczkaPlaying = false;
	
	self.deszcz0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz0#index"));
	self.deszcz1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz1#index"));
	self.deszcz2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz2#index"));
	self.deszcz3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz3#index"));
	self.deszcz4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz4#index"));
	self.deszcz5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz5#index"));
	self.deszcz6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz6#index"));
	self.deszcz7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz7#index"));
	self.deszcz8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz8#index"));
	self.deszcz9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz9#index"));
	self.deszcz10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deszcz10#index"));
	
	self.isSelectable = true;
	
	--self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#armIndex"));
end;

function C360:delete()
	if self.wycieraczkaPlaying ~= nil then
		delete(self.wycieraczkaSoundId)
	end;	
end;

function C360:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility((self.Belka), false);
			setVisibility((self.Sruba), true);
		end;
	end;
	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility((self.Belka), true);
			setVisibility((self.Sruba), false);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setVisibility((self.Belka), true);
			setVisibility((self.Sruba), false);
		end;
	end;
	if jointType == Vehicle.JOINTTYPE_ATTACHABLEFRONTLOADER then
		if jointIndex == 4 then
			setVisibility((self.Tur), false);
		end;
	end;	
	self.updateJoint = true;
end;

function C360:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.Belka), true);
		setVisibility((self.Sruba), false);
	end;
	if jointIndex == 2 then
		setVisibility((self.Belka), true);
		setVisibility((self.Sruba), false);
	end
	if jointIndex == 3 then
		setVisibility((self.Belka), true);
		setVisibility((self.Sruba), false);
	end;
	
	if jointIndex == 4 then
		setVisibility((self.Tur), true);
	end;	
end;

function C360:keyEvent(unicode, sym, modifier, isDown)
	if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then	
		if isDown and sym == Input.KEY_KP_9 then
			self.swiatlo2 = not self.swiatlo2;
		end;
	end;

	if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then	
		if isDown and sym == Input.KEY_KP_7 then
			self.wycieraczka = not self.wycieraczka;
		end;
	end;
 end;
 
function C360:update(dt)	
	--[[if self.camIndex == 1 then
		setVisibility(self.armNode, true);
	else
		setVisibility(self.armNode, false);
	end;]]

	if self.isMotorStarted then
		self:setAnimationTime(26, self.animationParts[26].animDuration);
	else
		self:setAnimationTime(26, self.animationParts[26].offSet);	
	end;

	if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
		setVisibility(self.deszcz0, true);
		setVisibility(self.deszcz1, true);
		setVisibility(self.deszcz2, true);
		setVisibility(self.deszcz3, true);
		setVisibility(self.deszcz4, true);
		setVisibility(self.deszcz5, true);
		setVisibility(self.deszcz6, true);
		setVisibility(self.deszcz7, true);
		setVisibility(self.deszcz8, true);
		setVisibility(self.deszcz9, true);
		setVisibility(self.deszcz10, true);
	else
		setVisibility(self.deszcz0, false);
		setVisibility(self.deszcz1, false);
		setVisibility(self.deszcz2, false);
		setVisibility(self.deszcz3, false);
		setVisibility(self.deszcz4, false);
		setVisibility(self.deszcz5, false);
		setVisibility(self.deszcz6, false);
		setVisibility(self.deszcz7, false);
		setVisibility(self.deszcz8, false);
		setVisibility(self.deszcz9, false);
		setVisibility(self.deszcz10, false);
	end;

	if self.PitchArm ~= nil then
		local x, y, z = getRotation(self.PitchArmRefNode);
		setRotation(self.PitchArm, x * (-1.5), y, z);	
	end;	
	
	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
	if self:getIsActive() then
		self.setHydraulicTime = 30;
    end;
	
	if self:getIsActive() then
		if self.rotationPartLeft ~= nil then
			local x, y, z = getRotation(self.rotationPartLeft.node);
			x = (self.rotationPartLeft.maxRot[1] - self.rotationPartLeft.minRot[1]) * (self.rotatedTime/-1);
			setRotation(self.rotationPartLeft.node, x, y ,z);
		end;
	end;
	
	if self.isMotorStarted then
		self:setAnimationTime(1, 1);
		self:setAnimationTime(7, 1);
		self:setAnimationTime(23, 1);
		self:setAnimationTime(24, 1);
		self:setAnimationTime(25, 1);
	else 
		self:setAnimationTime(1, 0);
		self:setAnimationTime(7, 0);
		self:setAnimationTime(23, 0);
		self:setAnimationTime(24, 0);
		self:setAnimationTime(25, 0);
	end;
	
    if self.isClient then
        Utils.updateScrollers(self.ScrollParts, dt, self.isMotorStarted);
    end;	
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.maska);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_maska = true;
		else
			self.przy_maska = false;
		end;
		
    if self.przy_maska then
		if InputBinding.hasEvent(InputBinding.maska_c360) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
				self.sound1 = false;
				self.sound2 = true;
			elseif self.animationParts[2].clipStartTime  then
				self:setAnimationTime(2, self.animationParts[2].animDuration);	
				self.sound1 = true;
				self.sound2 = false;
			end;
		end;
    end;
	
	if self.przy_maska then
		if self.animationParts[2].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_maska_c360")), InputBinding.maska_c360);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_maska_c360")), InputBinding.maska_c360);
		end;
	end;	
	
	if self.isEntered then
		setVisibility(self.swiatlo_vis, not self.swiatlo2);
	end;
	
	
	if self.isEntered then 
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.swiatlo2 then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wlacz_swiatlo2_c360")), InputBinding.swiatlo2_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wylacz_swiatlo2_c360")), InputBinding.swiatlo2_c360);
			end;
		end;
	end;
	
	if self.sound1 then
		if not self.openPlaying then
			playSample(self.openSoundId, 1, 3, 3);
			self.openPlaying = true;
		end;      
    else
		if self.openPlaying then
		   stopSample(self.openSoundId);
		   self.openPlaying = false;
		end;        
    end;	
	
	if self.sound2 then
		if not self.clousePlaying then
			playSample(self.clouseSoundId, 1, 3, 3);
			self.clousePlaying = true;
		end;       
	else
		if self.clousePlaying then
			stopSample(self.clouseSoundId);
			self.clousePlaying = false;
		end;        
    end;

	if self.sound3 then
		if not self.open1Playing then
			playSample(self.open1SoundId, 1, 3, 3);
			self.open1Playing = true;
		end;      
    else
		if self.open1Playing then
		   stopSample(self.open1SoundId);
		   self.open1Playing = false;
		end;        
    end;	

	if self.sound4 then
		if not self.clouse1Playing then
			playSample(self.clouse1SoundId, 1, 3, 3);
			self.clouse1Playing = true;
		end;       
	else
		if self.clouse1Playing then
			stopSample(self.clouse1SoundId);
			self.clouse1Playing = false;
		end;        
    end;	

	if self.sound5 then
		if not self.open2Playing then
			playSample(self.open2SoundId, 1, 3, 3);
			self.open2Playing = true;
		end;      
    else
		if self.open2Playing then
		   stopSample(self.open2SoundId);
		   self.open2Playing = false;
		end;        
    end;	

	if self.sound6 then
		if not self.clouse2Playing then
			playSample(self.clouse2SoundId, 1, 3, 3);
			self.clouse2Playing = true;
		end;       
	else
		if self.clouse2Playing then
			stopSample(self.clouse2SoundId);
			self.clouse2Playing = false;
		end;        
    end;	
	
    if self.przy_maska then
		if Input.isKeyPressed(Input.KEY_n) then
			self:setAnimationTime(3,self.animationParts[3].animDuration);
		else 
			self:setAnimationTime(3,self.animationParts[3].offSet);
		end;
    end;
	
	if self.przy_maska then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("pompka_paliwa_c360")), InputBinding.pompka_c360);
	end;
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.drzwi_lewe);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_drzwi_lewe = true;
		else
			self.przy_drzwi_lewe = false;
		end;
		
    if self.przy_drzwi_lewe then
		if InputBinding.hasEvent(InputBinding.drzwi_lewe_c360) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
				self.sound3 = true;
				self.sound4 = false;
			elseif self.animationParts[4].clipStartTime  then
				self:setAnimationTime(4, self.animationParts[4].animDuration);	
				self.sound3 = false;
				self.sound4 = true;
			end;
		end;
    end;
	
    if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.drzwi_lewe_c360) then
				if self.animationParts[4].clipEndTime then
					self:setAnimationTime(4, self.animationParts[4].offSet);
					self.sound3 = true;
					self.sound4 = false;
				elseif self.animationParts[4].clipStartTime  then
					self:setAnimationTime(4, self.animationParts[4].animDuration);	
					self.sound3 = false;
					self.sound4 = true;
				end;
			end;
		end;
    end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.animationParts[4].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_drzwi_lewe_c360")), InputBinding.drzwi_lewe_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_drzwi_lewe_c360")), InputBinding.drzwi_lewe_c360);
			end;
		end;
	end;	

	if self.przy_drzwi_lewe then
		if self.animationParts[4].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_drzwi_out_c360")), InputBinding.drzwi_lewe_c360);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_drzwi_out_c360")), InputBinding.drzwi_lewe_c360);
		end;
	end;		
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.drzwi_prawe);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_drzwi_prawe = true;
		else
			self.przy_drzwi_prawe = false;
		end;
		
    if self.przy_drzwi_prawe then
		if InputBinding.hasEvent(InputBinding.drzwi_prawe_c360) then
			if self.animationParts[5].clipEndTime then
				self:setAnimationTime(5, self.animationParts[5].offSet);
				self.sound5 = true;
				self.sound6 = false;
			elseif self.animationParts[5].clipStartTime  then
				self:setAnimationTime(5, self.animationParts[5].animDuration);	
				self.sound5 = false;
				self.sound6 = true;
			end;
		end;
    end;
	
    if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.drzwi_prawe_c360) then
				if self.animationParts[5].clipEndTime then
					self:setAnimationTime(5, self.animationParts[5].offSet);
					self.sound5 = true;
					self.sound6 = false;
				elseif self.animationParts[5].clipStartTime  then
					self:setAnimationTime(5, self.animationParts[5].animDuration);	
					self.sound5 = false;
					self.sound6 = true;
				end;
			end;
		end;
    end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.animationParts[5].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_drzwi_prawe_c360")), InputBinding.drzwi_prawe_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_drzwi_prawe_c360")), InputBinding.drzwi_prawe_c360);
			end;
		end;
	end;	

	if self.przy_drzwi_prawe then
		if self.animationParts[5].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_drzwi_out_c360")), InputBinding.drzwi_prawe_c360);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_drzwi_out_c360")), InputBinding.drzwi_prawe_c360);
		end;
	end;	
	
	if self.realLightsActive then
		self:setAnimationTime(6,self.animationParts[6].animDuration);
	else 
		self:setAnimationTime(6,self.animationParts[6].offSet);
	end;
	
	if self.isClient then
		if self.isEntered then
			if not self.brakeLightsVisibility then
				if self.animationParts[8].clipEndTime then
					self:setAnimationTime(8, self.animationParts[8].offSet);
				end;
			end;
			if self.brakeLightsVisibility then
				if self.animationParts[8].clipStartTime then
					self:setAnimationTime(8, self.animationParts[8].animDuration);	
				end;
			end;
		end;	
	end;
	
	if self.handbrake then
		self:setAnimationTime(9,self.animationParts[9].animDuration);
	else 
		self:setAnimationTime(9,self.animationParts[9].offSet);
	end;
	
	if self.isEntered then
		if self.movingDirection > 0 then
			if not self.isHired then
				if Input.isKeyPressed(Input.KEY_w) or self.lastSpeed*3600 > 1 then
					self:setAnimationTime(11,self.animationParts[11].animDuration);
				else 
					self:setAnimationTime(11,self.animationParts[11].offSet);
				end;		
			end;
		end;
	end;
	
	if self.isEntered then
		if not self.brakeLightsVisibility then
			if not self.isHired then
				if self.movingDirection < 0 then
					if Input.isKeyPressed(Input.KEY_s) and self.lastSpeed*3600 > 1 then
						self:setAnimationTime(12,self.animationParts[12].animDuration);
					else 
						self:setAnimationTime(12,self.animationParts[12].offSet);
					end;
				end;
			end;
		end;
	end;
	
	if self.isEntered then
		if not self.brakeLightsVisibility and self.lastSpeed*3600 < 1 then
			if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
				self:setAnimationTime(22,self.animationParts[22].animDuration);
			else 
				self:setAnimationTime(22,self.animationParts[22].offSet);
			end;
		end;
	end;
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.zaczep);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_zaczep = true;
		else
			self.przy_zaczep = false;
		end;
	
	if self.isEntered then
		if self.wycieraczka then
			self:setAnimationTime(14, 1);
			self.sound7 = true;
		else
			self:setAnimationTime(14, 0);
			self.sound7 = false;
		end;
	end;
	
	if self.isEntered then
	    if self.sound7 then
		   if not self.wycieraczkaPlaying then
				playSample(self.wycieraczkaSoundId, 0, 1, 0);
				self.wycieraczkaPlaying = true;
			end;
		else
			if self.wycieraczkaPlaying then
				stopSample(self.wycieraczkaSoundId);
				self.wycieraczkaPlaying = false;
			end;
		end;
	end;
	
	if not self.isEntered then
	    if self.sound7 then
			if self.wycieraczkaPlaying then
				stopSample(self.wycieraczkaSoundId);
				self.wycieraczkaPlaying = false;
			end;
		end;
	end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.dach_c360) then
				if self.animationParts[15].clipEndTime then
					self:setAnimationTime(15, self.animationParts[15].offSet);
				elseif self.animationParts[15].clipStartTime  then
					self:setAnimationTime(15, self.animationParts[15].animDuration);	
				end;
			end;
		end;
    end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.animationParts[15].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_dach_c360")), InputBinding.dach_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_dach_c360")), InputBinding.dach_c360);
			end;
		end;
	end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.szyba_c360) then
				if self.animationParts[16].clipEndTime then
					self:setAnimationTime(16, self.animationParts[16].offSet);
				elseif self.animationParts[16].clipStartTime  then
					self:setAnimationTime(16, self.animationParts[16].animDuration);	
				end;
			end;
		end;
    end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.animationParts[16].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("otworz_szyba_c360")), InputBinding.szyba_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zamknij_szyba_c360")), InputBinding.szyba_c360);
			end;
		end;
	end;
	
	if self.isEntered then
		if self.lastSpeed*3600 > 12 then
			self:setAnimationTime(17,self.animationParts[17].animDuration);
		else 
			self:setAnimationTime(17,self.animationParts[17].offSet);
		end;
	end;
	
	if self.isEntered then
		if self.movingDirection > 0 then
			if self.lastSpeed*3600 > 1 then
				if Input.isKeyPressed(Input.KEY_w) then
					self:setAnimationTime(18,self.animationParts[18].animDuration);
				else 
					self:setAnimationTime(18,self.animationParts[18].offSet);
				end;
			end;
		end;
	end;
	
	if self.isEntered then
		if self.movingDirection < 0 then
			if self.lastSpeed*3600 > 1 then
				if Input.isKeyPressed(Input.KEY_s) then
					self:setAnimationTime(18,self.animationParts[18].animDuration);
				else 
					self:setAnimationTime(18,self.animationParts[18].offSet);
				end;
			end;
		end;
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_b) then
			if self.animationParts[20].clipEndTime then
				self:setAnimationTime(20, self.animationParts[20].offSet);
			elseif self.animationParts[20].clipStartTime  then
				self:setAnimationTime(20, self.animationParts[20].animDuration);	
			end;
		end;
    end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_0) then
			self:setAnimationTime(21,self.animationParts[21].animDuration);
		else 
			self:setAnimationTime(21,self.animationParts[21].offSet);
		end;
    end;
	
	if self.isEntered then	
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
			if self.wycieraczka then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wycieraczka_stop_c360")), InputBinding.wycieraczka_c360);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("wycieraczka_c360")), InputBinding.wycieraczka_c360);
			end;
		end;
	end;
end;

function C360:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function C360:setRopePanel(isRopePanel)
end;

function C360:mouseEvent(posX, posY, isDown, isUp, button)
end;

function C360:validateAttacherJoint(implement, jointDesc, dt)
return true;
end;

function C360:draw()
end;