--
-- EmySPC600---
-- Specialization for Emy Ago-Modding 
-- @author Ago-Modding ( www.modhoster.de   FB: www.facebook.com/ago.systemtech );
-- @date  		12/01/2015;
-- free for non commerical-usage.
--
Emy = {};

function Emy.prerequisitesPresent(specializations)
    return true;
end;


function Emy:load(xmlFile)
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, Emy.getIsAreaActive);
	self.setAvvio = SpecializationUtil.callSpecializationsFunction("setAvvio");	
	self.setAdditional = SpecializationUtil.callSpecializationsFunction("setAdditional");  --extra funzioni---
	-- Animazione Rotazione Rotori --	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.avvio = false;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
	----------- Suono Erpice---------
	
	local rotarySound  = getXMLString(xmlFile, "vehicle.rotarySound#file");
    if rotarySound  ~= nil and rotarySound  ~= "" then
        rotarySound  = Utils.getFilename(rotarySound, self.baseDirectory);
        self.rotarySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#pitchOffset"), 1.0);
	    self.rotarySoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#radius"), 50);
        self.rotarySoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#innerRadius"), 10);
        self.rotarySoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#volume"), 1.0);
        self.rotarySound = createAudioSource("rotarySound", rotarySound, self.rotarySoundRadius, self.rotarySoundInnerRadius, self.rotarySoundVolume, 0);
        link(self.components[1].node, self.rotarySound);
        setVisibility(self.rotarySound, false);
	 end;
	
end;

function Emy:delete()
	if self.rotarySound ~= nil then
        delete(self.rotarySound);
		self.rotarySound = nil;
    end;
end;

function Emy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Emy:keyEvent(unicode, sym, modifier, isDown)
end;
function Emy:readStream(streamId, connection)
   self:setAvvio(streamReadBool(streamId), true);
   setVisibility(self.rotarySound, self.setAvvio);
end;

function Emy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.avvio);
end;

function Emy:readUpdateStream(streamId, timestamp, connection)
end;

function Emy:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Emy:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
		  self:setAvvio(not self.avvio);
		end;
		if InputBinding.hasEvent(InputBinding.ADDITIONAL) then
			if self:getRealAnimationTime("Additional") > 750 then
				self:playAnimation("Additional", -1, nil);
			elseif self:getRealAnimationTime("Additional") < 750 then
				self:playAnimation("Additional", 1, nil);
			end;
		end;
	end;
end;

function Emy:updateTick(dt)
	if self:getIsActive() then
		if self.avvio then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
					setVisibility(self.rotarySound, true);
				end;
            end;
	
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
					setVisibility(self.rotarySound, false);
				end;
			end;
		
        end;
	end;
end;

function Emy:draw()
	-- if self.avvio then
		-- g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	-- else
		-- g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	-- end;
		if self:getRealAnimationTime("Additional") > 0 then
			g_currentMission:addHelpButtonText(g_i18n:getText("Additional_ON"), InputBinding.ADDITIONAL);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Additional_OFF"), InputBinding.ADDITIONAL);
		end;
end;

function Emy:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
		setVisibility(self.rotarySound, false);
	end;
	self.avvio = false;
end;
function Emy:onLeave()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.avvio = false;
	
end;

function Emy:onDetach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
		setVisibility(self.rotarySound, false);
	end;
	self.avvio = false;
	end;

function Emy:onAttach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
		setVisibility(self.rotarySound, false);
	end;
	self.avvio = false;
end;

function Emy:setAvvio(avvio, noEventSend)
	SetAvvioEvent.sendEvent(self, avvio, noEventSend)
	self.avvio = avvio;
end;

function Emy:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
		return superFunc(self, area) and self.avvio;
    end;
	return self.avvio;	
end;

--------------------/////EVENT\\\\\\\\\\\--------------
SetAvvioEvent = {};
SetAvvioEvent_mt = Class(SetAvvioEvent, Event);
InitEventClass(SetAvvioEvent, "SetAvvioEvent");

function SetAvvioEvent:emptyNew()
    local self = Event:new(SetAvvioEvent_mt);
    self.className="SetAvvioEvent";
    return self;
end;

function SetAvvioEvent:new(vehicle, avvio)
    local self = SetAvvioEvent:emptyNew()
    self.vehicle = vehicle;
	self.avvio = avvio;
    return self;
end;

function SetAvvioEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.avvio = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAvvioEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.avvio);
end;

function SetAvvioEvent:run(connection)   
	if not connection:getIsServer() then
    g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
    self.object:setAvvio(self.avvio, true);
	end;
end;


function SetAvvioEvent.sendEvent(vehicle, avvio, noEventSend)
  if avvio ~= vehicle.avvio and (noEventSend == nil or noEventSend == false) then
    if g_server ~= nil then
      g_server:broadcastEvent(SetAvvioEvent:new(vehicle, avvio), nil, nil, vehicle);
    else
      g_client:getServerConnection():sendEvent(SetAvvioEvent:new(vehicle, avvio));
    end;
  end;
end;