-- frpWheels
-- provides parallel steering wheels for kotte frp
--
-- @author  Sven777b
-- @date  05/2013
--

frpWheels = {};

function frpWheels.prerequisitesPresent(specializations)
    return true;
end;

function frpWheels:load(xmlFile)
	self.faxes = {};
	local i=0;
	while true do
		local base = string.format("vehicle.frpWheels.axis(%d)",i);
		if not hasXMLProperty(xmlFile,base) then break; end;
		local axis = {};
		axis.joint = Utils.indexToObject(self.components, getXMLString(xmlFile, base.."#joint"));
		axis.baseRot = {getRotation(axis.joint)};
		axis.wheels = {};
		local n=1;
		while true do
			local wInd = getXMLString(xmlFile, base.."#wheel"..n);
			if wInd == nil then break; end;
			local w = {};
			w.index = Utils.indexToObject(self.components, wInd);
			w.baseRot = {getRotation(w.index)};
			table.insert(axis.wheels,w);
			n=n+1;
		end;
		axis.steer = Utils.getNoNil(getXMLInt(xmlFile,base.."#steeraxis"),1);
		axis.roll = getXMLInt(xmlFile,base.."#rollaxis");
		axis.rscale = Utils.getNoNil(getXMLInt(xmlFile,base.."#rscale"),1);
		table.insert(self.faxes, axis);
		i=i+1;
	end;
	local refComp = getXMLInt(xmlFile,"vehicle.frpWheels#refComp");
	self.refComp=self.components[refComp];
	local refWheel = getXMLInt(xmlFile,"vehicle.frpWheels#refWheel");
	self.refWheel=self.wheels[refWheel];
	self.rollFactor = 1;
end;

function frpWheels:delete()
end;

function frpWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function frpWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function frpWheels:update(dt)
end;

function frpWheels:updateTick(dt)
	if self:getIsActive() then
		if not self.hasWheelGroundContact then
			self.rollFactor = math.max(0,self.rollFactor - (0.0001*dt));
		else
			if self.rollFactor ~= 1 then
				self.rollFactor = 1;
			end;
		end;
		local xr,yr,zr = getRotation(self.refWheel.driveNode);
		local xs,ys,zs = getRotation(self.refComp.node);
		for _,a in ipairs(self.faxes) do
			--roll
			if a.roll ~= nil then
				for _,w in ipairs(a.wheels) do
					local roll = w.baseRot;
					roll[a.roll] = roll[a.roll] + ((xr - roll[a.roll]) * self.rollFactor);
					setRotation(w.index, unpack(roll));
				end;
			end;

			--steer
	          local x, y, z = worldDirectionToLocal(self.refComp.node, localDirectionToWorld(self.components[1].node, 0, 0, 1));
	          local angle = math.acos(z / Utils.vector2Length(x, z));
	          if x > 0 then
	            angle = -angle
	          end;
	          --soften angle... 

			local steer = {};
			steer[1],steer[2],steer[3] = unpack(a.baseRot);
			steer[a.steer] = steer[a.steer] + (angle*a.rscale);
			setRotation(a.joint, unpack(steer));
		end;
	end;
end;

function frpWheels:draw()
end;
